;***************************************************************************************
;
;    8080 Emulator Common Declarations
;
;***************************************************************************************
	.include 	"p24FJ128GB206.inc"   

; Option DIP switch definitions

	.equ	C13_MONITOR_SW,13	;MONITOR dip switch
	.equ	C14_DRV_TYPE3_SW,14	;Drive type bit 3 dip switch
	.equ	G2_DRV_TYPE2_SW,2	;Drive type bit 2 dip switch
	.equ	G3_DRV_TYPE1_SW,3	;Drive type bit 1 dip switch
	.equ	F7_DRV_TYPE0_SW,7	;Drive type bit 0 dip switch

; Drive Equates

	.equ	NUM_DRIVE_TYPES,16	;number of drive types possible

	.equ	INDEX_460,460/4	;460us index offset
	.equ	INDEX_360,360/4	;360us index offset Shugart to Pertec
	.equ	INDEX_260,260/4	;260us index offset
	.equ	INDEX_160,160/4	;160us index offset
	.equ	INDEX_60,60/4	;60us index offset
	.equ	INDEX_0,8/4		;0us index offset (8us actually used,
				;  can't be zero)

	.equ	STEP_TIME48,48000/4	;head step time, 48ms at 250khz
	.equ	STEP_TIME25,25000/4	;head step time, 25ms at 250khz
	.equ	STEP_TIME10,10500/4	;head step time, 10.5ms at 250khz
	.equ	STEP_TIME8,8000/4	;head step time, 8ms at 250khz
	.equ	STEP_TIME6,6000/4	;head step time, 6ms at 250khz
	.equ	STEP_TIME3,3000/4	;head step time, 3ms at 250khz

	.equ	DT_ALTAIR8,0	;original Altair 8" drive
	.equ	DT_SHUGART8,1	;8" Shugart as Altair 8"
	.equ	DT_ALTAIR5,2	;original Altair 5.25" drive
	.equ	DT_SHUGART5,3	;5.25" Shugart as Altait 5.25"
	.equ	DT_SOFT5AS8,4	;5.25" as 8" drive
	.equ	DT_HDFLOPPY,5	;5.25" HD drive with 1.5Mb
	.equ	DT_SERIAL5,6	;5.25" serial drive
	.equ	DT_SERIAL8,7	;8" serial drive
	.equ	DT_FD3712,8		;iCOM FD3712 (single density)
	.equ	DT_FD3812,9		;iCOM FD3812 (double density)

; Serial drive baud rates

	.equ	BAUD_403200,9	;BRG value for this baud rate
	.equ	BAUD_460800,8	;BRG value for this baud rate
	.equ	BAUD_230400,16	;BRG value for this baud rate

; Misc Equates

	.equ	F0_BUS_PINTE,0	;PINTE signal from S100 bus
	.equ	D8_INTERRUPT_OUT,8	;1=interrupt to S100 asserted
	.equ	PARAM_FLASH,0x13800	;loacation of ParamTable in flash mem
	.equ	STACK_ADDR,0x7800	;start of stack
	.equ	STACK_END,0x7FFF	;last byte of stack
