;	UTS30 Disk Controller ROM disassembly
;	Sperry part# F3990-00
;	last edit: 7/20/25

	ORG	0000h

;	MACLIB	Z80		;no maclib for my zasm 3.0
;
;	I'm not sure if 10h-14h are the actual FDC ports ???
;
;	MB8877A Floppy Controller
;	register selection
;	A2	A1	A0	read	write
; --------------------------------------------------
; 10h	0	0	0	status	command
; 11h	0	0	1	track	track
; 12h	0	1	0	sector	sector
; 13h	0	1	1	data	data
; 14h	1	0	0	dflag*	select drive
;
; *dflag bit 0 set = ready, bit 5 set = head loaded

H0000	DI  	
	JMP 	H00A0
	NOP 	
	NOP 	
	NOP 	
	NOP 	
	DI  	
	JMP 	H00B3
	NOP 	
	NOP 	
	NOP 	
	NOP 	
	DI  	
	JMP 	H00E7
	NOP 	
	NOP 	
	NOP 	
	NOP 	
H0018	DI  	
	JMP 	H1417
	NOP 	
	NOP 	
	NOP 	
	NOP 	
	DI  	
	JMP 	H19A0
	NOP 	
	NOP 	
	NOP 	
	NOP 	
	DI  	
	PUSH	PSW
	MVI 	A,35h
	JMP 	H1237
	NOP 	
	DI  	
	PUSH	PSW
	MVI 	A,36h
	JMP 	H1237
	NOP 	
	DI  	
	PUSH	PSW
	MVI 	A,37h
	JMP 	H1237

	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h
	PUSH	PSW			;0066
	MVI 	A,00h
	OUT 	4Ah
	JMP 	H1244

	DW H0000			;006E
	DW H0F13
	DW H0F53
	DW H0F30
	DW H0F53
	DW H0DB6
	DW H0E4E
	DW H0E7C
	DW H0EBD
	DW H0FC0
	DW H0FC0
	DW H0FC0
	DW H0FA8
	DW H0F8C
	DW H0F85
	DW H0FAF
	DW H0FC0
	DW H0F7E
	DW H0FD2
	DW H0FC1
	DW H0FFD
	DW H0FE6
	DW H0F5C
	DW H0FC0
	DW H0FC0

;	in IM 2, the I reg contains the upper 8 bits of the interrupt address
;	(page 0FFh) and the R (refresh) reg holds the lower 8 bits

H00A0	PUSH	PSW
	LDAI			;ED 57 put I into A (I affects flags)	
	MVI 	A,30h
	JNZ	H1237		;based on I. taken if interrupt handler already set ?
	LDAR			;ED 5F put R into A (R affects flags)	
	MVI 	A,30h
	JM 	H1237		;based on R. taken if interrupt handler already set ?
	MVI 	A,80h
	STAR			;ED 4F put A into R
;
;	here for initial cold start ?
; 	
H00B3	EXX			;D9	
	MVI 	C,00h
	EXX 	
	DI  	
	MVI 	A,09h
	OUT 	02h
	MVI 	A,80h
	OUT 	02h
	LXI 	H,H0CC5
	LXI 	B,0802h		;output 8 bytes to port 2
	OUTIR 	
	LXI 	H,H0CD5
	LXI 	B,1002h		;output 16 bytes to port 2
	OUTIR 	
	LXI 	H,H0CE5		;2 bytes out port 0
	LXI 	B,0200h
	OUTIR 	
	MVI 	A,05h
	OUT 	02h
	MVI 	A,38h
	OUT 	02h
	MVI 	B,00h
H00E2	NOP 	
	DJNZ  	H00E2
	JR    	H00EB
H00E7	EXX 	
	MVI 	C,80h
	EXX 	
H00EB	LXIX  	H0148		;jump address
	LXI 	SP,H8000
	SUB 	A
	OUT 	49h
	OUT 	4Bh
	OUT 	50h
	MVI 	A,0C8h
	OUT 	4Ah
	OUT 	67h
	MVI 	A,5
	OUT 	18h
	MVI 	A,0FFh		; ???
	OUT 	10h		;FDC command
	MVI 	A,04h
	OUT 	18h
	MVI 	A,0FFh		; ???
	OUT 	10h		;FDC command
	MVI 	A,06h
	OUT 	18h
	SUB 	A		; = 0 restore
	OUT 	10h		;FDC command
	MVI 	A,03h
	OUT 	18h
	MVI 	A,0FFh		;???
	OUT 	10h		;FDC command
	MVI 	A,07h
	OUT 	18h
	SUB 	A		; = 0 restore
	OUT 	10h		;FDC command
	OUT 	19h
	OUT 	1Eh
	OUT 	1Dh
	OUT 	17h
	OUT 	16h
	OUT 	13h
	OUT 	12h
	MVI 	A,09h
	OUT 	02h
	MVI 	A,0C0h
	OUT 	02h
	MVI 	A,00h
	STAI  	
	IM2			;sets interrupt mode 2   	
	PCIX			;jump to H0148 	

H0143	DB 4			;4 byte signature
	DB	9Eh,61h,61h,9Eh	;integrity signature
;
;	check rom integrity
;
H0148	LXIX  	H1FFF		;end of rom, after signature bytes
	LXI 	H,H0143		;integrity signature
	MOV 	B,M
H0150	DCXIX 	
	INX 	H
	LDX   	A,00h
	CMP 	M		;compare signature bytes
	JRNZ  	H015E		;mis-match so hang for corrupt rom
	DCR 	B
	JRNZ  	H0150
	JR    	H0160		;ok to proceed
H015E	JR    	H015E		;infinite loop hang
;
;	ROM ok
;
H0160	OUT 	60h
	LXI 	H,H2000
	MVI 	A,80h
	OUT 	49h
	SUB 	A
	MOV 	M,A
	OUT 	49h
	EXX 	
	SETB  	5,C
	MVI 	E,9Eh
	EXX 	
	MOV 	A,M
	MVI 	B,10h
H0176	NOP 	
	DJNZ  	H0176
H0179	EXX 	
	MVI 	E,00h
	EXX 	
	LXIX  	H0208		;jump address
	JR    	H0193

H0183	DB 0D1h,0Eh,50h,07h,00h,00h,0Eh,0A0h
	DB 1Bh,19h,0Dh,1Ch,0DDh,57h,00h,65h

H0193	LXI 	H,H0183
	LXI 	B,1021h		;16 bytes out 21h
	MOV 	A,B		;counter
H019A	DCR 	A
	OUT 	20h
	OUTI			;read M out C (21h) 	
	JRNZ  	H019A		;repeat until B = 0
	MVI 	A,36h
	OUT 	48h
	MVI 	C,64h		;port #
H01A7	MVI 	E,00h
H01A9	MOV 	A,E
	OUT 	63h
	SUB 	A
	MOV 	B,A
	MVI 	D,10h		;1000h counter ?
H01B0	OUTP  	A		;out A to port C (64h)
	INR 	B
	DCR 	D
	JRNZ  	H01B0
	DCR 	E
	JRNZ  	H01A9
	MOV 	A,L
	ANA 	A
	JRZ   	H01DC
	MVI 	E,02h
	LXI 	H,H1E93
H01C2	INX 	H
	MOV 	A,M
	OUT 	63h
	MVI 	D,0Dh
H01C8	INX 	H
	MOV 	B,M
	INX 	H
	MOV 	A,M
	OUTP  	A
	DCR 	D
	JRNZ  	H01C8
	DCR 	E
	JRNZ  	H01C2
	MVI 	A,16h
	OUT 	48h
	MVI 	L,00h
	JR    	H01A7
H01DC	LXI 	H,H1D46
	MVI 	A,30h
	EXX 	
	MVI 	B,3Ah
	MVI 	H,02h
	EXX 	
H01E7	MOV 	E,A
	OUT 	63h
	MVI 	B,03h
	MVI 	D,09h
H01EE	INX 	H
	MOV 	A,M
	OUTP  	A
	INR 	B
	DCR 	D
	JRNZ  	H01EE
	MOV 	A,E
	INR 	A
	EXX 	
	CMP 	B
	EXX 	
	JRNZ  	H01E7
	MVI 	A,40h
	EXX 	
H0200	MVI 	B,5Bh
	DCR 	H
	EXX 	
	JRNZ  	H01E7
	PCIX			;to H0208  	
H0208	LXI 	H,0000h		;start of ROM
	LXI 	B,2000h		;length of ROM
	SUB 	A
H020F	ADD 	M
	ACI 	00h
	CCI   	
	JPE	H020F
	CPI 	58h
	JRZ   	H022F
	CALL	H0318
	MVI 	A,30h
	OUT 	4Ah
	MVI 	A,20h
	MVI 	B,20h
	LXI 	D,H1045		;'ROM CHECKSUM'
	CALL	H0C79
	JMP 	H015E		;go hang
H022F	LXIY  	H0236
	JMP 	H0A6D
H0236	JNZ	H050C
	LXIY  	H0240
	JMP 	H0A71
H0240	JNZ	H050C
	MVI 	A,54h
	OUT 	4Bh
	MVI 	A,0C8h
	OUT 	4Ah
	LXI 	H,H2000
	LXI 	D,H2000
	MVI 	A,07h
H0253	MOV 	M,A
	DAD 	D
	DCR 	A
	JRNZ  	H0253
	MVI 	A,0AAh
	OUT 	4Bh
	MVI 	A,08h
H025E	ANA 	A
	DSBC  	D 
	MOV 	M,A
	DCR 	A
	CPI 	01h
	JRNZ  	H025E
	MVI 	A,54h
	OUT 	4Bh
	MVI 	A,07h
H026D	CMP 	M
	MVI 	M,00h
	JNZ	H0505
	DAD 	D
	DCR 	A
	JRNZ  	H026D
	MVI 	A,0AAh
	OUT 	4Bh
	MVI 	A,08h
H027D	ANA 	A
	DSBC  	D 
	CMP 	M
	MVI 	M,00h
	JNZ	H0505
	DCR 	A
	CPI 	01h
	JRNZ  	H027D
H028B	MVI 	A,00h
	OUT 	4Bh
	MVI 	A,32h
	OUT 	48h
	MVI 	A,6Ch
	OUT 	4Ch
	MVI 	A,44h
	STA 	HC000
	MVI 	A,4Bh
	STA 	HE000
	MVI 	A,0C9h
	OUT 	4Ah
	NOP 	
	NOP 	
	LDA 	HC000
	CPI 	4Bh
	JRNZ  	H02B5
	LDA 	HE000
	CPI 	44h
	JRZ   	H02B9
H02B5	EXX 	
	SETB  	4,C
	EXX 	
H02B9	MVI 	A,0E8h
	OUT 	4Ah
	SUB 	A
	STA 	HFFFD
	LXI 	H,H8000+0B40h
	SHLD	HFFFE
	MVI 	D,02h
	EXX 	
	MOV 	B,C
	EXX 	
	LXIX  	H02D3
	JMP 	H14C0
H02D3	JRZ   	H02DC
	EXX 	
	MOV 	C,B
	SETB  	1,C
	EXX 	
	JR    	H030E
H02DC	MVI 	A,0C0h
	OUT 	49h
	MVI 	A,0AAh
	STA 	H2000
	MVI 	A,54h
	STA 	H2000+1
	MVI 	A,40h
	OUT 	49h
	MVI 	A,55h
	STA 	H2000+2
	MVI 	A,2Ah
	STA 	H2000+3
	MVI 	A,0FFh
	STA 	H8000+0B51h
	MVI 	A,01h
	STA 	H8000+0B40h
	EXX 	
	OUTP  	A
	MOV 	A,C
	MOV 	C,B
	CPI 	4Dh
	JRZ   	H030D
	SETB  	2,C
H030D	EXX 	
H030E	JMP 	H036D
H0311	LXIX  	H0318
	JMP 	H0193
H0318	MVI 	A,6Ch
	STA 	HFFFA
	OUT 	4Ch
	LXI 	H,HC000
	MVI 	M,20h			;space
	LXI 	D,HC000+1
	LXI 	B,07CFh			;25 lines by 80 chars
	LDIR				;clear display memory C000-C7D0  	
	LXI 	H,HD000
	MVI 	M,00h
	LXI 	D,HD001
	LXI 	B,07CFh			;25 x 80
	LDIR				;clear display attributes D000-D7D0				  	
	LXI 	H,HC000+5
	SHLD	HA900+2
	MVI 	D,19h			;25 lines
	LXIY  	HC7E0
	LXIX  	HD7E0
	LXI 	B,0050h			;80 chars
	LXI 	H,H6000
H034F	STY   	L,00h
	INXIY 	
	STX   	H,00h
	INXIX 	
	DAD 	B
	DCR 	D
	JRNZ  	H034F
	MVI 	A,01h
	OUT 	20h
	MVI 	A,50h
	OUT 	21h
	MVI 	A,32h
	STA 	HFFFB
	OUT 	48h
	RET 	
H036D	LXI 	H,HA900
	MVI 	M,00h
	LXI 	D,HA900+1
	LXI 	B,0020h
	LDIR  	
	CALL	H0318
	MVI 	A,22h
	STA 	HD7D0
	LDA 	HC7D0
	STA 	HC7D1
	LDA 	HD7D1
	CPI 	22h
	JRZ   	H03D7
	MVI 	A,0F8h
	OUT 	4Ah
	NOP 	
	NOP 	
	MVI 	A,22h
	STA 	HD7D0
	INR 	A
	STA 	HD7D1
	LDA 	HC7D1
	STA 	HC7D1
	LDA 	HD7D1
	CPI 	23h
	JRNZ  	H03D7
	LDA 	HC7D0
	STA 	HC7D0
	LDA 	HD7D0
	CPI 	22h
	JRNZ  	H03D7
	MVI 	A,0D8h
	OUT 	4Ah
	NOP 	
	NOP 	
	NOP 	
	LDA 	HC7D1
	STA 	HC7D1
	LDA 	HD7D1
	CPI 	22h
	JRNZ  	H03D7
	SUB 	A
	STA 	HC800
	LDA 	HD800
	CPI 	22h
	JRNZ  	H03DB
H03D7	EXX 	
	SETB  	6,C
	EXX 	
H03DB	MVI 	A,0F8h
	OUT 	4Ah
	LXI 	D,HD000
	LXI 	H,0001h
	MVI 	B,0Bh
	SUB 	A
	STAX	D
	INR 	A
H03EA	DAD 	D
	MOV 	M,A
	DSBC  	D 
	DAD 	H
	RLCR  	A
	DJNZ  	H03EA
	LXI 	D,HC000
	LXI 	H,0001h
	MVI 	B,0Bh
	LDAX	D
	OUT 	61h
	IN  	62h
	BIT   	6,A
	JRNZ  	H0415
H0404	DAD 	D
	MOV 	A,M
	DSBC  	D 
	DAD 	H
	OUT 	61h
	IN  	62h
	BIT   	6,A
	JRZ   	H0415
	DJNZ  	H0404
	JR    	H0419
H0415	EXX 	
	SETB  	5,C
	EXX 	
H0419	CALL	H0318
	EXX 	
	MOV 	A,E
	EXX 	
	MVI 	B,20h
	LXI 	D,H1045		;'ROM CHECKSUM'
	CALL	H0C79
	SUB 	A
	MVI 	B,01h
	LXI 	D,H1056		;'MEMORY'
	CALL	H0C79
	EXX 	
	MOV 	A,C
	EXX 	
	MVI 	B,58h
	LXI 	D,H1061		;'MEMORY CONTROL'
	CALL	H0C79
	EXX 	
	MOV 	A,C
	EXX 	
	MVI 	B,20h
	LXI 	D,H1074		;'MEMORY PARITY DETECTION'
	CALL	H0C79
	JMP 	H0536
H0449	SUB 	A
	MOV 	C,A
	MOV 	B,A
	LXI 	H,0000h
	EXX 	
	MOV 	H,B
	EXX 	
H0452	DAD 	D
	MOV 	M,A
	INR 	L
	JR    	H045E
H0457	EXX 	
	MOV 	M,A
	ANA 	A
	DSBC  	D 
	DAD 	H
	DAD 	D
H045E	INR 	A
	EXX 	
	DJNZ  	H0457
	MOV 	B,H
	EXX 	
	LXI 	H,0000h
	EXAF	
	MOV 	A,C
	EXAF	
	DAD 	D
	MOV 	A,M
	CMP 	C
	JRNZ  	H048D
	INR 	L
	JR    	H047C
H0472	EXX 	
	MOV 	A,M
	CMP 	C
	JRNZ  	H048D
	ANA 	A
	DSBC  	D 
	DAD 	H
	DAD 	D
H047C	INR 	C
	EXX 	
	DJNZ  	H0472
	MOV 	B,H
	EXX 	
	EXAF	
	INR 	A
	MOV 	C,A
	EXAF	
	MOV 	A,C
	LXI 	H,0000h
	DJNZ  	H0452
	SUB 	A
H048D	PCIX  	
H048F	EXAF	
	EXX 	
	SUB 	A
	MOV 	B,A
	LXI 	H,0000h
	DAD 	SP
	EXAF	
	EXX 	
	MVI 	A,9Eh
H049B	SPIY  	
	POP 	H
	POP 	D
	POP 	B
	EXX 	
	SPHL	
	EXX 	
	MOV 	M,A
	LDIR  	
	SPIY  	
	POP 	H
	POP 	D
	POP 	B
	INX 	B
	EXX 	
	SPHL	
	EXX 	
H04AF	CCI   	
	JRNZ  	H04CF
	JPE	H04AF
	EXX 	
	BIT   	0,B
	JRNZ  	H04C2
	SETB  	0,B
	EXX 	
	MVI 	A,61h
	JR    	H049B
H04C2	BIT   	1,B
	JRNZ  	H04CD
	SETB  	1,B
	EXX 	
	MVI 	A,00h
	JR    	H049B
H04CD	SUB 	A
	EXX 	
H04CF	PCIX  	
H04D1	MOV 	C,B
	MVI 	A,0CEh
	OUT 	4Ah
	LXI 	D,H2000
	NOP 	
	NOP 	
H04DB	MVI 	M,9Eh
	DAD 	D
	MVI 	M,61h
	DAD 	D
	DCR 	B
	JRNZ  	H04DB
	MVI 	A,0C8h
	OUT 	4Ah
	NOP 	
	ANA 	A
H04EA	DSBC  	D 
	MOV 	A,M
	MVI 	M,00h
	CPI 	9Eh
	JRNZ  	H0501
	DSBC  	D 
	MOV 	A,M
	MVI 	M,00h
	CPI 	61h
	JRNZ  	H0501
	DCR 	C
	JRNZ  	H04EA
	PCIX  	
H0501	SUB 	A
	INR 	A
	PCIX  	
H0505	EXX 	
	SETB  	3,C
	EXX 	
	JMP 	H028B
H050C	MVI 	D,0A0h
H050E	LXIX  	H0515
H0512	JMP 	H0C62
H0515	MVI 	A,00h
H0517	OUT 	49h
	LXIX  	H0523
	MVI 	B,00h
	MOV 	C,D
	JMP 	H0C56
H0523	ANA 	A
	JRNZ  	H0515
	MVI 	A,10h
	JR    	H0517

H052A	DB 00h,20h,01h,20h,0FFh,0DFh
H0530	DB 00h,20h,01h,20h,0FFh,1Fh
H0536	MVI 	A,0B2h
	OUT 	48h
	LXI 	D,HC000
	LXI 	H,0001h
	MVI 	B,08h
	MVI 	A,09h
	STAX	D
H0545	DAD 	D
	MOV 	M,B
	DSBC  	D 
	DAD 	H
	DJNZ  	H0545
	LXI 	D,HC000
	LXI 	H,0001h
	MVI 	B,08h
	LDAX	D
	ANI 	0Fh
	CPI 	09h
	JRNZ  	H057F
H055B	DAD 	D
	MOV 	A,M
	ANI 	0Fh
	CMP 	B
	JRNZ  	H057F
	DSBC  	D 
	DAD 	H
	DJNZ  	H055B
	LXI 	D,HC000
	LXI 	H,0001h
	MVI 	A,32h
	OUT 	48h
	MVI 	B,08h
H0573	DAD 	D
	MOV 	A,M
	CMP 	B
	JRZ   	H057F
	DSBC  	D 
	DAD 	H
	DJNZ  	H0573
	JR    	H0587
H057F	MVI 	A,32h
	OUT 	48h
	EXX 	
	SETB  	4,E
	EXX 	
H0587	EXX 	
	MOV 	A,E
	EXX 	
	MVI 	B,10h
	LXI 	D,H1090		;'TERMINAL LOCKED'
	CALL	H0C79
	MVI 	A,80h
	OUT 	18h
	MVI 	A,0C0h
	OUT 	49h
	MVI 	A,40h
	OUT 	49h
	MVI 	A,00h
	STA 	HA900+1Bh
	MVI 	D,9Eh
	MVI 	C,1Bh
	CALL	H068E
	MVI 	A,40h
	OUT 	19h
	MVI 	A,20h
	OUT 	17h
	MVI 	C,0Ah
	CALL	H063E
	MVI 	D,9Eh
	MVI 	C,1Ah
	CALL	H068E
	MVI 	A,04h
	OUT 	19h
	MVI 	A,01h
	OUT 	17h
	MVI 	C,0Bh
	CALL	H063E
	SUB 	A
	OUT 	19h
	MVI 	C,02h
	MVI 	D,87h
	CALL	H0683
	MVI 	C,10h
	CALL	H068E
	MVI 	D,20h
	MVI 	C,07h
	CALL	H0683
	MVI 	A,28h
	OUT 	16h
	MVI 	C,0Ch
	LXI 	D,H0200
	CALL	H0641
	LXI 	D,0800h
	MVI 	C,01h
	CALL	H0641
	MVI 	D,9Eh
	MVI 	C,01h
	CALL	H0683
	MVI 	C,10h
	CALL	H068E
	MVI 	D,04h
	MVI 	C,07h
	CALL	H0683
	MVI 	A,10h
	OUT 	16h
	MVI 	C,0Dh
	CALL	H063E
	MVI 	C,07h
	MVI 	D,00h
	CALL	H0683
	MVI 	A,01h
	STA 	HA900+1Bh
	MVI 	A,40h
	OUT 	16h
	MVI 	A,0BFh
	OUT 	12h
	MVI 	C,0A2h
	LXI 	D,H1200
	CALL	H0641
	SUB 	A
	OUT 	19h
	EXX 	
	MOV 	A,E
	EXX 	
	MVI 	B,02h
	LXI 	D,H10A4			;'TIMERS'
	CALL	H0C79
	JMP 	H069C
H063E	LXI 	D,0700h
H0641	EI  	
	CMP 	C
	JRZ   	H0656
	DCR 	E
	JRNZ  	H0641
	DCR 	D
	JRNZ  	H0641
	DI  	
H064C	EXX 	
	SETB  	1,E
	EXX 	
	SUB 	A
	OUT 	17h
	OUT 	16h
	RET 	
H0656	DI  	
	LXI 	H,H067B
	CPI 	0Ch
	JRZ   	H066F
	INX 	H
	INX 	H
	CPI 	0A2h
	JRZ   	H066C
	INX 	H
	INX 	H
	CPI 	01h
	JRNZ  	H066F
	INX 	H
	INX 	H
H066C	DCR 	D
	JRZ   	H0672
H066F	DCR 	D
	JRNZ  	H064C
H0672	MOV 	A,E
	CMP 	M
	JRC   	H064C
	INX 	H
	CMP 	M
	JRNC  	H064C
	RET
	
H067B	DB	0D9h,0F9h,0CDh,0FDh,7Eh,0E4h,3Bh,76h

H0683	IN  	18h
	ANI 	0E0h
	ADD 	C
	OUT 	18h
	MOV 	A,D
	OUT 	10h		;FDC command
	RET 	
H068E	PUSH	B
	MVI 	B,10h
H0691	OUTP  	D
	INP   	A
	CMP 	D
	JRZ   	H069A
	DJNZ  	H0691
H069A	POP 	B
	RET 	
H069C	EXX 	
	BIT   	1,E
	EXX 	
	MVI 	B,00h
	JNZ	H07DF
	MVI 	A,0Ah
	STA 	HA900+1Bh
	CALL	H07E8
	LXI 	H,H0CC5
	LXI 	B,0802h
	OUTIR 	
	LXI 	H,H0CD5
	LXI 	B,1002h
	OUTIR 	
	LXI 	H,H0CE5
	LXI 	B,0200h
	OUTIR 	
	LXI 	H,H0D4D
	LDA 	H0D4D
	OUT 	03h
	CALL	H0805
	LXI 	H,HA900+6
	LXI 	D,H0D5C
	MVI 	B,0Bh
	CALL	H081C
	CALL	H07E8
	LXI 	H,H0CC5
	LXI 	B,0802h
	OUTIR 	
	LXI 	H,H0CF4
	LXI 	B,1002h
	OUTIR 	
	MVI 	A,01h
	STA 	HA900+19h
	LXI 	H,H0D67
	LDA 	H0D67
	OUT 	03h
	MVI 	A,0C0h
	OUT 	02h
	MVI 	A,01h
	STA 	HA900+1Dh
	CALL	H0805
	LDA 	HA900+1Dh
	ANA 	A
	JNZ	H07CB
	LXI 	H,HA900+6
	LXI 	D,H0D7C
	MVI 	B,07h
	CALL	H081C
	CALL	H07E8
	LXI 	H,H0CC5
	LXI 	B,0802h
	OUTIR 	
	LXI 	H,H0CD5
	LXI 	B,1002h
	OUTIR 	
	MVI 	A,01h
	STA 	HA900+1Ah
	LXI 	H,H0D70
	LDA 	H0D70
	OUT 	03h
	CALL	H0805
	LDA 	HA900+1Ah
	ANA 	A
	JNZ	H07CB
	CALL	H07E8
	LXI 	H,H0CC5
	LXI 	B,0802h
	OUTIR 	
	LXI 	H,H0CD5
	LXI 	B,1002h
	OUTIR 	
	MVI 	A,84h
	STA 	HA900
	LXI 	H,H0D4D
	LDA 	H0D4D
	OUT 	03h
	CALL	H0805
	LDA 	HA900
	ANA 	A
	JNZ	H07CB
	CALL	H07E8
	LXI 	H,H0D19
	LXI 	B,1902h
	OUTIR 	
	MVI 	A,01h
	STA 	HA900+1Eh
	LXI 	H,H0D83
	LDA 	H0D83
	LXI 	B,0102h
H0786	NOP 	
	DJNZ  	H0786
	DCR 	C
	JRNZ  	H0786
	OUT 	03h
	MVI 	A,0C0h
	OUT 	02h
	CALL	H0805
	LXI 	H,HA900+6
	LXI 	D,H0D91
	MVI 	B,0Eh
	CALL	H081C
	CALL	H07E8
	LXI 	H,H0D32
	LXI 	B,H1B02
	OUTIR 	
	MVI 	A,11h
	STA 	HA900+1Eh
	LXI 	H,H0D9F
	LDA 	H0D9F
	LXI 	B,0101h
H07B9	NOP 	
	DJNZ  	H07B9
	DCR 	C
	JRNZ  	H07B9
	OUT 	03h
	MVI 	A,0C0h
	OUT 	02h
	CALL	H0805
	JMP 	H07CF
H07CB	EXX 	
	SETB  	7,E
	EXX 	
H07CF	SUB 	A
H07D0	OUT 	19h
	MVI 	A,09h
	OUT 	02h
	MVI 	A,80h
	OUT 	02h
	EXX 	
	MOV 	A,E
	EXX 	
	MVI 	B,80h
H07DF	LXI 	D,H10AF
	CALL	H0C79
	JMP 	H082A
H07E8	MVI 	E,50h
	MVI 	D,0D7h
	SUB 	A
	OUT 	19h
	MVI 	B,00h
H07F1	NOP 	
	DJNZ  	H07F1
H07F4	MVI 	C,1Bh
	CALL	H068E
	MOV 	A,E
	OUT 	19h
	MVI 	A,20h
	OUT 	17h
	MVI 	A,0DFh
	OUT 	13h		;FDC data port
	RET 	
H0805	SHLD	HA900+4
	LXI 	H,HA900+6
	SHLD	HA900+16h
	SUB 	A
	STA 	HA900+1
H0812	EI  	
	LDA 	HA900+1
	CPI 	01h
	JRNZ  	H0812
	DI  	
	RET 	
H081C	LDAX	D
	CMP 	M
	JRNZ  	H0826
	INX 	D
	INX 	H
	DCR 	B
	JRNZ  	H081C
	RET 	
H0826	POP 	H
	JMP 	H07CB
H082A	EXX 	
	BIT   	1,E
	EXX 	
	MVI 	B,00h
	JRNZ  	H0886
	MVI 	A,0Bh
	STA 	HA900+1Bh
	CALL	H07E8
	MVI 	A,09h
	OUT 	00h
	MVI 	A,40h
	OUT 	00h
	LXI 	H,H0CCD
	LXI 	B,0800h
	OUTIR 	
	LXI 	H,H0CE5
	LXI 	B,0F00h
	OUTIR 	
	LXI 	H,H0DA9
	LDA 	H0DA9
	OUT 	01h
	CALL	H0805
	LXI 	H,HA900+6
	LXI 	D,H0DA9
	MVI 	B,09h
H0865	LDAX	D
	CMP 	M
	MVI 	M,00h
	JRNZ  	H0872
	INX 	D
	INX 	H
	DCR 	B
	JRNZ  	H0865
	JR    	H0876
H0872	EXX 	
	SETB  	6,E
	EXX 	
H0876	SUB 	A
	OUT 	19h
	MVI 	A,09h
	OUT 	00h
	MVI 	A,40h
	OUT 	00h
	EXX 	
	MOV 	A,E
	EXX 	
	MVI 	B,40h
H0886	LXI 	D,H10CA
	CALL	H0C79
	EXX 	
	BIT   	1,E
	EXX 	
	MVI 	B,00h
	JRNZ  	H0901
	EXX 	
	BIT   	6,E
	EXX 	
	MVI 	B,00h
	JRNZ  	H0901
	CALL	H090A
	LXI 	H,H0DA9
	LDA 	H0DA9
	OUT 	1Fh
	CALL	H0805
	LXI 	H,HA900+6
	LXI 	D,H0DA9
	MVI 	B,09h
H08B2	LDAX	D
	CMP 	M
	MVI 	M,00h
	JRNZ  	H08E7
	INX 	D
	INX 	H
	DCR 	B
	JRNZ  	H08B2
	CALL	H090A
	MVI 	A,01h
	STA 	HA900
	LXI 	H,H0DA9
	LDA 	H0DA9
	OUT 	1Fh
	CALL	H0805
	CALL	H090A
	SUB 	A
	CALL	H0683
	STA 	HA900+1
	INR 	A
	STA 	HA900+1Ch
	MVI 	A,0Fh
	OUT 	1Eh
	CALL	H0812
	JR    	H08EB
H08E7	EXX 	
	SETB  	3,E
	EXX 	
H08EB	SUB 	A
	OUT 	19h
	OUT 	1Dh
	OUT 	1Eh
	OUT 	17h
	MVI 	A,09h
	OUT 	00h
	MVI 	A,40h
	OUT 	00h
	EXX 	
	MOV 	A,E
	EXX 	
	MVI 	B,08h
H0901	LXI 	D,H10DF		;'PERIPHERAL CHANNEL'
	CALL	H0C79
	JMP 	H0947
H090A	MVI 	A,0Ch
	STA 	HA900+1Bh
	CALL	H07E8
	MVI 	A,09h
	OUT 	00h
	MVI 	A,40h
	OUT 	00h
	LXI 	H,H0CCD
	LXI 	B,0800h
	OUTIR 	
	LXI 	H,H0CE5
	LXI 	B,0F00h
	OUTIR 	
	SUB 	A
	STA 	HA900
	STA 	HA900+1Ch
	MVI 	A,9Ch
	OUT 	1Ch
	MVI 	A,3Eh
	OUT 	17h
	MVI 	A,01h
	OUT 	1Dh
	MVI 	A,07h
	OUT 	1Eh
	MVI 	B,15h
H0943	NOP 	
	DJNZ  	H0943
	RET 	
H0947	MVI 	B,00h
	LXI 	D,H10F6
	CALL	H0C79
	LHLD	HA900+2
	LXI 	D,0050h
	ANA 	A
	DSBC  	D 
	LXI 	D,0026h
	DAD 	D
	LXI 	B,0008h
	MVI 	A,2Ah
	STA 	HD7D0
	LDA 	HC7D0
	LXI 	D,H1036
	XCHG	
	LDIR  	
	LXIX  	H0974
	JMP 	H09ED
H0974	JNZ	H09EA
	EXX 	
	BIT   	0,D
	JRZ   	H0982
	BIT   	5,D
	JRNZ  	H099E
	JR    	H09B1
H0982	BIT   	0,C
	EXX 	
	JRNZ  	H09A1
	MVI 	A,02h
	LXIY  	H0990
	JMP 	H0A6B
H0990	JRNZ  	H099D
	MVI 	A,0Ah
	LXIY  	H099B
	JMP 	H0A6B
H099B	JRZ   	H09A1
H099D	EXX 	
H099E	SETB  	0,C
	EXX 	
H09A1	MVI 	A,0F8h
	OUT 	4Ah
	EXX 	
	MOV 	A,C
	EXX 	
	MVI 	B,01h
	LXI 	D,H1111
	CALL	H0C79
	EXX 	
H09B1	BIT   	5,D
	JRZ   	H09BC
	BIT   	0,D
	EXX 	
	JRNZ  	H09D7
	JR    	H09EA
H09BC	BIT   	5,E
	EXX 	
	JRNZ  	H09DB
	MVI 	A,04h
	LXIY  	H09CA
	JMP 	H0A6B
H09CA	JRNZ  	H09D7
	MVI 	A,0Ch
	LXIY  	H09D5
	JMP 	H0A6B
H09D5	JRZ   	H09DB
H09D7	EXX 	
	SETB  	5,E
	EXX 	
H09DB	MVI 	A,0F8h
	OUT 	4Ah
	EXX 	
	MOV 	A,E
	EXX 	
	MVI 	B,20h
	LXI 	D,H1125
	CALL	H0C79
H09EA	JMP 	H0AD3
H09ED	EXX 	
	MVI 	D,00h
	EXX 	
	IN  	50h
	BIT   	7,A
	JRNZ  	H09FA
	INR 	A
	JR    	H0A33
H09FA	IN  	11h
	BIT   	2,A
	JRNZ  	H0A33
	MVI 	A,0FEh
	OUT 	4Bh
	MVI 	B,02h
	LXIY  	H0A0D
	JMP 	H0A35
H0A0D	JRNZ  	H0A13
	EXX 	
	SETB  	0,D
	EXX 	
H0A13	JRNC  	H0A19
	EXX 	
	SETB  	0,C
	EXX 	
H0A19	MVI 	B,04h
	LXIY  	H0A22
	JMP 	H0A35
H0A22	JRNZ  	H0A28
	EXX 	
	SETB  	5,D
	EXX 	
H0A28	JRNC  	H0A2E
	EXX 	
	SETB  	5,E
	EXX 	
H0A2E	SUB 	A
	OUT 	50h
	OUT 	4Bh
H0A33	PCIX  	
H0A35	LXI 	H,H2000
	MOV 	A,B
	OUT 	50h
	MVI 	M,21h
	MVI 	A,00h
	OUT 	50h
	MVI 	M,0A9h
	MOV 	A,B
	OUT 	50h
	MVI 	A,21h
	CMP 	M
	JRZ   	H0A52
	MVI 	A,0A9h
	CMP 	M
	JRZ   	H0A69
	JR    	H0A67
H0A52	MOV 	A,B
	ORI 	08h
	OUT 	50h
	MVI 	M,21h
	MOV 	A,B
	OUT 	50h
	MVI 	M,0A9h
	ORI 	08h
	OUT 	50h
	MVI 	A,21h
	CMP 	M
	JRZ   	H0A68
H0A67	STC 	
H0A68	DCR 	A
H0A69	PCIY  	
H0A6B	OUT 	50h
H0A6D	MVI 	A,0FEh
	OUT 	4Bh
H0A71	SPIY  	
	MVI 	A,0C8h
	OUT 	4Ah
	EXX 	
	MVI 	B,11h
	EXX 	
	LXI 	D,H2000
	LXIX  	H0A85
	JMP 	H0449
H0A85	JNZ	H0AC5
	LXIX  	H0A93
	LXIY  	H052A
	JMP 	H048F
H0A93	JNZ	H0AC5
	MVI 	B,03h
	LXI 	H,H4000
	LXIX  	H0AA2
	JMP 	H04D1
H0AA2	JNZ	H0AC5
	MVI 	A,0CEh
	OUT 	4Ah
	EXX 	
	MVI 	B,0Eh
	EXX 	
	LXI 	D,H2000
	LXIX  	H0AB7
	JMP 	H0449
H0AB7	JNZ	H0AC5
	LXIX  	H0AC5
	LXIY  	H0530
	JMP 	H048F
H0AC5	MVI 	A,00h
	OUT 	50h
	OUT 	4Bh
	LXI 	H,0000h
	DAD 	SP
	LXI 	SP,H8000
	PCHL	
H0AD3	EXX 	
	BIT   	1,C
	RES   	1,C
	EXX 	
	JRNZ  	H0B04
	LXI 	D,000Ah
	MVI 	B,00h
	MVI 	C,4Dh
	EXX 	
	BIT   	2,C
	EXX 	
	JRZ   	H0AEA
	MVI 	C,4Eh
H0AEA	LXIY  	H8000+0B40h
	LXIX  	H0AF5
	JMP 	H174C
H0AF5	EXX 	
	JRZ   	H0AFA
	SETB  	1,C
H0AFA	MOV 	A,C
	EXX 	
	MVI 	B,02h
	LXI 	D,H1138
	CALL	H0C79
H0B04	MVI 	A,00h
	STA 	H2000
	STA 	H2000+1
	EXX 	
	BIT   	1,E
	EXX 	
	MVI 	B,00h
	JRNZ  	H0B22
	CALL	H0B2B
	EXX 	
	MOV 	A,B
	EXX 	
	ANA 	A
	JRZ   	H0B28
	EXX 	
	MOV 	A,E
	EXX 	
	MVI 	B,04h
H0B22	LXI 	D,H1150
	CALL	H0C79
H0B28	JMP 	H0B85
H0B2B	MVI 	A,0Dh
	STA 	HA900+1Bh
	CALL	H07E8
	LXI 	H,H0D04
	LXI 	B,1500h
	OUTIR 	
	EI  	
	LDA 	H0DB3
	OUT 	01h
H0B41	IN  	00h
	BIT   	2,A
	JRZ   	H0B41
	LDA 	H0DB4
	OUT 	01h
H0B4C	IN  	00h
	BIT   	0,A
	JRZ   	H0B4C
	MVI 	B,00h
H0B54	NOP 	
	DJNZ  	H0B54
	LXI 	H,H0DB3
	IN  	01h
	CMP 	M
	JRNZ  	H0B74
H0B5F	IN  	00h
	BIT   	0,A
	JRZ   	H0B5F
	IN  	01h
	INX 	H
	CMP 	M
	EXX 	
	MVI 	B,01h
	JRNZ  	H0B77
	SETB  	2,E
	MVI 	B,02h
	JR    	H0B77
H0B74	EXX 	
	MVI 	B,00h
H0B77	EXX 	
	DI  	
	SUB 	A
	OUT 	19h
	MVI 	A,09h
	OUT 	00h
	MVI 	A,40h
	OUT 	00h
	RET 	
H0B85	OUT 	61h
	LXI 	D,H118F
	IN  	62h
	BIT   	4,A
	JRNZ  	H0B93
	LXI 	D,H116F
H0B93	CALL	H0C79
	LXI 	D,H119F
	IN  	62h
	BIT   	3,A
	JRZ   	H0BA2
	LXI 	D,H1180
H0BA2	CALL	H0C79
	MVI 	D,0C0h
	MVI 	C,02h
	CALL	H0683
	MVI 	D,60h
	MVI 	C,07h
	CALL	H0683
	MVI 	A,04h
	CALL	H0C06
	MVI 	A,05h
	CALL	H0C06
	MVI 	A,06h
	CALL	H0C06
	MVI 	A,24h
	CALL	H0C06
	MVI 	A,26h
	CALL	H0C06
	MVI 	A,0C8h
	OUT 	4Ah
	LHLD	HA900+2
	LXI 	D,00F0h
	ANA 	A
	DSBC  	D 
	SHLD	HA900+2
	LXI 	D,H11AD
	CALL	H0C79
	LXI 	D,H11BD
	CALL	H0C79
	LXI 	D,H11CD
	CALL	H0C79
	LXI 	D,H11DD
	CALL	H0C79
	LHLD	HA900+2
	LXI 	H,HC785
	SHLD	HA900+2
	LXI 	D,H1214
	CALL	H0C79
	JMP 	H0C38
H0C06	EXX 	
	MOV 	B,A
	EXX 	
	LHLD	HA900+2
	LXI 	D,0050h
	DAD 	D
	SHLD	HA900+2
	LXI 	D,1000h
	DAD 	D
	CPI 	04h
	JRZ   	H0C1D
	SETB  	6,A
H0C1D	MVI 	C,02h
H0C1F	MVI 	B,08h
H0C21	MOV 	M,A
	RES   	6,A
	INX 	H
	DJNZ  	H0C21
	SETB  	4,A
	RES   	0,A
	DCR 	C
	JRNZ  	H0C1F
	EXX 	
	MOV 	A,B
	EXX 	
	CPI 	04h
	JRZ   	H0C37
	MVI 	M,40h
H0C37	RET 	
H0C38	EXX 	
	MOV 	A,C
	ANI 	7Bh
	ORA 	E
	EXX 	
	JZ 	H0C48
	LXIX  	H0C47
	JR    	H0C62
H0C47	HLT 	
H0C48	EXX 	
	BIT   	7,C
	EXX 	
	JZ 	H0C5E
	LXIX  	00E7h
H0C53	LXI 	B,0000h
H0C56	NOP 	
	DJNZ  	H0C56
	DCR 	C
	JRNZ  	H0C56
	PCIX  	
H0C5E	LXIX  	H1424
H0C62	MVI 	A,4Dh
	MVI 	B,01h
	OUT 	1Ah
	MOV 	A,B
	OUT 	19h
	LXI 	B,005Ch
H0C6E	NOP 	
	DJNZ  	H0C6E
	DCR 	C
	JRNZ  	H0C6E
	SUB 	A
	OUT 	19h
	PCIX  	
H0C79	MOV 	C,A
	LHLD	HA900+2
	MVI 	A,00h
	STA 	HD7D0
	LDA 	HC7D0
H0C85	LDAX	D
	ANA 	A
	JRZ   	H0C92
	CPI 	0FFh
	JRZ   	H0CBA
	MOV 	M,A
	INX 	D
	INX 	H
	JR    	H0C85
H0C92	LHLD	HA900+2
	LXI 	D,0026h
	DAD 	D
	LXI 	D,H103D
	MOV 	A,B
	ANA 	A
	JRZ   	H0CAD
	LXI 	D,H102F
	MVI 	B,22h
	ANA 	C
	JRZ   	H0CAD
	LXI 	D,H1036
	MVI 	B,00h
H0CAD	MOV 	A,B
	STA 	HD7D0
	LDA 	HC7D0
	LXI 	B,0008h
	XCHG	
	LDIR  	
H0CBA	LHLD	HA900+2
	LXI 	D,0050h
	DAD 	D
	SHLD	HA900+2
	RET

;	8 bytes out port 2 	
H0CC5	DB	0Bh,52h,0Ch,0CEh,0Dh,00h,0Eh,93h

;	8 bytes out port 0
H0CCD	DB	0Bh,06h,0Ch,0Bh,0Dh,00h,0Eh,93h

;	16 bytes out port 2	
H0CD5	DB	0Fh,00h,04h,01h,06h,16h,07h,16h
	DB	01h,16h,03h,53h,09h,09h,05h,28h

;	15 bytes out port 0
H0CE5	DB	02h,70h,0Fh,40h,10h,34h,0C5h,01h
	DB	16h,03h,0C1h,09h,09h,05h,68h

;	16 bytes out port 2	
H0CF4	DB	90h,40h,04h,10h,06h,16h,07h,16h
	DB	05h,6Dh,09h,09h,01h,13h,03h,0C1h

;	21 bytes out port 0
H0D04	DB	0Bh,06h,0Ch,0Bh,0Dh,00h,0Eh,03h
	DB	02h,70h,10h,34h,0CDh,01h,0E0h,03h
	DB	0C1h,09h,09h,05h,0E8h

;	25 bytes out port 2
H0D19	DB	10h,34h,20h,0Bh,52h,0Ch,0CEh
	DB	0Dh,00h,0Eh,93h,02h,70h,06h,3Eh
	DB	07h,7Eh,09h,09h,01h,12h,05h,69h
	DB	83h,0DDh

;	27 bytes out 2
H0D32	DB	10h,34h,20h,0Bh,52h,0Ch,0CEh,0Dh
	DB	00h,0Eh,93h,0Fh,00h,02h
	DB	70h,06h,3Eh,07h,7Eh,09h,09h,01h
	DB	13h,05h,69h,83h,0DDh

H0D4D	DB	00h,40h,20h,10h,08h,04h,02h,01h
	DB	03h,80h,7Fh,7Fh,7Fh,7Fh,0FEh
H0D5C	DB	80h,40h,20h,10h,08h,04h,02h,01h,83h,7Ch,7Fh
H0D67	DB	0D5h,81h,2Ah,2Ah,7Fh,7Fh,7Fh,7Fh,0FEh
H0D70	DB	0D5h,0D5h,2Ah,2Ah,81h,2Ah,2Ah,7Fh,7Fh,7Fh,7Fh,0FEh
H0D7C	DB	0D5h,0C1h,9Fh,16h,16h,2Ah,7Fh
H0D83	DB	3Eh,10h,11h,01h,80h,81h,0C0h,05h,41h,42h,43h,44h,45h,98h	
H0D91	DB	3Eh,10h,11h,01h,80h,81h,0C0h,05h,41h,42h,43h,44h,45h,98h
H0D9F	DB	3Eh,10h,11h,01h,80h,81h,0C0h,05h,41h,0CCh
H0DA9	DB	01h,02h,04h,08h,10h,20h,40h,80h,05h,00h
H0DB3	DB	0F7h
H0DB4	DB	0BFh,00h

H0DB6	EXAF
	EXX
H0DB8	LHLD	HA900+4
	INX 	H
	SHLD	HA900+4
	MOV 	B,A
	LDA 	HA900+1Eh
	BIT   	0,A
	MOV 	B,M
	JRZ   	H0DEF
	MOV 	A,B
	CPI 	0CCh
	JRZ   	H0DE0
	OUT 	03h
	CPI 	98h
	JNZ	H0E1E
	MVI 	B,00h
H0DD6	NOP 	
	DJNZ  	H0DD6
	MVI 	A,28h
	OUT 	02h
	JMP 	H0E1E
H0DE0	MVI 	A,0Fh
	OUT 	02h
	MVI 	A,80h
	OUT 	02h
	MVI 	A,18h
	OUT 	02h
	JMP 	H0E1E
H0DEF	BIT   	7,B
	JRNZ  	H0E0C
	LXI 	H,HA900+18h
	MOV 	A,B
	XRA 	M
	MOV 	M,A
	MOV 	A,B
H0DFA	CPI 	7Fh
	JRNZ  	H0E06
	MOV 	B,A
	LDA 	HA900+1Dh
	ANA 	A
	JRNZ  	H0E1E
	MOV 	A,B
H0E06	ANI 	7Fh
	OUT 	03h
	JR    	H0E1E
H0E0C	MOV 	A,B
	CPI 	81h
	LDA 	HA900+18h
	JRC   	H0DFA
	JRZ   	H0E27
	MVI 	A,05h
	OUT 	02h
	MVI 	A,20h
	OUT 	02h
H0E1E	MVI 	A,38h
	OUT 	02h
	OUT 	00h
H0E24	EXX 	
	EXAF	
	RET 	
H0E27	LDA 	HA900+19h
	ANA 	A
	JRZ   	H0E38
	MVI 	A,28h
	OUT 	02h
	MVI 	A,02h
	STA 	HA900+19h
	JR    	H0E1E
H0E38	LDA 	HA900+1Ah
	ANA 	A
	JRZ   	H0E48
	MVI 	A,04h
	OUT 	02h
	MVI 	A,03h
	OUT 	02h
	JR    	H0E1E
H0E48	LXI 	H,H07CB
	XTHL	
	JR    	H0E24
H0E4E	EXX 	
	EXAF	
	IN  	02h
	BIT   	7,A
	JRZ   	H0E5D
	SUB 	A
	STA 	HA900+1Eh
	JMP 	H0EF2
H0E5D	BIT   	3,A
	JRNZ  	H0E48
	MOV 	B,A
	MVI 	A,10h
	OUT 	02h
	MOV 	A,B
	ANI 	40h
	JRZ   	H0E79
	LDA 	HA900+1Dh
	ANA 	A
	JRZ   	H0E48
	SUB 	A
	STA 	HA900+1Dh
	MVI 	A,0C0h
	OUT 	02h
H0E79	JMP 	H0E1E
H0E7C	EXX 	
	EXAF	
	LDA 	HA900
	ANI 	7Fh
	JRNZ  	H0EAF
	LHLD	HA900+16h
	IN  	03h
	MOV 	M,A
	LDA 	HA900+1Eh
	BIT   	0,A
	MOV 	A,M
	INX 	H
	SHLD	HA900+16h
	JRNZ  	H0E79
	ANI 	7Fh
	CPI 	7Fh
	JRZ   	H0EF2
	CPI 	16h
	JRNZ  	H0E79
	LDA 	HA900+19h
	CPI 	02h
	JRNZ  	H0E79
	SUB 	A
	STA 	HA900+19h
	JMP 	H0DB8
H0EAF	IN  	02h
	ANI 	04h
	JZ 	H0E79
	LXI 	H,HA900
	DCR 	M
	JMP 	H0DB8
H0EBD	EXAF	
	EXX 	
	LDA 	HA900+1Eh
	BIT   	4,A
	JNZ	H0E1E
	MVI 	A,01h
	OUT 	02h
	IN  	02h
	BIT   	7,A
	JRNZ  	H0EF2
	ANI 	30h
	JZ 	H0E48
	ANI 	10h
	JRZ   	H0EE7
	LDA 	HA900+1Ah
	ANA 	A
	JZ 	H0E48
	SUB 	A
	STA 	HA900+1Ah
	JR    	H0EF2
H0EE7	LDA 	HA900
	ANA 	A
	JZ 	H0E48
	SUB 	A
	STA 	HA900
H0EF2	MVI 	A,01h
	STA 	HA900+1
	MVI 	A,09h
	OUT 	02h
	MVI 	A,80h
	OUT 	02h
	JMP 	H0E24
	IN  	03h
	LDA 	HA900+1Eh
	BIT   	0,A
	JRZ   	H0EF2
	MVI 	A,01h
	STA 	HA900+1
	JMP 	H0E24
H0F13	EXAF	
	EXX 	
	LHLD	HA900+4
	INX 	H
	SHLD	HA900+4
	MOV 	A,M
	ANA 	A
	JRZ   	H0F25
	OUT 	01h
	JMP 	H0E1E
H0F25	MVI 	A,05h
	OUT 	00h
	MVI 	A,20h
	OUT 	00h
	JMP 	H0E1E
H0F30	EXAF	
	EXX 	
	LHLD	HA900+16h
	IN  	01h
	MOV 	M,A
	INX 	H
	SHLD	HA900+16h
	CPI 	05h
	JRZ   	H0F43
	JMP 	H0E1E
H0F43	MVI 	A,09h
	OUT 	00h
	MVI 	A,40h
	OUT 	00h
	MVI 	A,01h
	STA 	HA900+1
	JMP 	H0E24
H0F53	EXX 	
	EXAF	
	LXI 	H,H0872
	XTHL	
	JMP 	H0E24
H0F5C	PUSH	PSW
	SUB 	A
	OUT 	17h
	LDA 	HA900+1Bh
	CPI 	0Ah
	JRZ   	H0F93
	CPI 	0Bh
	JRZ   	H0F98
	CPI 	0Ch
	JRZ   	H0F9D
	CPI 	0Dh
	JRZ   	H0FA2
	CPI 	01h
	MVI 	B,0Ah
	JRNZ  	H0F7B
	MVI 	B,0A2h
H0F7B	POP 	PSW
	MOV 	A,B
	RET 	
H0F7E	MVI 	A,00h
	OUT 	17h
	MVI 	A,0Bh
	RET 	
H0F85	MVI 	A,08h
	OUT 	16h
	MVI 	A,0Ch
	RET 	
H0F8C	MVI 	A,00h
	OUT 	16h
	MVI 	A,0Dh
	RET 	
H0F93	LXI 	H,H07CB
	JR    	H0FA5
H0F98	LXI 	H,H0872
	JR    	H0FA5
H0F9D	LXI 	H,H08E7
	JR    	H0FA5
H0FA2	LXI 	H,H0B74
H0FA5	POP 	PSW
	XTHL	
	RET 	
H0FA8	MVI 	A,00h
	OUT 	16h
	MVI 	A,01h
	RET 	
H0FAF	PUSH	PSW
	SUB 	A
	OUT 	16h
	MVI 	D,01h
	MVI 	E,80h
	CALL	H07F4
	LXI 	D,0900h
	MVI 	C,0A2h
	POP 	PSW
H0FC0	RET 	
H0FC1	EXAF	
	EXX 	
	LHLD	HA900+4
	INX 	H
	SHLD	HA900+4
	MOV 	A,M
	ANA 	A
	JRZ   	H102C
	OUT 	1Fh
	JR    	H102C
H0FD2	EXAF	
	EXX 	
	IN  	1Eh
	BIT   	6,A
	JRZ   	H102C
	LDA 	HA900
	ANA 	A
	JRZ   	H1020
	IN  	1Dh
	IN  	1Fh
	JR    	H102C
H0FE6	EXX 	
	EXAF	
	LDA 	HA900
	ANA 	A
	JRNZ  	H102C
	LHLD	HA900+16h
	IN  	1Dh
	MOV 	B,A
	IN  	1Fh
	MOV 	M,A
	INX 	H
	SHLD	HA900+16h
	JR    	H102C
H0FFD	EXX 	
	EXAF	
	IN  	1Dh
	ANI 	48h
	JRZ   	H102C
	ANI 	40h
	JRZ   	H1014
	LDA 	HA900
	ANA 	A
	JZ 	H101A
	IN  	1Fh
	JR    	H1020
H1014	LDA 	HA900+1Ch
	ANA 	A
	JRNZ  	H1020
H101A	LXI 	H,H08E7
	XTHL	
	JR    	H102C
H1020	MVI 	A,01h
	STA 	HA900+1
	SUB 	A
	OUT 	17h
	OUT 	1Dh
	OUT 	1Eh
H102C	EXX 	
	EXAF	
	RET 	

H102F	DB ' PASSED'
H1036	DB ' FAILED'
H103D	DB ' @@@@@@ '
H1045	DB ' 1  ROM CHECKSUM'
	DB 00h
H1056	DB ' 2  MEMORY'
	DB 00h
H1061	DB ' 3  MEMORY CONTROL'
	DB 00h
H1074	DB ' 4  MEMORY PARITY DETECTION'
	DB 00h
H1090	DB ' 5  NONVOLATILE RAM'
	DB 00h
H10A4	DB ' 6  TIMERS'
	DB 00h
H10AF	DB ' 7  COMMUNICATIONS CHANNEL'
	DB 00h
H10CA	DB ' 8  KEYBOARD CHANNEL'
	DB 00h
H10DF	DB ' 9  PERIPHERAL CHANNEL'
	DB 00h
H10F6	DB '10  OPTIONAL CHARACTER SET'
	DB 0FFh
H1111	DB '11  GRAPHICS MEMORY'
	DB 00h
H1125	DB '12  FEATURE MEMORY'
	DB 00h
H1138	DB '13  DISKETTE CONTROLLER'
	DB 00h
H1150	DB '14  KEYBOARD EXTERNAL LOOPBACK'
	DB 00h
H116F	DB 'TERMINAL ENABLED'
	DB 0FFh
H1180	DB 'SET UP ENABLED'
	DB 0FFh
H118F	DB 'TERMINAL LOCKED'
	DB 0FFh
H119F	DB 'SET UP LOCKED'
	DB 0FFh
H11AD	DB '  OFF     BLINK'
	DB 0FFh
H11BD	DB '  LOW INTENSITY'
	DB 0FFh
H11CD	DB '  REVERSE VIDEO'
	DB 0FFh
H11DD	DB '    HIGHLIGHT'
	DB 0FFh
H11EB	DB 'READ ERROR'
	DB 0FFh
H11F6	DB 'WRITE ERRO'
H1200	DB 'R'
	DB 0FFh
H1202	DB 'LOAD FORMAT ERROR'
	DB 0FFh
H1214	DB 'F3981-00 07'
	DB 0FFh
H1220	DB 'INSERT SYSTEM DISKETTE'
	DB 0FFh
;
;	here for warm reset ?
;
H1237	PUSH	B
	PUSH	D
	PUSH	H
	PUSHIX	
	PUSHIY	
	MOV 	E,A
	MVI 	D,50h
	JMP 	H050E
H1244	PUSH	B
	PUSHIX	
	LXI 	B,0008h
	LXIX  	H1251
	JMP 	H0C56
H1251	OUT 	61h
	IN  	62h
	BIT   	5,A
	JZ 	H12E3
	EXX 	
	MOV 	A,E
	CPI 	9Eh
	JRNZ  	H126F
	BIT   	5,C
	JRZ   	H126F
	RES   	5,C
	EXX 	
	OUT 	60h
	LXI 	H,H0179
	XTHL	
	RETN  	
H126F	MOV 	A,H
	CPI 	4Bh
	JRNZ  	H1280
	MOV 	A,L
	CPI 	44h
	JRNZ  	H1280
	LXI 	H,0000h
	EXX 	
	JMP 	H00B3
H1280	EXX 	
	POPIX 	
	PUSH	D
	PUSH	H
	PUSHIX	
	PUSHIY	
	SUB 	A
	OUT 	4Bh
	MVI 	A,0CEh
	OUT 	4Ah
	NOP 	
	NOP 	
	LXI 	H,H2000+1Fh
	MOV 	B,M
	MVI 	A,0C8h
	OUT 	4Ah
	NOP 	
	NOP 	
	NOP 	
	LDA 	HFFFB
	ANI 	0FEh
	OUT 	48h
	OUT 	60h
	MOV 	A,B
	CPI 	0A5h
	JRNZ  	H12B7
	LXI 	H,H0018
	LDA 	HFFFB
	ORI 	01h
	OUT 	48h
	PCHL	
	HLT 	
H12B7	LXI 	H,0000h
	DAD 	SP
	LXIX  	H12C2
	JMP 	00EFh
H12C2	MVI 	A,04h
	OUT 	1Ah
	MVI 	A,07h
	OUT 	19h
	LXIX  	H12D1
	JMP 	H0C53
H12D1	MVI 	A,00h
	OUT 	1Ah
	MVI 	C,02h
	MVI 	A,0Ch
	OUTP  	A
	OUTP  	L
	INR 	A
	OUTP  	A
	OUTP  	H
	HLT 	
H12E3	POPIX 	
	PUSH	H
	LXI 	B,0006h
	LXI 	H,0000h
	DAD 	SP
	DAD 	B
	LXI 	SP,HFFE0
	PUSH	H
	ANA 	A
	DSBC  	B 
	SPHL	
	POP 	H
	POP 	B
	POP 	PSW
	LXI 	SP,HFFDE
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	EXX 	
	EXAF	
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	EXX 	
	EXAF	
	PUSHIX	
	PUSHIY	
	LDAI  	
	MOV 	D,A
	IN  	62h
	MOV 	E,A
	PUSH	D
	MVI 	B,02h
	MVI 	C,02h
H1317	MVI 	A,00h
	OUTP  	A
	INP   	D
	MVI 	A,01h
	OUTP  	A
	INP   	E
	PUSH	D
	MVI 	A,02h
	OUTP  	A
	INP   	D
	MVI 	A,03h
	OUTP  	A
	INP   	E
	PUSH	D
	MVI 	A,0Ah
	OUTP  	A
	INP   	D
	MVI 	A,0Ch
	OUTP  	A
	INP   	E
	PUSH	D
	MVI 	A,0Dh
	OUTP  	A
	INP   	D
	MVI 	A,0Fh
	OUTP  	A
	INP   	E
	PUSH	D
	MVI 	C,00h
	DJNZ  	H1317
	IN  	03h
	MOV 	D,A
	IN  	01h
	MOV 	E,A
	PUSH	D
	MVI 	B,10h
	MVI 	C,10h
H135A	BIT   	0,B
	JRNZ  	H1362
	INP   	D
	JR    	H1365
H1362	INP   	E
	PUSH	D
H1365	INR 	C
	DJNZ  	H135A
	MVI 	A,00h
	MVI 	C,10h
	MVI 	B,08h
H136E	OUT 	18h
	BIT   	0,B
	JRNZ  	H1378
	INP   	D
	JR    	H137B
H1378	INP   	E
	PUSH	D
H137B	INR 	A
	DJNZ  	H136E
	LXI 	H,H1395
	LXIX  	H1388
	JMP 	00EFh
H1388	MVI 	A,01h
	OUT 	20h
	MVI 	A,00h
	OUT 	21h
	MVI 	A,32h
	OUT 	48h
	PCHL	
H1395	MVI 	D,0F6h
H1397	LXIX  	H139E
	JMP 	H0C53
H139E	OUT 	61h
	IN  	62h
	BIT   	5,A
	JRNZ  	H13B4
	SUB 	A
	CMP 	D
	JRZ   	H1397
	INR 	D
	JRNZ  	H1397
	LXIX  	H1397
	JMP 	H0C62
H13B4	LXI 	B,0008h
	LXIX  	H13BE
	JMP 	H0C56
H13BE	OUT 	60h
	SUB 	A
	CMP 	D
	JNZ	H1424
	MVI 	A,02h
	OUT 	48h
H13C9	OUT 	61h
	IN  	62h
	BIT   	4,A
	JRNZ  	H13C9
	LXI 	H,H0D04
	LXI 	B,1500h
	OUTIR 	
H13D9	IN  	00h
	BIT   	0,A
	JRZ   	H13D9
	IN  	01h
	ANI 	0F4h
	CPI 	0A4h
	JRZ   	H13EF
	ANI 	0F0h
	CPI 	0A0h
	JRNZ  	H13D9
	JR    	H1424
H13EF	IN  	00h
	BIT   	0,A
	JRZ   	H13EF
	IN  	01h
	CPI 	20h
	JZ 	H00B3
	CPI 	08h
	JZ 	00E7h
	CPI 	51h
	JZ 	H1A7C
	CPI 	18h
	JZ 	H1805
	CPI 	17h
	JZ 	H1A23
	CPI 	23h
	JZ 	H1B42
	JR    	H1424
H1417	LXI 	H,H141D
	JMP 	H1388
H141D	LXIX  	H1424
	JMP 	00EFh
H1424	OUT 	61h
	IN  	62h
	BIT   	4,A
	JRNZ  	H1424
	LXI 	H,H1432
	JMP 	H1388
H1432	LXIX  	H1439
	JMP 	00EFh
H1439	MVI 	B,00h
	MVI 	C,02h
	MVI 	A,02h
	OUTP  	A
	OUTP  	B
	ADI 	0Ah
	OUTP  	A
	OUTP  	B
	INR 	A
	OUTP  	A
	OUTP  	B
	LXI 	B,1000h
	MVI 	D,10h
	LXI 	H,0000h
	EXX 	
	MVI 	C,4Dh
	EXX 	
	MVI 	A,40h
	OUT 	49h
	IN  	11h
	MOV 	E,A
	BIT   	6,E
	JRZ   	H146D
	OUT 	4Dh
	IN  	0FFh
	CPI 	0FFh
	JRNZ  	H1481
H146D	EXX 	
	MVI 	C,4Eh
	EXX 	
	BIT   	1,E
	JRZ   	H14A5
	OUT 	4Eh
	IN  	0FFh
	CPI 	0FFh
	JRNZ  	H1481
	JR    	H14A5
H147F	IN  	0FFh
H1481	MOV 	M,A
	CCI   	
	JPE	H147F
	LXI 	B,1000h
	EXX 	
	OUTP  	B
	EXX 	
	DCR 	D
	JRNZ  	H147F
	SUB 	A
	OUT 	49h
	JMP 	H179C

H1497	DB	00h,0A0h,01h,00h,07h,00h,00h,00h,00h,01h,00h,00h,0D0h,0FDh

H14A5	LXI  	H,H1497
	LXI 	D,HFD50
	LXI 	B,000Eh
	LDIR  	
	LXI 	H,HFD50
	SHLD	HFFFE
	SUB 	A
	STA 	HFFFD
	MVI 	D,03h
	LXIX  	H14FC
H14C0	SUB 	A
	OUT 	49h
	MVI 	A,01h
	STA 	HFFFC
	MVI 	A,05h
	OUT 	18h
	MVI 	A,40h
	OUT 	49h
	MVI 	B,08h
H14D2	NOP 	
	DJNZ  	H14D2
	MOV 	A,D
	STA 	HFFFC
	MVI 	B,10h
H14DB	IN  	13h
	BIT   	6,A
	JRNZ  	H14EC
	IN  	12h
	BIT   	1,A
	JRNZ  	H14F1
	DJNZ  	H14DB
	INR 	B
	PCIX  	
H14EC	EXX 	
	MVI 	C,4Dh
	JR    	H14F4
H14F1	EXX 	
	MVI 	C,4Eh
H14F4	EXX 	
	SUB 	A
	OUT 	13h
	OUT 	12h
	PCIX  	
H14FC	JNZ	H1780
	CALL	H0311
	LXI 	H,HC785
	SHLD	HA900+2
	LXI 	D,H1220
	CALL	H0C79
	LXIY  	HFD50
	LXI 	H,0000h
H1515	STY   	H,05h
	LXIX  	H151F
	JMP 	H173C
H151F	JRZ   	H152E
H1521	MOV 	A,H
	INR 	A
	CPI 	04h
	MOV 	H,A
	JRNZ  	H1515
	MVI 	H,00h
	DCR 	L
	JRNZ  	H1515
	HLT 	
H152E	MOV 	C,H
	MOV 	D,L
	LXI 	H,HFDD2
	BIT   	1,M
	MOV 	H,C
	MOV 	L,D
	JRZ   	H1521
	LXI 	H,HFDE0
	MVI 	B,0Ch
	MOV 	A,M
H153F	INX 	H
	XRA 	M
	DJNZ  	H153F
	INX 	H
	CMP 	M
	MOV 	H,C
	MOV 	L,D
	JRNZ  	H1521
	LXI 	H,H154F
	JMP 	H1388
H154F	LXIX  	HFDD0
	LDX   	B,13h
	LDX   	D,10h
	LDX   	E,11h
	LDX   	C,12h
	LDX   	A,1Ch
H1562	STY   	B,09h
	STY   	D,08h
	STY   	E,07h
	STY   	C,06h
	CPI 	01h
	JZ 	H15D7
	CPI 	00h
	JNZ	H1776
	LDX   	H,14h
	LDX   	L,15h
	MOV 	A,C
	ANA 	A
	JRZ   	H1584
	MVI 	A,09h
H1584	ADD 	B
	MOV 	B,A
	LDX   	A,16h
	ANA 	A
	JRZ   	H158E
	MVI 	A,09h
H158E	ADDX  	17h
	ANA 	A
	DSBC  	D 
	JC 	H1776
	JRNZ  	H15A1
	SUB 	B
	JC 	H1776
	INR 	A
	MOV 	L,A
	JR    	H15B6
H15A1	MOV 	C,A
	MVI 	A,12h
	SUB 	B
	INR 	A
	ADD 	C
	XCHG	
	MVI 	H,00h
	MOV 	L,A
	LXI 	B,0012h
H15AE	DCX 	D
	MOV 	A,D
	ORA 	E
	JRZ   	H15B6
	DAD 	B
	JR    	H15AE
H15B6	STY   	L,02h
	ANA 	A
	LXI 	D,007Fh
	DSBC  	D 
	JNC	H1776
	MVIY  	00h,0Ch
	MVIY  	00h,0Dh
	LXIX  	H15D1
	JMP 	H173C
H15D1	JNZ	H1780
	JMP 	H179C
H15D7	LXIX  	H15DE
	JMP 	H173C
H15DE	JNZ	H1780
	LXI 	H,HFDD4
	LXIX  	H15EB
	JMP 	H16EF
H15EB	MVI 	C,02h
	MVI 	A,0Ch
	OUTP  	A
	OUTP  	D
	INR 	A
	OUTP  	A
	OUTP  	E
	MVI 	A,02h
	OUTP  	A
	OUTP  	B
	LXI 	H,HFDD0
	LXIX  	H1608
	JMP 	H16EF
H1608	STY   	E,0Ch
	STY   	D,0Dh
	MOV 	A,B
	ANA 	A
	JRZ   	H1614
	MVI 	A,01h
H1614	STY   	A,0Bh
	LXI 	H,HFDD8
	LXIX  	H1621
	JMP 	H172C
H1621	XCHG	
	DAD 	B
	JC 	H1776
	LXI 	D,HFD51
	DSBC  	D 
	JNC	H1776
	MOV 	D,B
	MOV 	E,C
	LXI 	H,HFDDC
	LXIX  	H163A
	JMP 	H172C
H163A	LXI 	H,H0200
	ANA 	A
	DSBC  	B 
	JC 	H1776
	XCHG	
	DSBC  	D 
	JRC   	H165D
	LXIX  	H1672
	MOV 	A,H
	EXX 	
	MOV 	H,A
	EXX 	
	MOV 	A,L
	EXX 	
	MOV 	L,A
	EXX 	
	MOV 	B,D
	MOV 	C,E
	LXI 	H,HFFD0
	DSBC  	B 
	JR    	H1669
H165D	LXIX  	H179C
	DAD 	D
	XCHG	
	LXI 	H,HFDD0
	DAD 	B
	MOV 	B,D
	MOV 	C,E
H1669	LDY   	E,0Ch
	LDY   	D,0Dh
	JMP 	H16C8
H1672	XCHG	
	STY   	L,0Ch
	STY   	H,0Dh
	MVIY  	0E0h,01h
	EXX 	
	LXI 	D,H0200
	SUB 	A
H1682	INR 	A
	DSBC  	D 
	JRNC  	H1682
	DAD 	D
	EXX 	
	DCR 	A
	JRZ   	H169D
	STY   	A,02h
	LXI 	D,H0200
H1692	DAD 	D
	DCR 	A
	JRNZ  	H1692
	LXIX  	H169D
	JMP 	H173C
H169D	LXI 	D,HFDD0
	MVIY  	00h,0Bh
	STY   	E,0Ch
	STY   	D,0Dh
	MVIY  	01h,02h
	LXIX  	H16B5
	JMP 	H173C
H16B5	XCHG	
	EXX 	
	MOV 	A,H
	EXX 	
	MOV 	B,A
	EXX 	
	MOV 	A,L
	EXX 	
	MOV 	C,A
	LXI 	H,HFDD0
	LXIX  	H179C
	JMP 	H16C8
H16C8	EXX 	
	MOV 	A,B
	EXX 	
	ANA 	A
	JRZ   	H16E3
	MOV 	A,D
	ANI 	0E0h
	CPI 	0E0h
	JRNZ  	H16E3
	MVI 	A,0CCh
	OUT 	4Ah
	BIT   	5,D
	JRZ   	H16E1
	RES   	5,D
	JR    	H16E3
H16E1	SETB  	5,D
H16E3	MOV 	A,B
	ORA 	C
	JRZ   	H16ED
	LDIR  	
	MVI 	A,0C8h
	OUT 	4Ah
H16ED	PCIX  	
H16EF	MVI 	D,00h
	MVI 	E,00h
	MOV 	A,M
	ANA 	A
	JNZ	H1776
	INX 	H
	MOV 	A,M
	MOV 	B,A
	EXX 	
	MOV 	B,A
	EXX 	
	CPI 	06h
	JNC	H1776
	CPI 	02h
	JZ 	H1776
	CPI 	03h
	JZ 	H1776
	CPI 	00h
	JRZ   	H1720
	MVI 	D,7Fh
	MOV 	A,B
	CPI 	01h
	JRZ   	H1720
	MVI 	E,04h
	CPI 	04h
	JRZ   	H1720
	MVI 	E,0Ch
H1720	MOV 	A,E
	OUT 	50h
	MOV 	A,D
	OUT 	4Bh
	INX 	H
	MOV 	D,M
	INX 	H
	MOV 	E,M
	PCIX  	
H172C	SUB 	A
	ANA 	M
	JNZ	H1776
	INX 	H
	ANA 	M
	JNZ	H1776
	INX 	H
	MOV 	B,M
	INX 	H
	MOV 	C,M
	PCIX  	
H173C	MVI 	B,05h
H173E	STY   	B,00h
H1741	MVI 	B,00h
	LXI 	D,0013h
	EXX 	
	OUTP  	A
	MOV 	A,C
	EXX 	
	MOV 	C,A
H174C	MOV 	A,C
	CPI 	4Eh
	JRZ   	H1759
	IN  	13h
	BIT   	6,A
	JRNZ  	H176A
	JR    	H175F
H1759	IN  	12h
	BIT   	1,A
	JRNZ  	H176A
H175F	DJNZ  	H174C
	DCR 	D
	JRNZ  	H174C
	DCR 	E
	JRNZ  	H174C
	DCR 	E
	JR    	H1774
H176A	SUB 	A
	OUT 	13h
	OUT 	12h
	LDY   	A,11h
	BIT   	7,A
H1774	PCIX  	
H1776	LXI 	D,H1202
	JR    	H1783
H177B	LXI 	D,H11F6
	JR    	H1783
H1780	LXI 	D,H11EB
H1783	SUB 	A
	OUT 	4Bh
	MVI 	A,0C8h
	OUT 	4Ah
	EXX 	
	LXI 	SP,H8000
	CALL	H0311
	EXX 	
	LXI 	H,HC785
	SHLD	HA900+2
	CALL	H0C79
	HLT 	
H179C	EXX 	
	LXI 	H,4B44h
	EXX 	
	SUB 	A
	OUT 	50h
	MVI 	E,02h
	MVI 	A,0CEh
	OUT 	4Ah
H17AA	MVI 	D,02h
	MVI 	A,0FEh
	OUT 	4Bh
H17B0	MOV 	A,E
	LXI 	B,HE000
	CPI 	02h
	JRNZ  	H17BB
	LXI 	B,H2000
H17BB	LXI 	H,H2000
H17BE	CCI   	
	JPE	H17BE
	EXX 	
	LXI 	H,0000h
	EXX 	
	MVI 	A,00h
	OUT 	4Bh
	DCR 	D
	JRNZ  	H17B0
	MVI 	A,0C8h
	OUT 	4Ah
	DCR 	E
	JRNZ  	H17AA
	MVI 	A,02h
	OUT 	02h
	IN  	02h
	INR 	A
	LXIX  	H17E4
	JMP 	H1BA8
H17E4	MVI 	C,02h
	MVI 	A,0Ch
	OUTP  	A
	INP   	H
	INR 	A
	OUTP  	A
	INP   	L
	MVI 	A,33h
	OUT 	48h
	PCHL	
	HLT

H17F7	DB 00h,0A0h,70h,00h,07h,00h,01h,00h,00h
	DB 08h,00h,00h,00h,20h

H1805	MVI	D,03h
	LXIX  	H180E
	JMP 	H14C0
H180E	JNZ	H177B
	LDA 	HFFFD
	LHLD	HFFFE
	CPI 	06h
	JNC	H177B
	INR 	A
	EXX 	
	EXAF	
	MOV 	A,C
	EXAF	
	LXIX  	H1828
	JMP 	H1BA8
H1828	EXAF	
	MOV 	C,A
	EXAF	
	EXX 	
	MOV 	A,H
	CPI 	20h
	JC 	H177B
	XCHG	
	LXIY  	0000h
	DADY  	D 
	LXI 	H,H17F7
	LXI 	B,000Eh
	LDIR  	
	MVI 	B,07h
	LXIX  	H184A
	JMP 	H173E
H184A	JNZ	H177B
	SUB 	A
	OUT 	4Bh
	LDA 	HFFFD
	MOV 	C,A
	SUB 	A
	STA 	HFFFD
	LXI 	H,H8000
	SHLD	HFFFE
	MVI 	B,00h
	MOV 	A,C
	ANA 	A
	JRZ   	H1866
	MVI 	B,0FFh
H1866	MOV 	A,B
	OUT 	4Bh
	MVI 	B,0Ah
	LXIX  	H1872
	JMP 	H173E
H1872	JNZ	H177B
	SUB 	A
	OUT 	4Bh
	OUT 	50h
	LXIY  	H8000
	MVIY  	10h,02h
	MVIY  	00h,06h
	MVIY  	01h,09h
	MVIY  	40h,0Dh
	EXX 	
	MVI 	B,02h
	EXX 	
H1892	MVI 	A,0CEh
	OUT 	4Ah
	LXI 	H,H2000
	LXI 	D,H6000
	LXI 	B,H2000
	LDIR  	
	SUB 	A
	OUT 	4Ah
	LXIX  	H18AD
	MVI 	B,07h
	JMP 	H173E
H18AD	JNZ	H177B
	EXX 	
	DCR 	B
	EXX 	
	JRZ   	H18C3
	MVIY  	07h,07h
	MVIY  	03h,09h
	MVI 	A,02h
	OUT 	4Bh
	JR    	H1892
H18C3	MVIY  	0E0h,01h
	MVIY  	70h,02h
	MVIY  	01h,0Bh
	MVIY  	20h,0Dh
	LXIX  	H18DA
	JMP 	H1741
H18DA	JNZ	H177B
	MVIY  	00h,0Bh
	MVIY  	40h,02h
	LXI 	H,H18E8
H18E8	MVI 	A,02h
	JR    	H1900
	MVI 	A,0Ah
	JR    	H1900
	MVI 	A,04h
	JR    	H1900
	MVI 	A,0Ch
	JR    	H1900
	SUB 	A
	OUT 	50h
	OUT 	4Bh
	JMP 	H1A95
H1900	EXX 	
	OUT 	50h
	SUB 	A
	OUT 	4Bh
	LXI 	H,H4000
	SHLD	HFFFE
	STA 	HFFFD
	MVI 	B,0Ah
	LXIX  	H1918
	JMP 	H173E
H1918	JNZ	H177B
	LXI 	D,H8000
	LXIY  	H4000
	STY   	D,0Dh
	MVI 	A,0Eh
	OUT 	4Bh
	MVI 	A,0CCh
	OUT 	4Ah
	LXI 	H,H2000
	LXI 	B,H2000
	LDIR  	
	MVI 	A,0C8h
	OUT 	4Ah
	LXI 	H,H2000
	LXI 	D,HA000
	LXI 	B,H6000
	LDIR  	
	SUB 	A
	OUT 	4Bh
	MVI 	B,07h
	LXIX  	H1950
	JMP 	H173E
H1950	JNZ	H177B
	LXI 	H,HC000
	SHLD	HFFFE
	SUB 	A
	STA 	HFFFD
	MVI 	B,0Ah
	LXIX  	H1966
	JMP 	H173E
H1966	JNZ	H177B
	LXI 	D,H2000
	LXIY  	HC000
	STY   	D,0Dh
	MVI 	A,0F0h
	OUT 	4Bh
	LXI 	H,H8000
	LXI 	B,H6000
	LDIR  	
	MVI 	A,80h
	OUT 	4Bh
	LXI 	D,H8000
	LXI 	H,HE000
	LXI 	B,H2000
	LDIR  	
	MVI 	B,07h
	LXIX  	H1997
	JMP 	H173E
H1997	JNZ	H177B
	EXX 	
	LXI 	D,0004h
	DAD 	D
	PCHL	
H19A0	LXI 	H,H19A6
	JMP 	H1388
H19A6	LXIX  	H19AD
	JMP 	00EFh
H19AD	EXX 	
	LHLD	HFFFE
	EXX 	
	LXI 	H,HFD50
	SHLD	HFFFE
	LDA 	HFFFD
	CPI 	06h
	JNC	H1776
	MOV 	E,A
	SUB 	A
	STA 	HFFFD
	MVI 	D,03h
	LXIX  	H19CE
	JMP 	H14C0
H19CE	JNZ	H1780
	MOV 	A,E
	INR 	A
	LXIX  	H19DA
	JMP 	H1BA8
H19DA	EXX 	
	MOV 	A,H
	CPI 	20h
	MVI 	A,0C8h
	JRNC  	H19E6
	MVI 	A,0CEh
	SETB  	5,H
H19E6	XCHG	
	OUT 	4Ah
	LXIY  	0000h
	DADY  	D 
	EXX 	
	LDY   	D,08h
	LDY   	E,07h
	LDY   	B,09h
	LDY   	C,06h
	LDY   	H,05h
	MVI 	A,0C8h
	OUT 	4Ah
	SUB 	A
	OUT 	4Bh
	OUT 	50h
	EXX 	
	MOV 	A,C
	LXI 	H,H1497
	LXI 	D,HFD50
	LXI 	B,000Eh
	LDIR  	
	MOV 	C,A
	EXX 	
	LXIY  	HFD50
	STY   	H,05h
	MVI 	A,01h
	JMP 	H1562
H1A23	CALL	H0311
	MVI 	A,0Ah
	OUT 	20h
	MVI 	A,0FFh
	OUT 	21h
	LXI 	H,H1EC9
	MVI 	A,16h
	OUT 	48h
	MVI 	A,00h
	OUT 	63h
	MVI 	C,64h
	MVI 	D,0Fh
H1A3D	INX 	H
	MOV 	B,M
	INX 	H
	MOV 	A,M
	OUTP  	A
	DCR 	D
	JRNZ  	H1A3D
	MVI 	A,12h
	OUT 	48h
	LXI 	H,HC000
	LXI 	D,HC000+1
	LXI 	B,H07D0
	MVI 	M,00h
	LDIR  	
	LXI 	H,HD027
	LXI 	D,004Fh
	MVI 	B,19h
H1A5F	MVI 	M,01h
	INX 	H
	MVI 	M,41h
	DAD 	D
	DJNZ  	H1A5F
	LXI 	H,HD3C0
	LXI 	D,HD3C1
	LXI 	B,004Fh
	MVI 	M,09h
	LDIR  	
	LXI 	H,HD3E8
	MVI 	M,49h
	JMP 	H1A95
H1A7C	MVI 	A,6Ch
	OUT 	4Ch
	MVI 	A,82h
	OUT 	48h
	LXI 	H,HC000
	LXI 	B,0100h
H1A8A	MVI 	M,00h
	CCI   	
	JPE	H1A8A
	MVI 	A,02h
	OUT 	48h
H1A95	MVI 	D,02h
H1A97	LXIX  	H1A9E
	JMP 	H0C62
H1A9E	LXIX  	H1AA5
	JMP 	H0C53
H1AA5	DCR 	D
	JRNZ  	H1A97
	JMP 	H13D9

H1AAB	DB '  UTS-30 MEMORY DUMP - '
H1AC2	DB 'MAIN               USER               GRAPHICS LOWER MAINGRAPHIC'
H1B02	DB 'S UPPER MAINGRAPHICS LOWER USERGRAPHICS UPPER USER'
H1B34	DB	15h,14h,2Eh,39h,01h,2Bh,46h,27h,38h,3Fh,1Eh,11h,21h,23h

H1B42	LXI	H,H0D04
	LXI 	B,1500h
	OUTIR 	
	MVI 	A,9Ch
	OUT 	1Ch
	MVI 	A,05h
	OUT 	18h
	MVI 	A,02h
	OUT 	10h
	MVI 	A,05h
	OUT 	1Eh
	MVI 	A,05h
	OUT 	1Fh
	LXI 	H,H1B64
	JMP 	H1CEC
H1B64	LXIY  	H1AC2
	LXIX  	H1B76
	JMP 	H1BD2
H1B6F	LXIX  	H1B76
	JMP 	H0C62
H1B76	IN  	00h
	BIT   	0,A
	JRZ   	H1B76
	IN  	01h
	ANI 	0F4h
	CPI 	0A4h
	JRNZ  	H1B6F
H1B84	IN  	00h
	BIT   	0,A
	JRZ   	H1B84
	IN  	01h
	LXI 	H,H1B34
	LXI 	B,000Eh
	CCIR  	
	JRNZ  	H1B6F
	LXI 	D,H1B34
	ANA 	A
	DSBC  	D 
	MOV 	A,L
	CPI 	09h
	JC 	H1BF7
	SUI 	08h
	LXIX  	H1B76
H1BA8	LXI 	H,H1BC6
	LXI 	D,0002h
	EXX 	
	LXIY  	H1AC2
	LXI 	D,0013h
	EXX 	
	CPI 	07h
	JRNC  	H1BD2
H1BBB	DCR 	A
	JRZ   	H1BC5
	DAD 	D
	EXX 	
	DADY  	D 
	EXX 	
	JR    	H1BBB
H1BC5	PCHL	

H1BC6	DB 18h,0Ah
	DB 18h,0Eh
	DB 18h,10h
	DB 18h,12h
	DB 18h,14h
	DB 18h,16h

H1BD2	MVI 	A,00h
	MVI 	C,00h
	JR    	H1BEC
	MVI 	C,00h
	JR    	H1BEA
	MVI 	C,02h
	JR    	H1BEA
	MVI 	C,0Ah
	JR    	H1BEA
	MVI 	C,04h
	JR    	H1BEA
	MVI 	C,0Ch
H1BEA	MVI 	A,0FFh
H1BEC	OUT 	4Bh
	MVI 	A,0C8h
	OUT 	4Ah
	MOV 	A,C
	OUT 	50h
	PCIX  	
H1BF7	LXI 	D,H2000
	LXI 	H,0000h
	LXIX  	0000h
	DCR 	A
	JRNZ  	H1C09
	MVI 	B,0CEh
	DAD 	D
	JR    	H1C11
H1C09	DAD 	D
	DADX  	D 
	DCR 	A
	JRNZ  	H1C09
	MVI 	B,0C8h
H1C11	XCHG	
	MOV 	A,B
	OUT 	4Ah
	LXI 	B,H0200
H1C18	EXX 	
	LXI 	H,H1AAB
	MVI 	B,17h
H1C1E	MOV 	A,M
	INX 	H
	EXX 	
	LXI 	H,H1C27
	JMP 	H1CEC
H1C27	EXX 	
	DJNZ  	H1C1E
	SPIY  	
	LXI 	H,0000h
	DAD 	SP
	MVI 	B,13h
H1C32	MOV 	A,M
	INX 	H
	EXX 	
	LXI 	H,H1C3B
	JMP 	H1CEC
H1C3B	EXX 	
	DJNZ  	H1C32
	MVI 	A,0Ah
	MVI 	B,02h
	LXI 	H,H1C48
	JMP 	H1D17
H1C48	EXAF	
	MVI 	A,30h
H1C4B	EXAF	
	MVI 	B,02h
	LXI 	H,H1C54
	JMP 	H1D15
H1C54	SPIX  	
	LXI 	H,0000h
	DAD 	SP
	MOV 	A,H
	MOV 	E,L
	LXI 	H,H1C62
	JMP 	H1D21
H1C62	MOV 	A,E
	LXI 	H,H1C69
	JMP 	H1D21
H1C69	MVI 	B,02h
	LXI 	H,H1C71
	JMP 	H1D15
H1C71	MVI 	E,10h
H1C73	EXX 	
	LDAX	D
	INX 	D
	INXIX 	
	EXX 	
	LXI 	H,H1C7F
	JMP 	H1D21
H1C7F	MVI 	B,01h
	LXI 	H,H1C87
	JMP 	H1D15
H1C87	DCR 	E
	JRNZ  	H1C73
	MVI 	B,02h
	LXI 	H,H1C92
	JMP 	H1D15
H1C92	EXX 	
	MVI 	A,2Ah
	LXI 	H,H1C9B
	JMP 	H1CEC
H1C9B	XCHG	
	LXI 	D,0010h
	ANA 	A
	DSBC  	D 
	XCHG	
	EXX 	
	MVI 	E,10h
H1CA6	EXX 	
	LDAX	D
	INX 	D
	CPI 	20h
	JRC   	H1CB1
	CPI 	80h
	JRC   	H1CB3
H1CB1	MVI 	A,7Eh
H1CB3	LXI 	H,H1CB8
	JR    	H1CEC
H1CB8	EXX 	
	DCR 	E
	JRNZ  	H1CA6
	EXX 	
	MVI 	A,2Ah
	LXI 	H,H1CC4
	JR    	H1CEC
H1CC4	MVI 	A,0Ah
	LXI 	H,H1CCB
	JR    	H1CEC
H1CCB	CCI   	
	JPO	H1CE2
	EXAF	
	EXX 	
	DCR 	A
	JNZ	H1C4B
	EXAF	
	EXX 	
	MVI 	A,0Ch
	LXI 	H,H1CDF
	JR    	H1CEC
H1CDF	JMP 	H1C18
H1CE2	MVI 	A,0Ch
	LXI 	H,H1CE9
	JR    	H1CEC
H1CE9	JMP 	H1B76
H1CEC	EXX 	
	MOV 	D,A
	EXX 	
H1CEF	IN  	13h
	BIT   	1,A
	JRZ   	H1CEF
	MVI 	A,00h
H1CF7	DCR 	A
	JRNZ  	H1CF7
	MVI 	A,10h
	OUT 	00h
	IN  	00h
	BIT   	4,A
	JZ 	H1B6F
	BIT   	5,A
	JRZ   	H1CEF
	MVI 	A,00h
	OUT 	13h
	IN  	1Eh
	EXX 	
	MOV 	A,D
	EXX 	
	OUT 	1Fh
	PCHL	
H1D15	MVI 	A,20h
H1D17	EXX 	
	LXI 	H,H1D1D
	JR    	H1CEC
H1D1D	EXX 	
	DJNZ  	H1D17
	PCHL	
H1D21	MOV 	C,A
	MVI 	B,02h
	RAR 	
	RAR 	
	RAR 	
	RAR 	
H1D28	EXX 	
	LXI 	H,H1D2E
	JR    	H1D39
H1D2E	LXI 	H,H1D33
	JR    	H1CEC
H1D33	EXX 	
	MOV 	A,C
	DCR 	B
	JRNZ  	H1D28
	PCHL	
H1D39	ANI 	0Fh
	CPI 	0Ah
	JRC   	H1D44
	SUI 	09h
	ORI 	40h
	PCHL	
H1D44	ORI 	30h
H1D46	PCHL	

	DB 3Eh,63h,63h,63h,63h,63h,63h,63h
	DB 3Eh,0Ch,1Ch,3Ch,0Ch,0Ch,0Ch,0Ch
	DB 0Ch,1Eh,3Eh,63h,63h,03h,06h,1Ch
	DB 30h,60h,7Fh,3Eh,63h,63h,03h,0Eh
	DB 03h,63h,63h,3Eh,06h,0Eh,1Eh,36h
	DB 66h,66h,7Fh,06h,06h,7Fh,60h,60h
	DB 7Eh,63h,03h,03h,63h,3Eh,1Eh,30h
	DB 60h,60h,7Eh,63h,63h,63h,3Eh,7Fh
	DB 63h,03h,06h,0Ch,0Ch,18h,18h,18h
	DB 3Eh,63h,63h,63h,3Eh,63h,63h,63h
	DB 3Eh,3Eh,63h,63h,63h,3Fh,03h,03h
	DB 06h,3Ch,1Ch,22h,02h,04h,08h,08h
	DB 00h,00h,08h,08h,14h,22h,41h,41h
	DB 7Fh,41h,41h,41h,7Eh,41h,41h,42h
	DB 7Ch,42h,41h,41h,7Eh,1Eh,21h,40h
	DB 40h,40h,40h,40h,21h,1Eh,7Ch,42h
	DB 41h,41h,41h,41h,41h,42h,7Ch,7Fh
	DB 40h,40h,40h,7Ch,40h,40h,40h,7Fh
	DB 7Fh,40h,40h,40h,7Ch,40h,40h,40h
	DB 40h,1Eh,21h,40h,40h,47h,41h,41h
	DB 23h,1Dh,41h,41h,41h,41h,7Fh,41h
	DB 41h,41h,41h,1Ch,08h,08h,08h,08h
	DB 08h,08h,08h,1Ch,01h,01h,01h,01h
	DB 01h,01h,41h,22h,1Ch,41h,42h,44h
	DB 48h,50h,48h,44h,42h,41h,40h,40h
	DB 40h,40h,40h,40h,40h,40h,7Fh,63h
	DB 55h,55h,49h,49h,41h,41h,41h,41h
	DB 61h,51h,51h,49h,49h,49h,45h,45h
	DB 43h,1Ch,22h,41h,41h,41h,41h,41h
	DB 22h,1Ch,7Eh,41h,41h,41h,7Eh,40h
	DB 40h,40h,40h,1Ch,22h,41h,41h,41h
	DB 49h,45h,22h,1Dh,7Eh,41h,41h,41h
	DB 7Eh,48h,44h,42h,41h,3Eh,41h,40h
	DB 40h,3Eh,01h,01h,41h,3Eh,7Fh,08h
	DB 08h,08h,08h,08h,08h,08h,08h,41h
	DB 41h,41h,41h,41h,41h,41h,22h,1Ch
	DB 41h,41h,41h,22h,22h,14h,14h,08h
	DB 08h,41h,41h,49h,49h,49h,49h,49h
	DB 55h,22h,41h,41h,22h,14h,08h,14h
	DB 22h,41h,41h,41h,41h,41h,22h,14h
	DB 08h,08h,08h,08h,7Fh,01h,02h,04h
	DB 08h,10h,20h,40h
H1E93	DB 7Fh,49h,01h,01h,02h,01h,03h,01h
	DB 04h,03h,05h,0Fh,66h,7Eh,07h,00h
	DB 68h,7Eh,09h,0Fh,0Ah,03h,0Bh,01h
	DB 0Ch,01h,0Dh,01h,4Ch,21h,00h,22h
	DB 00h,23h,00h,24h,40h,25h,70h,16h
	DB 7Fh,07h,00h,18h,7Fh,29h,70h,2Ah
	DB 40h,2Bh,00h,2Ch,00h,2Dh
H1EC9	DB 00h,70h,7Fh,51h,00h,52h,00h,53h
	DB 00h,54h,00h,55h,00h,56h,00h,77h
	DB 7Fh,78h,7Fh,59h,52h,5Ah,54h,5Bh
	DB 52h,5Ch,54h,5Dh,52h,7Eh,7Fh,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h,00h,00h,00h,00h,00h,00h
	DB 00h,00h
	DB 9Eh,61h,61h,9Eh	;last 4 bytes = integrity signature (copy)
H1FFF	DB 6Fh

H2000	EQU	$
H4000	EQU	4000h
H6000	EQU	6000h
H8000	EQU	8000h
HA000	EQU	0A000h
HA900	EQU	HA000+900h
HC000	EQU	0C000h
HC785	EQU	0C785h
HC7D0	EQU	0C7D0h
HC7D1	EQU	0C7D1h
HC7E0	EQU	0C7E0h
HC800	EQU	0C800h
HD000	EQU	0D000h
HD001	EQU	0D001h
HD027	EQU	0D027h
HD3C0	EQU	0D3C0h
HD3C1	EQU	0D3C1h
HD3E8	EQU	0D3E8h
HD7D0	EQU	0D7D0h
HD7D1	EQU	0D7D1h
HD7E0	EQU	0D7E0h
HD800	EQU	0D800h
HE000	EQU	0E000h
HFD50	EQU	0FD50h
HFD51	EQU	0FD51h
HFDD0	EQU	0FDD0h
HFDD2	EQU	0FDD2h
HFDD4	EQU	0FDD4h
HFDD8	EQU	0FDD8h
HFDDC	EQU	0FDDCh
HFDE0	EQU	0FDE0h
HFFD0	EQU	0FFD0h
HFFDE	EQU	0FFDEh
HFFE0	EQU	0FFE0h
HFFFA	EQU	0FFFAh
HFFFB	EQU	0FFFBh
HFFFC	EQU	0FFFCh
HFFFD	EQU	0FFFDh
HFFFE	EQU	0FFFEh

	END
