;
;	port addresses (cannot be used PUBLIC)
;	last edit: 7/20/25

;	78530 Serial Communications Controller (SCC)
KEYREG	EQU	00h		;SCC channel B keyboard control registers I/O
KEYDAT	EQU	01h		;SCC channel B keyboard data (up to 8 keystrokes buffered)
COMREG	EQU	02h		;SCC channel A modem communications control registers I/O
COMDAT	EQU	03h		;SCC channel A modem communications data

;	MK3801 Serial Timer Interrupts (STI)
;	Timer Output D - Drives RTxC (if enabled)
;	Timer D can be switched between receive/transmit and drive control ?

STIREG	EQU	10h		;STI timer control base address
;	EQU	11h		;input ???
;	EQU	12h		;in/out ??? (in rom code)
;	EQU	13h		;in/out ??? (in rom code)
;	EQU	16h		;in/out ??? (in rom code)
;	EQU	17h		;in/out ??? (in rom code)
;	EQU	18h		;in/out ??? (in rom code)
;	EQU	19h		;output ??? (in rom code)
;	EQU	1Ah		;output ???
;	EQU	1Ch		;output ??? (in rom code)
;	EQU	1Dh		;in/out ??? (in rom code)
;	EQU	1Eh		;in/out ??? (in rom code)
;	EQU	1Fh		;in/out ??? (in rom code)

;	HD6845 CRT controller
CRTREG	EQU	20h		;CRT controller register select
CRTPARM	EQU	21h		;CRT controller parameters

;	EQU	41h		;communications status register
;	EQU	42h		;communications strobe

DSPCTRL	EQU	48h		;display control register of 32 addressable 80 character rows. Also ROM control
COMCTRL	EQU	49h		;communications control
MEMADR	EQU	4Ah		;memory address control
MEMBNK	EQU	4Bh		;memory bank register
;	EQU	4Ch		;output ??? (in rom code)
;	EQU	4Dh		;output ??? (in rom code)
;	EQU	4Eh		;output ??? (in rom code)
GRAPH	EQU	50h		;graphics board base (also in rom code)
;	EQU	60h		;output ??? (in rom code)
COMSTRB	EQU	61h		;communications strobe
COMSTAT	EQU	62h		;communications status
;	EQU	63h		;output ??? (in rom code)
;	EQU	64h		;output ??? (in rom code)
;	EQU	67h		;output ??? (in rom code)
;	EQU	0FFh		;input ??? (in rom code)

;	MB8877A Floppy Controller
;	register selection - tied to STI timer D ?
;	A2	A1	A0	read	write
; --------------------------------------------------
; 10h	0	0	0	status	command
; 11h	0	0	1	track	track
; 12h	0	1	0	sector	sector
; 13h	0	1	1	data	data
; 14h	1	0	0	dflag*	select drive
;
; *dflag bit 0 set = ready, bit 5 set = head loaded
 
;floppy commands from Tandy LS-DOS FDCDVR.ASM
; and CCS 2422 cpm 2.2 bios rickcamarda.asm

; 08h	restore (seek track 0) with head load
; 10h	verify sector
; 18h	seek with head load
; 1Ch	seek w/verify and head load
; 50h	step in, head 0
; 58h	step in, head 1
; 70h	step out, head 0
; 80h	read data
; 81h	set double density and drive select 1
; 82h	read sector with side 1 compare
; 88h	basis of read sector 
; A2h	write sector with side 1 compare
; A3h	change data address mark
; C4h	read address
; F0h	write track

END