#include "LIBC.H"

/*

	C Compiler Front End.

	We allow the user to quickly compile programs.

	Matt's initial version: 09-11-83

	We assume that the user has:

		CZII.COM	- Z80 oriented C compiler.
		LZC		- Z80 oriented library.
		M80		- Microsoft assembler.

	All of these must be accessible on the current disk/user.

	We are brought up as:

	 A>cc <options> name name name ...

	Options may be:

		-l <l80 options>  These are options given to the
				  L80 linker between the program
				  name and the SOFTLIBC/S option.
		-u		  This option makes the final L80
				  option be '/U',  instead of
				  <name>/N/Y/E.
		-anything	  Unidentified options are passed
				  through to CC, always appearing
				  before the <name>.c

	The CC program either creates a $$$.SUB file, or else appends
	the necessary command lines to the existing file.
*/

# define MAXOPT	10

char *names[MAXOPT],	/* program names: each generates a compile set */
     *c_opts[MAXOPT],	/* unidentified C options */
     *ldr_opt  = NULL;	/* loader options */

/*
	Command line templates. These are processed so that an
	escape sequence, '@n', causes a replacement to occur.
	Replacements are:

			1 - insert C options.
			2 - insert current program name.
			3 - loader options
			4 - loader tail

	Replacements may be recursive. For example, the loader-tail
	is inserted on a '@4', and usually causes an '@2' replacement.

	The lines are processed by 'FIX', and 'ESCAPE'. To add new seq-
	uences, or to change existing ones, both of these modules must
	be changed. 

*/

char *ldr_tail = "@2/N/Y/E",
     cc_line[] = "CZII @1 -mo @2.mac @2.c",
    m80_line[] = "M80 =@2",
    era_macf[] = "ERA @2.MAC",
    l80_line[] = "L80 @2,@3LZC/S,@4",
    era_relf[] = "ERA @2.REL";

FILE	*subfil;	/* submit file's descriptor */


# define FAIL	1
# define HAPPY	0

main(argc,argv)
int argc; char *argv[];
{
/*
	First, we parse the input. Next, we checkout the $$$.SUB file.
	Finally, we generate options for each of the names.
*/
long lseek();
int tail, loop;
char * this;
FILE *fopen();

	if( in_parse(argc,argv) != FAIL )
	 {
		if( (subfil = fopen("$$$.SUB","a+")) == -1 )
		  {
			puts("\n\rCan't open $$$.SUB!\n\r");
			exit(1);
		  };

		/* recall just where we are */
		tail = ftell(subfil);
		
		for( loop = 0; (this=names[loop]) != NULL; loop++ )
		 /* dummy file? */
		  if( *this != '!' )
		   {
		 /* only load the first program */
		    if( loop == 0 )
		     {
		  	fix(era_relf,this,tail); tail += 128;
		  	fix(l80_line,this,tail); tail += 128;
		     };
		    fix(era_macf,this,tail); tail += 128;
		    fix(m80_line,this,tail); tail += 128;
		    fix(cc_line, this,tail); tail += 128;
		   };

		/* all happy! */
		close(subfil);
		exit(0);
	}
       else
		exit(1);	/* bad input syntax */
}

in_parse(argc,argv)
int argc; char *argv[];
{
/*
	Break the input line down into nasty little bits.
*/
int opter, namer, loop;
char *op, toupper();

	opter = namer = 0;	/* next c/loader option storage */

	for( loop=0; loop < argc ; loop++ )
	 {
		op = argv[loop];	/* get address of current opt */
		if( *op == '-' )
		 switch ( toupper(*++op) ) {
			case 'L':
				 if( loop++ == argc )
					return( syntax('L') );
				 else
					if( ldr_opt != NULL )
						return( syntax('1') );
					else
						ldr_opt = argv[loop];
				 break;
			case 'U':
				 strcpy(ldr_tail,"/N/U");
				 break;
			default:
				 if( opter == MAXOPT )
					return ( syntax('O') );
				 else
				  	c_opts[opter++]=argv[loop];
				 break;
				   } /* end switch */

		else /* not a '-' line */

		     if( *argv[loop] )		/* don't handle weirdos */
			if( namer != MAXOPT )
				names[namer++] = argv[loop];
			else
				return( syntax('N') );

	}; /* end for */


	/* they want to do anything? */
	if( namer == 0 ) return( syntax('F') );
	names[namer] = c_opts[opter] = NULL;

	return(HAPPY);

}

int syntax(err)
char err;
{
/*

	Complain about an error.
*/

	fputs(stderr,"\n\r");
	switch ( err ) {
		case 'F':
			 fputs(stderr,
	"Format: cc <-u> <-l l80-info> <- c options> <name> <name> ..");
			 break;
		case 'O':
			 fprintf(stderr,"Maximum of %d options",MAXOPT);
			 break;
		case 'N':
			 fprintf(stderr,"Maximum of %d names",MAXOPT);
			 break;
		case '1':
			 fprintf(stderr,"Only one -l option allowed.");
			 break;
		case 'L':
			 fputs(stderr,"-L format: -l  <loader opts>");
			 break;
			};

	return( FAIL );
}

static int written;	/* number of bytes written */
static char * cname;	/* current working name */

fix(line,name,rn)
char *line, *name; int rn;
{
/*
	Generate a proper submit file line given:

		line -	template line, containing '@'s to signal
			special cases, namely:

				1 - insert C options.
				2 - insert current program name.
				3 - loader options
				4 - loader tail

*/
int	count,	/* actual line length */
	loop;	/* temporary loop counter */
char ch;

	fseek(subfil,(long) rn, 0);	/* position ourselves */

	written = 0;
	cname = name;
	send('*');	/* place holder for length byte */

	/* send characters. SEND is smart enough to detect '@'s,
	   and setup escape sequences */
	while ( ch = *line++ )	send(ch);

	/* fill out the record */
	count = written-1;
	while ( written++ < 128 ) putc(0,subfil);

	/* go back and put in length byte */
	fseek(subfil,(long) rn, 0);
	putc(count,subfil);

}

escape(which)
char which;
{
/*
	Insert data corresponding to '@' sequences.
*/
register char * get;
char ch;
int loop;

	switch ( which ) {

		case '1': /*	1 - insert C options. */

		   for( loop = 0; 
			c_opts[loop] != NULL && loop<MAXOPT; 
				loop++)
			{
			 if( loop ) send(' ');
			 get = c_opts[loop];
			 while ( ch = *get++ )
				send(ch);
			};
		   break;

		 case '2': /* 2 - insert current program name. */

			get = cname;
			while( ch = *get++ )
				send(ch);
			break;

		case '3': /* 3 - loader options */

			/* insert defined subroutines */
			for( loop=1; 
			  (get=names[loop]) != NULL && loop < MAXOPT;
			    loop++)
				{
				 while ( ch = *get++ ) send(ch);
				 send(',');
				};
			if( ldr_opt != NULL )
			 {
				get = ldr_opt;
				while ( ch = *get++ )
					send(ch);
				send(',');	/* terminal comma */
			 };
			break;

		case '4': /* 4 - loader tail */

			get = ldr_tail;
			while( ch = *get++ )
				send(ch);
			};
}

send(ch)
char ch;
{
/*
	Put character into the submit file, up the character count
*/
static char at_flag = 0,	/* set true when previous was '@' */
	  was_blank = 0;	/* set true when previous was space */

	/* are we '@' processing? */
	if( was_blank && ch == ' ' ) return;
	was_blank = (ch == ' ');

	if( at_flag )
		{
			at_flag--;
			escape(ch);	/* we are definitely recursive */
		}
	else
		{
			if( ch == '@' )
				at_flag++;
			else
				{
					putc(ch,subfil);
					written++;
				};
		};
}
