// imdexp.cpp : sysgen for BigBoard II and IMD files. Takes an empty image file and reads BIOS and CP/M from
//				a com-file, creating am IMD file that will boot CP/M from a 3.5" floppy. Resulting image has an
//				interleave of 1:1, use IMDU to change to 1:5 for faster boot.
//
//				See textfile how to create cpm.image
//
//	By:			Anders Gustafsson, anders.gustafsson@pedago.fi, 2017-02-10
//

#include "stdafx.h"
#include "errno.h"
#include "math.h"

void DumpData(char *Ptr,int length);
void TrackHeader(FILE *outfile, int cyl, int head, int spt,int mode, int size);
void FileHeader(FILE *outfile);

FILE *infile;
FILE *outfile;
FILE *cpmfile;
char buffer[2000];
char temp[10];
int rc;
int i=0;
char *token;
char seps[]   = {0x1A,0};
char *next_token = NULL;

int _tmain(int argc, char* argv[])
{
	int rc;
	int track = 0;
	int sector = 0;

	if(argc <3)
	{
		printf("Usage: sysgen infile.imd cpmfile.com outfile.imd");
		return 0;
	}
	rc= fopen_s(&infile,argv[1],"rb");
	//
	if(rc != 0)
	{
		printf("Ogiltigt infilnamn %s", argv[1]);
		return 0;
	}
	rc = fopen_s(&cpmfile,argv[2],"rb");
	if(rc != 0)
	{
		printf("Ogiltigt cpmfilnamn %s", argv[2]);
		return 0;
	}
	rc = fopen_s(&outfile,argv[3],"wb");
	if(rc != 0)
	{
		printf("Ogiltigt utfilnamn %s", argv[3]);
		return 0;
	}
	int headerlen = 0x41;
	int spt = 9;
	int secsize = 512;
	////
	//// Read header
	////
	if(fread(buffer,1, headerlen,infile)!= headerlen)
	{
		printf("No header");
		return -1;
	}
	//buffer[0x2a] = 02; // 250kbps FM = SD
	fwrite(buffer,1,headerlen,outfile);	// Write header to outfile
	//
	// Pick out header text
	//
	token = strtok_s( buffer, seps , &next_token); // C4996
	printf("%s",token);
	//
	// Seek to CBIOS in cpmfile (0x800)
	fseek(cpmfile,0x800,SEEK_SET);
	//
	// Write ?? sectors of CBIOS (2000/secsize), track 0
	//
	for(i=0;i<18;i++)
	{
		rc=fread(buffer+1,1,128,cpmfile);
		buffer[0] = 1;					// Sector flag.
		rc=fwrite(buffer,1,128+1,outfile);	
		//printf("\nSector %d",i);
		//DumpData(buffer+1,128);
		fread(buffer,1, 128+1,infile);
		++sector;
		//if((sector % spt) == 0)
		//{
		//	rc=fread(buffer,1, spt+5,infile);
		//	//buffer[0] = 02; // 01=300kbps FM = SD, 02=250kbps FM
		//	rc=fwrite(buffer,1,spt+5,outfile);
		//}
	}
	////
	//// Write rest of track (9-4)
	//for(i=0;i<5;i++)
	//{
	//	memset(buffer,0,secsize+1);
	//	buffer[0] = 1;					// Sector flag.
	//	rc=fread(buffer,1, secsize+1,infile);
	//	rc=fwrite(buffer,1,secsize+1,outfile);	
	//	++sector;
	//	//
	//	if((sector % spt) == 0)
	//	{
	//		rc=fread(buffer,1, spt+5,infile);
	//		//buffer[0] = 02; // 01=300kbps FM = SD, 02=250kbps FM
	//		rc=fwrite(buffer,1,spt+5,outfile);
	//	}
	//}
	// Seek to CP/M in cpmfile (0x1100)
	rc=fseek(cpmfile,0x1100,SEEK_SET);
	//
	sector = 1;
	// Write ?? sectors CP/M 5568 / secsize
	//
	// Initial track header
		//if((sector % spt) == 0)
		{
			rc=fread(buffer,1, spt+5,infile);
			//buffer[0] = 02; // 01=300kbps FM = SD, 02=250kbps FM
			rc=fwrite(buffer,1,spt+5,outfile);
		}
	for(i=0;i<11;i++)
	{
		rc=fread(buffer+1,1,secsize,cpmfile);
		buffer[0] = 1;					// Sector flag.
		rc=fwrite(buffer,1,secsize+1,outfile);	
		//i++;
		//printf("\nSector %d",i);
		//DumpData(buffer+1,128);
		rc=fread(buffer,1, secsize+1,infile);
		
		//
		if((sector % spt) == 0)
		{
			rc=fread(buffer,1, spt+5,infile);
			//buffer[0] = 02; // 01=300kbps FM = SD, 02=250kbps FM
			rc=fwrite(buffer,1,spt+5,outfile);
		}
		++sector;
	}
	//
	//
	// Write rest
	rc=1;
	while(rc>0)
	{
		//memset(buffer,0,129);
		rc=fread(buffer,1, secsize+1,infile);
		//memset(buffer,0xe5,secsize+1); // Varfr funkar detta ej??
		buffer[0] = 1;					// Sector flag.
		rc=fwrite(buffer,1,rc,outfile);
		++sector;
		//
		if((sector % spt) == 0)
		{
			rc=fread(buffer,1, spt+5,infile);
			//buffer[0] = 02; // 01=300kbps FM = SD, 02=250kbps FM
			fwrite(buffer,1,rc,outfile);
		}
	}
	//-------------------------------------
	// Uncommnt this code and comment stuff above to write empty IMD file
	//FileHeader(outfile);
	////
	//// Write the first track as SD 18 sectors, 128 bytes, side 0
	////
	//TrackHeader(outfile, track, 0, 18, 02, 0);
	//	for(sector=1;sector<=18;sector++)
	//	{
	//		memset(buffer,0xe5,128);
	//		buffer[0] = 1; // Normal data
	//		fwrite(buffer,1,1,outfile);	
	//		//sprintf_s(buffer,"Track %03d Sector %03d",track,sector);
	//		fwrite(buffer,1,128,outfile);	
	//		i++;
	//	}
	////
	////
	//// Write the rest of the tracks as DD 9 sectors, 256 bytes
	////
	//for(track=1;track<40;track++)
	//{
	//	TrackHeader(outfile, track, 0, spt, 5, 02);

	//	for(sector=1;sector<=spt;sector++)
	//	{
	//		memset(buffer,0xe5,secsize);
	//		buffer[0] = 1; // Normal data
	//		fwrite(buffer,1,1,outfile);	
	//		//sprintf_s(buffer,"Track %03d Sector %03d",track,sector);
	//		fwrite(buffer,1,secsize,outfile);	
	//		i++;
	//	}
	//}
	////
	//// Write the first track as SD 18 sectors, 128 bytes, side 1
	////
	////TrackHeader(outfile, track, 1, 18, 02, 0);
	////	for(sector=1;sector<=18;sector++)
	////	{
	////		memset(buffer,0xe5,128);
	////		buffer[0] = 1; // Normal data
	////		fwrite(buffer,1,1,outfile);	
	////		sprintf_s(buffer,"Track %03d Sector %03d",track,sector);
	////		fwrite(buffer,1,128,outfile);	
	////		i++;
	////	}
	////
	////
	//// Write the rest of the tracks, second side as DD 9 sectors, 256 bytes
	////
	//for(track=0;track<40;track++)
	//{
	//	TrackHeader(outfile, track, 1, spt, 5, 02);

	//	for(sector=1;sector<=spt;sector++)
	//	{
	//		memset(buffer,0xe5,secsize);
	//		buffer[0] = 1; // Normal data
	//		fwrite(buffer,1,1,outfile);	
	//		//sprintf_s(buffer,"Track %03d Sector %03d",track,sector);
	//		fwrite(buffer,1,secsize,outfile);	
	//		i++;
	//	}
	//}
	//-------------------------------------
	//
	fclose(infile);
	fclose(outfile);
	fclose(cpmfile);
	return 0;
}

//
// Dump an data-area in human-readable form
//
void DumpData(char *Ptr,int length){
int i,j;
char ch;
	printf("\r\nDump %X %X\r\n",Ptr, length);
	for(j=0;j<80&&(j*16<length);j++){
		printf("\r\n");
		for(i=0;i<16 && (i+j*16<=length);i++)
			{
				ch = *(Ptr+i+j*16);
				printf(" %02X",ch&0xFF);
			}
		printf(" | ");
		for(i=0;i<16 && (i+j*16<=length);i++)
			{
				if(*(Ptr+i+j*16)>' ') printf("%c",(*(Ptr+i+j*16))&0xFF); 
				else printf(".");
			}
	}
	printf("\r\n");
}

void TrackHeader(FILE *outfile, int cyl, int head, int spt,int mode, int size)
{
	char buf[100];
	int j,p;
	p=0;
	buf[p++] = mode;
	buf[p++] = cyl;
	buf[p++] = head;
	buf[p++] = spt;
	buf[p++] = size;
	//
	// Sector map
	//
	for(j=1; j<=spt;j++)
		buf[p++] = j;
	//buf[p++] = 1;
	rc=fwrite(buf,1,p,outfile);
}

void FileHeader(FILE *outfile)
{
	fprintf(outfile, "IMD LibDsk 1.4.0: 04/02/2017 18:07:41\r\n\r\n%c",0x1a);
}