/*-----------------------------------------------------------------------------
   Definitions for SCSI per ANSI X3.130-1986

   Created	10 MAY 90 by PGJ

-----------------------------------------------------------------------------*/

/* Operation Code (CDB byte 0) bit masks */

#define GROUP_CODE_MASK 0xE0
#define GROUP0 0x00
#define GROUP1 0x20
#define GROUP7 0xE0

/* SCSI Group 0 Command Set */

#define TEST_UNIT_READY 0x00
#define REZERO_UNIT 0x01
#define REWIND 0x01
#define REQUEST_SENSE 0x03
#define FORMAT_UNIT 0x04
#define READ_BLOCK_LIMITS 0x05
#define REASSIGN_BLOCK 0x07
#define READ 0x08
#define WRITE 0x0A
#define SEEK 0x0B
#define WRITE_FILEMARKS 0x10
#define SPACE 0x11
#define INQUIRY 0x12
#define TAPE_VERIFY 0x13
#define RECOVER_BUFFERED_DATA 0x14
#define MODE_SELECT 0x15
#define RESERVE_UNIT 0x16
#define RELEASE_UNIT 0x17
#define COPY 0x18
#define ERASE 0x19
#define MODE_SENSE 0x1A
#define START_STOP_UNIT 0x1B
#define LOAD_UNLOAD 0x1B
#define RECEIVE_DIAGNOSTIC_RESULTS 0x1C
#define SEND_DIAGNOSTIC 0x1D
#define PREVENT_ALLOW_MEDIUM_REMOVAL 0x1E

/* SCSI Group 1 Command Set */

#define READ_CAPACITY 0x25
#define READ_EXTENDED 0x28
#define WRITE_EXTENDED 0x2A
#define SEEK_EXTENDED 0x2B
#define WRITE_AND_VERIFY 0x2E
#define DISK_VERIFY 0x2F
#define READ_DEFECT_DATA 0x37
#define WRITE_BUFFER 0x3B
#define READ_BUFFER 0x3C

/* SCSI Group 7 Command Set */

#define FORMAT_TRACK 0xE4
#define READ_LONG 0xE8
#define WRITE_LONG 0xEA

/* SCSI Status from Target */

#define GOOD 0x00
#define CHECK_CONDITION 0x02
#define TARGET_BUSY 0x08
#define INTERMEDIATE_STATUS 0x10
#define RESERVATION_CONFLICT 0x18

/* SCSI Messages */

#define COMMAND_COMPLETE_MSG 0x00
#define EXTENDED_MSG 0x01
#define  MODIFY_DATA_POINTER_MSG 0x00
#define  SYNCHRONOUS_DATA_TRANSFER_MSG 0x01
#define  WIDEDATATRANSFER_MSG 0x02
#define SAVE_DATA_POINTER_MSG 0x02
#define RESTORE_POINTERS_MSG 0x03
#define DISCONNECT_MSG 0x04
#define INITIATOR_DETECTED_ERROR_MSG 0x05
#define ABORT_MSG 0x06
#define MESSAGE_REJECT_MSG 0x07
#define NOP_MSG 0x08
#define MESSAGE_PARITY_ERROR_MSG 0x09
#define LINKED_COMMAND_COMPLETE_MSG 0x0A
#define BUS_DEVICE_RESET_MSG 0x0C
#define IDENTIFY_MSG 0x80	/* Note: IDENTIFY is 080-0FF, inclusive */
#define PERMIT_DISCONNECT 0x40	/* This modifies an IDENTIFY message */

/* Modifier bits for Format Unit */

#define FORMAT_DATA 0x10
#define COMPLETE_LIST 0x08
#define DEFECT_FORMAT_MASK 0x07
#define BLOCK_FORMAT 0x00
#define BYTES_FROM_INDEX_FORMAT 0x04
#define PHYSICAL_SECTOR_FORMAT 0x05

/* Modifier bits for Defect Header List */

#define FORMAT_OPTIONS_VALID 0x80
#define DISABLE_PRIMARY 0x40
#define DISABLE_CERTIFICATION 0x20
#define STOP_FORMAT 0x10

/* Modifier bits for Mode Sense/Select */

#define DBD 0x08
#define PAGE_CONTROL_MASK 0xC0
#define CURRENT_MODE_VALUES 0x00
#define CHANGEABLE_MODE_VALUES 0x40
#define DEFAULT_MODE_VALUES 0x80
#define SAVED_MODE_VALUES 0xC0
#define PAGE_CODE_MASK 0x3F
#define ERROR_RECOVERY_PAGE 0x01
#define DISCONNECT_RECONNECT_PAGE 0x02
#define DIRECT_ACCESS_DEVICE_FORMAT_PAGE 0x03
#define DISK_DRIVE_GEOMETRY_PAGE 0x04
#define DEVICE_PAGE 0x10
#define ALL_PAGES 0x3F
#define SAVE_MODE_PARAMETERS 0x01

/* Page 1 Error Recovery parameter masks */

#define AUTO_WRITE_REALLOCATION 0x80
#define AUTO_READ_REALLOCATION 0x40
#define TRANSFER_BLOCK 0x20
#define READ_CONTINUOUS 0x10
#define ENABLE_EARLY_CORRECTION 0x08
#define POST_ERROR 0x04
#define DISABLE_TRANSFER_ON_ERROR 0x02
#define DISABLE_CORRECTION 0x01

/* Modifier bits for defect data */

#define PRIMARY_LIST 0x10
#define GROWN_LIST 0x08

/* Extended sense keys */

#define SENSE_KEY_MASK 0x0F
#define NO_SENSE 0x00
#define RECOVERED_ERROR 0x01
#define NOT_READY 0x02
#define MEDIUM_ERROR 0x03
#define HARDWARE_ERROR 0x04
#define ILLEGAL_REQUEST 0x05
#define UNIT_ATTENTION 0x06
#define DATA_PROTECT 0x07
#define BLANK_CHECK 0x08
#define ABORTED_COMMAND 0x0B
#define VOLUME_OVERFLOW 0x0D
#define MISCOMPARE 0x0E

/* Modifier bits for Extended Sense */

#define INFO_VALID 0x80
#define FILE_MARK 0x80
#define END_OF_MEDIUM 0x40
#define ILI 0x20
#define FIELD_POINTER_VALID 0x80
#define CDB_POINTER 0x40
#define BIT_POINTER_VALID 0x08
#define BIT_POINTER_MASK 0x07

/* Modifier bits for Inquiry response data */

#define DIRECT_ACCESS_DEVICE 0x00
#define SEQUENTIAL_ACCESS_DEVICE 0x01
#define PROCESSOR_DEVICE 0x03
#define NON_EXISTENT_LUN 0x7F
#define REMOVABLE_MEDIUM 0x80
#define ISO_VERSION_MASK 0xC0
#define ECMA_VERSION_MASK 0x38
#define ANSI_VERSION_MASK 0x07

/* Modifier bit for Start/Stop Unit */

#define IMMEDIATE_STATUS 0x01

/* Modifier bits for Sequential Access device commands */

#define EOT 0x04		/* Leave tape at EOT */
#define FIXED 0x01		/* Fixed-length block sizes */
#define IMMED 0x01		/* Return GOOD immediately */
#define IMMED_ERASE 0x02	/* Same, but it moves around... */
#define IMMED_VERIFY 0x04
#define LOAD 0x01		/* Load (or leave loaded) medium */
#define LONG 0x01		/* Erase medium, not just a gap */
#define RE_TEN 0x02		/* Retension */
#define RESERVED 0x01		/* LUN and 3rd party reservations */
#define SILI 0x02		/* Suppress Illegal Length Indicator */
#define SPACE_BLOCKS 0x00	/* Parameters for the SPACE command */
#define SPACE_EOD 0x03
#define SPACE_FILEMARKS 0x01
#define SPACE_SEQ_FILEMARKS 0x02
#define SPACE_SEQ_SETMARKS 0x05
#define SPACE_SETMARKS 0x04
#define WSMK 0x02		/* Write setmarks, not filemarks */

#define BUFFER_DESCRIPTOR 0x03

typedef struct {
   byte reserved;
   byte max_block_length[3];
   word min_block_length;
} block_limits_type;

typedef struct {
   byte reserved;
   byte buffer_capacity[3];
} device_buffer_descriptor_type;

typedef struct {
   byte reserved;
   byte format_options;
   word defect_list_length;		/* Note: MSB...LSB reversal */
} defect_list_header_type;

typedef struct {
   word cylinder;			/* Note: MSB...LSB reversals */
   byte head;
   dword bytes_from_index;		/* Note: MSB...LSB reversals */
} bytes_from_index_defect_type;

typedef struct {
   byte error_code;
   byte segment_number;
   byte sense_key;
   byte information[4];
   byte sense_length;
   dword reserved1;
   byte sense_code;
   byte reserved2;
   byte field_replaceable;
   byte field_ptr_flags;
   word field_ptr;
} ext_sense_type;

typedef struct {
   byte peripheral_device_type;
   byte device_type_modifier;
   byte device_versions;
   byte response_data_format;
   byte additional_length;
   byte reserved[2];
   byte capability_flags;
   byte vendor_id[8];
   byte product_id[16];
   byte revision_level[4];
} inquiry_data_type;

typedef struct {
   byte mode_data_length;
   byte medium_type;
   byte device_specific;
   byte block_descriptor_length;
} mode_header6_type;

typedef struct {
   word mode_data_length;
   byte medium_type;
   byte device_specific;
   word reserved;
   word block_descriptor_length;
} mode_header10_type;

#define WP 0x80
#define BUFFERED_MODE_MASK 0x70
#define UNBUFFERED_MODE 0x00
#define BUFFERED_MODE 0x10
#define SPEED_MASK 0x0F

typedef struct {
   byte density_code;
   byte total_blocks[3];
   byte reserved;
   byte block_length[3];
} block_descriptor_type;

#define NRZI_800 0x01		/* 1/2" reel-to-reel 800bpi NRZI */
#define PE_1600 0x02		/* 1/2" reel-to-reel 1600bpi PE */
#define GCR_6250 0x03		/* 1/2" reel-to-reel 6250bpi GCR */
#define QIC_11 0x04		/* Quarter-inch cartridge 8000bpi GCR */
#define QIC_24 0x05		/* Quarter-inch cartridge 8000bpi GCR */
#define PE_3200 0x06		/* 1/2" reel-to-reel 3200bpi PE */
#define HI_TC1 0x0C		/* 1/2" cartridge 12690bpi GCR */
#define HI_TC2 0x0D		/* 1/2" cartridge 25380bpi GCR */
#define QIC_120 0x0F		/* Quarter-inch cartridge 10000bpi GCR */
#define QIC_150 0x10		/* Quarter-inch cartridge 10000bpi GCR */
#define QIC_320 0x11		/* Quarter-inch cartridge 16000bpi GCR */
#define QIC_1350 0x12		/* Quarter-inch cartridge 51667bpi RLL */
#define DDS 0x13		/* Digital Data Storage 61000bpi DDS */

typedef struct {
   byte page_code;
   byte page_length;
   byte page_data[1];
} mode_page_type;

typedef struct {
   byte page_code;
   byte page_length;
   byte error_flags;
   byte read_retry_limit;
   byte correction_span;
   byte head_offset_count;
   byte data_strobe_offset_count;
   byte reserved1;
   byte write_retry_limit;
   byte reserved2;
   word recovery_time_limit;
} error_recovery_page_type;

#define TB 0x20
#define EER 0x08
#define PER 0x04
#define DTE 0x02
#define DCR 0x01

typedef struct {			/* Mode Page 2 */
   byte page_code;
   byte page_length;
   byte buffer_full_ratio;
   byte buffer_empty_ratio;
   word bus_inactivity_limit;
   word disconnect_time_limit;
   word connect_time_limit;
   word maximum_burst_size;
   byte connect_flags;
   byte reserved[3];
} connect_page_type;

#define DTDC 0x03

typedef struct {
   byte page_code;
   byte page_length;
   word tracks_per_zone;
   word alternate_sectors_per_zone;
   word alternate_tracks_per_zone;
   word alternate_tracks_per_volume;
   word sectors_per_track;
   word bytes_per_sector;
   word sector_interleave;
   word track_skew;
   word cylinder_skew;
   byte formatparameters;
   byte reserved[3];
} format_page_type;

typedef struct {
   byte page_code;
   byte page_length;
   word maximum_cylinders;
   byte maximum_heads;
   word write_precompensation_cyl;
   word reduced_write_current_cyl;
   word step_rate;
   word landing_zone_cylinder;
   byte reserved[3];
} geometry_page_type;

typedef struct {
   byte page_code;
   byte page_length;
   byte active_format;
   byte active_partition;
   byte write_buffer_full_ratio;
   byte read_buffer_empty_ratio;
   word write_delay;
   byte device_flags;
   byte gap_size;
   byte device_flags2;
   byte eom_buffer_size[3];
   byte data_compression;
   byte reserved;
} device_page_type;

#define DBR 0x80
#define BIS 0x40
#define RSmk 0x20
#define AVC 0x10
#define SOCF 0x0C
#define RBO 0x02
#define REW 0x01
#define EOD_Defined 0xD0
#define EEG 0x10
#define SEW 0x08

typedef struct {
   byte rglba[4];
   byte rgblocklength[4];
} capacity_data_type;
