/*
	Copyright 1987-1990 XVT Software Inc. All rights reserved.
	May be used freely by licensed and registered users of XVT.
	May be distributed in source form only when embedded in an
	XVT user's application.
*/

#include "xvt.h"					/* standard XVT header */
#if (XVTCC == MWCCC) && (XVTOS == CTOOS)
pragma Calling_convention(CTOS_CALLING_CONVENTIONS);
#endif
#include "xvtmenu.h"				/* standard XVT menu tags */

#ifdef PROTO
STATICFCN void do_menu(MENU_TAG, BOOLEAN, BOOLEAN);
#else
STATICFCN void do_menu();
#endif

#define M_RQ_NUMBER	MAKE_MENU_TAG(MENU3, 1)	/* tags for our Requests menu */
#define M_RQ_DOIT	MAKE_MENU_TAG(MENU3, 2)
#define M_RQ_NUMRESP	MAKE_MENU_TAG(MENU3, 3)
#define M_RQ_BLOCK	MAKE_MENU_TAG(MENU3, 4)
#define M_RQ_DLOG		MAKE_MENU_TAG(MENU3, 5)

#define Syslit
#include <ctostypes.h>

typedef struct {
	Byte sCntInfo;
	Byte RtCode;
	Byte nReqPbCb;
	Byte nRespPbCb;
	Word userNum;
	Word exchResp;
	Word ercRet;
	Word rqCode;
	Word rgbReserve[3];
	void *pDateTimeRet;
	Word sDateTimeRet;
	} TimeRqType;


/*************** GLobals *************/
unsigned cRqs = 1;  /* count of requests to make at a time. */
unsigned cResps = 0; /* count of resps received for most recent set of rqs */
unsigned fBlockOnDlog = 0;
long		DateTime;
unsigned fDlogUp = FALSE;
TimeRqType	Rq = { 6, 0, 0, 1, 0, 0, 0, 14, {0, 0, 0}, NULL, 4 };
TimeRqType   *pRq = &Rq;

#define MY_MSG 1010
/* stack of active dialogs */
WINDOW DlgStack[25];

/* Required application setup structure. */
APPL_SETUP appl_setup = {
	0,								/* menu bar resource ID (use default) */
	0,								/* about box resource ID (use default) */
	"Requests",						/* application's name */
	W_NONE,							/* type of initial window */
	FALSE,							/* size box on initial window? */
	FALSE,							/* vert. scroll bar on initial window? */
	FALSE,							/* horz. scroll bar on initial window? */
	FALSE,							/* close box on initial window? */
	FALSE,							/* want std. font menu? (includes sizes) */
	FALSE							/* want std. style menu? */
};

/* function to gen requests in a dialog box */
BOOLEAN XVTENTRY cbGenReqs(int cid, CONTROL_INFO *cip) {
int i;
static char buf[100] = "0";

	switch(cid) {
		case DLG_INIT:
			DlgStack[fDlogUp] = cip->win;
			fDlogUp++;
			cResps = 0;
			sprintf(buf, "%d", cResps);
			set_item_text(7, buf);
			for(i = 0 ; i < cRqs; i++) {
				CTOS_Request((char *) pRq);
				}
			break;
		case DLG_OK:
			cResps = 0;
			for(i = 0 ; i < cRqs; i++) {
				CTOS_Request((char *) pRq);
				}
			break;
		case 4:
			sprintf(buf, "%d", cResps);
			set_item_text(7, buf);
			break;
		case 8:
			new_dialog(DLG_MODELESS, 203, (CALLBACK) cbGenReqs, 0L);
			break;
		case DLG_CHAR:
			break;
		case DLG_CANCEL:
		case DLG_CLOSE:
			fDlogUp--;
			DlgStack[fDlogUp] = NULL_WIN;
			return (FALSE);
		case MY_MSG:
			lbox_add(9, -1, "List_Call");
			break;
	}
	return(TRUE);
}


/* Function to handle all menu commands. */
#ifdef FPROTO
static void do_menu(MENU_TAG cmd, BOOLEAN shift, BOOLEAN control)
#else
static void do_menu(cmd, shift, control)
MENU_TAG cmd;						/* menu tag */
BOOLEAN shift;						/* was shift key down? */
BOOLEAN control;					/* was control key down? */
#endif
{
	FILE_SPEC fs;
	int i;
	static char s[256];

	NOREF(shift);
	NOREF(control);
	switch (cmd) {
	case M_FILE_QUIT:
		terminate();
		break;
	case M_RQ_NUMBER:
		if (get_str_response("Number of Requests to generate?", s, 
							sizeof(s)) != NULL) {
			cRqs = atoi(s);
			if(cRqs > 20) {
				note("Can't make more than 20 simultaneous requests.");
				cRqs = 20;
				}
			}
		break;
	case M_RQ_DOIT:
		cResps = 0;
		for(i = 0 ; i < cRqs; i++) {
			CTOS_Request((char *) pRq);
			}
#ifdef DEBUG
		dbg("Sent %d Requests.", cRqs);
#endif
		if(fBlockOnDlog)
			note("Sent out the requests.  Blocking with this dialog box.");
		break;
	case M_RQ_NUMRESP:
		note("Number of responses received for last batch of requests: %d.", 
				cResps);
		break;
	case M_RQ_BLOCK:
		fBlockOnDlog = !(fBlockOnDlog);
		menu_check(M_RQ_BLOCK, fBlockOnDlog == 1);
		break;
	case M_RQ_DLOG:
		new_dialog(DLG_MODELESS, 203, (CALLBACK) cbGenReqs, 0L);
		break;
	}
}

/*
	Application initialization.  Set font menu and record the existence of
	XVT's initial window, created from the appl_setup structure (std_win).
*/
BOOLEAN XVTENTRY appl_init BTCENTRY(void)
{
	Rq.pDateTimeRet = (void *) &DateTime;
	return(TRUE);
}

void  do_char_evt(EVENT_PTR ep) {
	char buffer[100] = "";
	SLIST mySList;
	unsigned cNodes=0;
	
	switch(toupper(ep->v.chr.ch)) {
		case 'A':
			ask("Yup", "Nope", "Chuck It", "Will you answer my question?");
			break;
		
		case 'E':
			error("No E-pressing allowed!");
			break;
		
		case 'G':
			get_str_response("Tell me something!", &(buffer[0]), sizeof(buffer));
			break;
		
		case 'N':
			note("You should listen to your mother.  She loves you.");
			break;
		
		default:
			break;
		}
}

/* Main application entry point. */
#ifdef PROTO
void XVTENTRY main_event BTCENTRY(WINDOW win, EVENT_PTR ep)
#else
void XVTENTRY main_event BTCENTRY(win, ep)
WINDOW win;							/* window */
EVENT_PTR ep;							/* event */
#endif
{

	NOREF(win);
	switch (ep->type) {
	case E_COMMAND:
		do_menu(ep->v.cmd.tag, ep->v.cmd.shift, ep->v.cmd.control);
		break;
	case E_CLOSE:
		terminate();
		break;
	case E_CHAR:
		do_char_evt(ep);
		break;
	case E_USER:
		if( ((TimeRqType *) (ep->v.user.info))->ercRet == 0)
			cResps++;
#ifdef DEBUG
		dbg("Got a User Event.");
#endif
		if(fDlogUp)
/*			note("Got a response!"); */
			dlg_callback(DlgStack[fDlogUp - 1], MY_MSG);
		break;
	case E_QUIT:
		if (ep->v.query)
			quit_OK();
		else
			terminate();
	}
}

/* Application cleanup.  Nothing to do. */
void XVTENTRY appl_cleanup BTCENTRY(void)
{
}
