/*
	Copyright 1987-1990 XVT Software Inc. All rights reserved.
	May be used freely by licensed and registered users of XVT.
	May be distributed in source form only when embedded in an
	XVT user's application.
*/

#include "xvt.h"
#include "xvtmenu.h"

#ifdef PROTO
STATICFCN int find_test_index(int);
STATICFCN int find_oper_index(int);
STATICFCN int find_test_index(int);
STATICFCN WINDOW find_win(int);
STATICFCN void flip_checkbox(int);
STATICFCN void flip_radio(int);
STATICFCN void create_controls(void);
STATICFCN void show_scroll_values(void);
STATICFCN void set_control_text(void);
STATICFCN void get_control_text(void);
STATICFCN int find_oper_index(int id);
#else
STATICFCN int find_test_index();
STATICFCN int find_oper_index();
STATICFCN int find_test_index();
STATICFCN WINDOW find_win();
STATICFCN void flip_checkbox();
STATICFCN void flip_radio();
STATICFCN void create_controls();
STATICFCN void show_scroll_values();
STATICFCN void set_control_text();
STATICFCN void get_control_text();
STATICFCN int find_oper_index();
#endif

/* 
   character based system needs tighter coordinates to fit on screen,
   but these coordinates look very squished on most graphical screens
*/
#if XVTWS == WMWS /* character based positions */
#define GAP1			8
#define GAP2			16
#define CTL1_TOP1		16
#define CTL1_TOP2		24
#define CTL1_LFT1		16
#define CTL1_LFT2		24
#define CTL1_RGT1		80
#define CTL1_RGT2		300
#define CTL1_BOT1		(CTL1_TOP1 + GAP1)
#define CTL1_BOT2		(CTL1_TOP2 + GAP2 + 8)
#define CTL2_TOP1		32
#define CTL2_TOP2		48
#define CTL2_BOT1		(CTL2_TOP1 + GAP1)
#define CTL2_BOT2		(CTL2_TOP2 + GAP2)
#define CTL2_LFT1		16
#define CTL2_LFT2		32
#define CTL2_RGT1		120
#define CTL2_RGT2		160
#define CTL3_TOP1		(CTL2_BOT1)
#define CTL3_TOP2		(CTL2_BOT2)
#define CTL3_BOT1		(CTL3_TOP1 + GAP1)
#define CTL3_BOT2		(CTL3_TOP2 + GAP2)
#define CTL4_TOP1		(CTL3_BOT1)
#define CTL4_TOP2		(CTL3_BOT2)
#define CTL4_BOT1		(CTL4_TOP1 + GAP1)
#define CTL4_BOT2		(CTL4_TOP2 + GAP2)
#define CTL5_TOP1		32
#define CTL5_TOP2		48
#define CTL5_BOT1		(CTL5_TOP1 + GAP1)
#define CTL5_BOT2		(CTL5_TOP2 + GAP2)
#define CTL5_LFT1		168
#define CTL5_LFT2		198
#define CTL5_RGT1		280
#define CTL5_RGT2		320
#define CTL6_TOP1		CTL5_BOT1
#define CTL6_TOP2		CTL5_BOT2
#define CTL6_BOT1		(CTL6_TOP1 + GAP1)
#define CTL6_BOT2		(CTL6_TOP2 + GAP2)
#define CTL7_TOP1		16
#define CTL7_TOP2		24
#define CTL7_BOT1		96
#define CTL7_BOT2		112
#define CTL7_LFT1		400
#define CTL7_LFT2		440
#define CTL7_RGT1		416
#define CTL7_RGT2		464
#define CTL8_TOP1		80
#define CTL8_TOP2		96
#define CTL8_BOT1		96
#define CTL8_BOT2		112
#define CTL8_LFT1		80
#define CTL8_LFT2		16
#define CTL8_RGT1		176
#define CTL8_RGT2		240
#define OPER_Y			120
#define OPER_X			40
#define OPER_W			80
#define OPER_H			24
#define OPER_HGAP		(OPER_W + 8)
#define OPER_VGAP		(OPER_H + 8)
#define RLEFT			0
#define RTOP			0
#define RRIGHT			560
#define RBOTTOM			120
#define VSCROLL_LABEL_X		350
#define VSCROLL_LABEL_Y		50
#define HSCROLL_LABEL_X		320
#define HSCROLL_LABEL_Y		104
#else /* not WMWS (not character based) */
#define GAP1			20
#define GAP2			30
#define CTL1_TOP1		14
#define CTL1_TOP2		34
#define CTL1_LFT1		10
#define CTL1_LFT2		30
#define CTL1_RGT1		80
#define CTL1_RGT2		300
#define CTL1_BOT1		(CTL1_TOP1 + GAP1)
#define CTL1_BOT2		(CTL1_TOP2 + GAP2)
#define CTL2_TOP1		50
#define CTL2_TOP2		70
#define CTL2_BOT1		(CTL2_TOP1 + GAP1)
#define CTL2_BOT2		(CTL2_TOP2 + GAP2)
#define CTL2_LFT1		10
#define CTL2_LFT2		30
#define CTL2_RGT1		150
#define CTL2_RGT2		170
#define CTL3_TOP1		(CTL2_BOT1)
#define CTL3_TOP2		(CTL2_BOT2)
#define CTL3_BOT1		(CTL3_TOP1 + GAP1)
#define CTL3_BOT2		(CTL3_TOP2 + GAP2)
#define CTL4_TOP1		(CTL3_BOT1)
#define CTL4_TOP2		(CTL3_BOT2)
#define CTL4_BOT1		(CTL4_TOP1 + GAP1)
#define CTL4_BOT2		(CTL4_TOP2 + GAP2)
#define CTL5_TOP1		50
#define CTL5_TOP2		70
#define CTL5_BOT1		(CTL5_TOP1 + GAP1)
#define CTL5_BOT2		(CTL5_TOP2 + GAP2)
#define CTL5_LFT1		160
#define CTL5_LFT2		180
#define CTL5_RGT1		290
#define CTL5_RGT2		310
#define CTL6_TOP1		CTL5_BOT1
#define CTL6_TOP2		CTL5_BOT2
#define CTL6_BOT1		(CTL6_TOP1 + GAP1)
#define CTL6_BOT2		(CTL6_TOP2 + GAP2)
#define CTL7_TOP1		14
#define CTL7_TOP2		24
#define CTL7_BOT1		104
#define CTL7_BOT2		200
#define CTL7_LFT1		325
#define CTL7_LFT2		400
#define CTL7_RGT1		341
#define CTL7_RGT2		440
#define CTL8_TOP1		150
#define CTL8_TOP2		175
#define CTL8_BOT1		166
#define CTL8_BOT2		200
#define CTL8_LFT1		250
#define CTL8_LFT2		10
#define CTL8_RGT1		350
#define CTL8_RGT2		300
#define OPER_Y			222
#define OPER_X			40
#define OPER_W			75
#define OPER_H			20
#define OPER_HGAP		(OPER_W + 10)
#define OPER_VGAP		(OPER_H + 10)
#define RLEFT			4
#define RTOP			4
#define RRIGHT			500
#define RBOTTOM			216
#define VSCROLL_LABEL_X		350
#define VSCROLL_LABEL_Y		50
#define HSCROLL_LABEL_X		310
#define HSCROLL_LABEL_Y		190
#endif /* WMWS character vs graphical positions */

#define TEST_BUTTON		101
#define TEST_RADIO1		102
#define TEST_RADIO2		103
#define TEST_RADIO3		104
#define TEST_CHECK1		105
#define TEST_CHECK2		106
#define TEST_VSCROLL	107
#define TEST_HSCROLL	108

#define OPER_CREATE		151
#define OPER_DESTROY	152
#define OPER_SHOW		153
#define OPER_HIDE		154
#define OPER_MOVE		155
#define OPER_RESTORE	156
#define OPER_GETTEXT	157
#define OPER_SETTEXT	158
#define OPER_ENABLE		159
#define OPER_DISABLE	160

#define SCROLL_MIN		0
#define SCROLL_MAX		100
#define SCROLL_LINE		2
#define SCROLL_PAGE		25

static int vscroll_value = SCROLL_MIN;
static int hscroll_value = SCROLL_MIN;

static struct {
	WIN_TYPE wtype;
	RCT rct1;
	RCT rct2;
	int id;
	char *title;
	BOOLEAN state;
	WINDOW win;
} test_ctls[] = {
	{WC_PUSHBUTTON, {CTL1_TOP1, CTL1_LFT1, CTL1_BOT1, CTL1_RGT1}, {CTL1_TOP2, CTL1_LFT2, CTL1_BOT2, CTL1_RGT2}, TEST_BUTTON, "Push Me"},
	{WC_RADIOBUTTON, {CTL2_TOP1, CTL2_LFT1, CTL2_BOT1, CTL2_RGT1}, {CTL2_TOP2, CTL2_LFT2, CTL2_BOT2, CTL2_RGT2}, TEST_RADIO1, "Click Me (1)", TRUE},
	{WC_RADIOBUTTON, {CTL3_TOP1, CTL2_LFT1, CTL3_BOT1, CTL2_RGT1}, {CTL3_TOP2, CTL2_LFT2, CTL3_BOT2, CTL2_RGT2}, TEST_RADIO2, "Click Me (2)"},
	{WC_RADIOBUTTON, {CTL4_TOP1, CTL2_LFT1, CTL4_BOT1, CTL2_RGT1}, {CTL4_TOP2, CTL2_LFT2, CTL4_BOT2, CTL2_RGT2}, TEST_RADIO3, "Click Me (3)"},
	{WC_CHECKBOX, {CTL5_TOP1, CTL5_LFT1, CTL5_BOT1, CTL5_RGT1}, {CTL5_TOP2, CTL5_LFT2, CTL5_BOT2, CTL5_RGT2}, TEST_CHECK1, "Check Me (1)"},
	{WC_CHECKBOX, {CTL6_TOP1, CTL5_LFT1, CTL6_BOT1, CTL5_RGT1}, {CTL6_TOP2, CTL5_LFT2, CTL6_BOT2, CTL5_RGT2}, TEST_CHECK2, "Check Me (2)"},
	{WC_VSCROLL, {CTL7_TOP1, CTL7_LFT1, CTL7_BOT1, CTL7_RGT1}, {CTL7_TOP2, CTL7_LFT2, CTL7_BOT2, CTL7_RGT2}, TEST_VSCROLL, ""},
	{WC_HSCROLL, {CTL8_TOP1, CTL8_LFT1, CTL8_BOT1, CTL8_RGT1}, {CTL8_TOP2, CTL8_LFT2, CTL8_BOT2, CTL8_RGT2}, TEST_HSCROLL, ""},
	{0}
}, oper_ctls[] = {
	{WC_PUSHBUTTON, {OPER_Y, OPER_X, OPER_Y + OPER_H, OPER_X + OPER_W}, {0,0,0,0}, OPER_CREATE, "Create"},
	{WC_PUSHBUTTON, {OPER_Y + OPER_VGAP, OPER_X, OPER_Y + OPER_VGAP + OPER_H, OPER_X + OPER_W}, {0,0,0,0}, OPER_DESTROY, "Destroy"},
	{WC_PUSHBUTTON, {OPER_Y, OPER_X + OPER_HGAP, OPER_Y + OPER_H, OPER_X + OPER_HGAP + OPER_W}, {0,0,0,0}, OPER_SHOW, "Show"},
	{WC_PUSHBUTTON, {OPER_Y + OPER_VGAP, OPER_X + OPER_HGAP, OPER_Y + OPER_VGAP + OPER_H, OPER_X + OPER_HGAP + OPER_W}, {0,0,0,0}, OPER_HIDE, "Hide"},
	{WC_PUSHBUTTON, {OPER_Y, OPER_X + 2 * OPER_HGAP, OPER_Y + OPER_H, OPER_X + 2 * OPER_HGAP + OPER_W}, {0,0,0,0}, OPER_MOVE, "Move"},
	{WC_PUSHBUTTON, {OPER_Y + OPER_VGAP, OPER_X + 2 * OPER_HGAP, OPER_Y + OPER_VGAP + OPER_H, OPER_X + 2 * OPER_HGAP + OPER_W}, {0,0,0,0}, OPER_RESTORE, "Restore"},
	{WC_PUSHBUTTON, {OPER_Y, OPER_X + 3 * OPER_HGAP, OPER_Y + OPER_H, OPER_X + 3 * OPER_HGAP + OPER_W}, {0,0,0,0}, OPER_GETTEXT, "Get Text"},
	{WC_PUSHBUTTON, {OPER_Y + OPER_VGAP, OPER_X + 3 * OPER_HGAP, OPER_Y + OPER_VGAP + OPER_H, OPER_X + 3 * OPER_HGAP + OPER_W}, {0,0,0,0}, OPER_SETTEXT, "Set Text"},
	{WC_PUSHBUTTON, {OPER_Y, OPER_X + 4 * OPER_HGAP, OPER_Y + OPER_H, OPER_X + 4 * OPER_HGAP + OPER_W}, {0,0,0,0}, OPER_ENABLE, "Enable"},
	{WC_PUSHBUTTON, {OPER_Y + OPER_VGAP, OPER_X + 4 * OPER_HGAP, OPER_Y + OPER_VGAP + OPER_H, OPER_X + 4 * OPER_HGAP + OPER_W}, {0,0,0,0}, OPER_DISABLE, "Disable"},
	{0}
};

APPL_SETUP appl_setup = {
	0,								/* menu bar resource ID (use default) */
	0,								/* about box resource ID (use default) */
	"control",						/* application's name */
	W_DOC,							/* type of initial window */
	FALSE,							/* size box on initial window? */
	FALSE,							/* vert. scroll bar on initial window? */
	FALSE,							/* horz. scroll bar on initial window? */
	FALSE,							/* close box on initial window? */
	FALSE,							/* want std. font menu? (includes sizes) */
	FALSE							/* want std. style menu? */
};
#ifdef FPROTO
static int find_oper_index(int id)
#else
static int find_oper_index(id)
int id;
#endif
{
	int i;

	for (i = 0; oper_ctls[i].wtype != 0; i++)
		if (oper_ctls[i].id == id)
			return(i);
	return(-1);
}
#ifdef FPROTO
static int find_test_index(int id)
#else
static int find_test_index(id)
int id;
#endif
{
	int i;

	for (i = 0; test_ctls[i].wtype != 0; i++)
		if (test_ctls[i].id == id)
			return(i);
	return(-1);
}
#ifdef FPROTO
static WINDOW find_win(int id)
#else
static WINDOW find_win(id)
int id;
#endif
{
	int index;

	if ((index = find_oper_index(id)) != -1)
		return(oper_ctls[index].win);
	if ((index = find_test_index(id)) != -1)
		return(test_ctls[index].win);
	fatal("Can't find window");
}
#ifdef FPROTO
static void flip_checkbox(int id)
#else
static void flip_checkbox(id)
int id;
#endif
{
	int i;

	i = find_test_index(id);
	if (i == -1)
		fatal("flip_checkbox failed");
	test_ctls[i].state = !test_ctls[i].state;
	win_check_box(test_ctls[i].win, test_ctls[i].state);
}
#ifdef FPROTO
static void flip_radio(int id)
#else
static void flip_radio(id)
int id;
#endif
{
	WINDOW ctls[4];

	ctls[0] = find_win(TEST_RADIO1);
	ctls[1] = find_win(TEST_RADIO2);
	ctls[2] = find_win(TEST_RADIO3);
	win_check_radio_button(find_win(id), ctls, 3);
}
#ifdef FPROTO
static void create_controls(void)
#else
static void create_controls()
#endif
{
	int i;

	for (i = 0; test_ctls[i].wtype != 0; i++)
		if ((test_ctls[i].win = new_control(&test_ctls[i].rct1, test_ctls[i].title,
		  test_ctls[i].wtype, std_win, TRUE, test_ctls[i].id, NULL)) == NULL)
			error("new_control failed");
	set_scroll_range(find_win(TEST_HSCROLL), HVSCROLL, 0, 100);
	set_scroll_range(find_win(TEST_VSCROLL), HVSCROLL, 0, 100);
	flip_radio(TEST_RADIO1);
	enable_window(find_win(OPER_CREATE), FALSE);
	enable_window(find_win(OPER_DESTROY), TRUE);
	enable_window(find_win(OPER_SHOW), FALSE);
	enable_window(find_win(OPER_HIDE), TRUE);
	enable_window(find_win(OPER_MOVE), TRUE);
	enable_window(find_win(OPER_RESTORE), FALSE);
	enable_window(find_win(OPER_GETTEXT), TRUE);
	enable_window(find_win(OPER_SETTEXT), TRUE);
	enable_window(find_win(OPER_ENABLE), FALSE);
	enable_window(find_win(OPER_DISABLE), TRUE);
	flip_checkbox(TEST_CHECK1);
	flip_checkbox(TEST_CHECK1);
	flip_checkbox(TEST_CHECK2);
}

BOOLEAN XVTENTRY appl_init()
{
	int i;

	for (i = 0; oper_ctls[i].wtype != 0; i++)
		if ((oper_ctls[i].win = new_control(&oper_ctls[i].rct1, oper_ctls[i].title,
		  oper_ctls[i].wtype, std_win, TRUE, oper_ctls[i].id, NULL)) == NULL)
			error("new_control failed");
	create_controls();
	return(TRUE);
}
#ifdef FPROTO
static void show_scroll_values(void)
#else
static void show_scroll_values()
#endif
{
	char buf[256];
	WINDOW win;

	set_cur_window(std_win);
	if ((win = find_win(TEST_HSCROLL)) != NULL)
		set_scroll_pos(win, HVSCROLL, hscroll_value);
	if ((win = find_win(TEST_VSCROLL)) != NULL)
		set_scroll_pos(win, HVSCROLL, vscroll_value);
	sprintf(buf, "%d  ", vscroll_value);
	draw_text(VSCROLL_LABEL_X, VSCROLL_LABEL_Y, buf, -1);
	sprintf(buf, "%d  ", hscroll_value);
	draw_text(HSCROLL_LABEL_X, HSCROLL_LABEL_Y, buf, -1);
}

#ifdef FPROTO
static void set_control_text(void)
#else
static void set_control_text()
#endif
{
	int i, j;
	char buf[256];

	get_title(find_win(TEST_BUTTON), buf, sizeof(buf));
	if (strcmp(buf, "Push Me") == 0)
		for (i = 0; test_ctls[i].wtype != 0; i++) {
			get_title(test_ctls[i].win, buf, sizeof(buf));
			for (j = 0; buf[j] != '\0'; j++)
				buf[j] = toupper(buf[j]);
			set_title(test_ctls[i].win, buf);
		}
	else
		for (i = 0; test_ctls[i].wtype != 0; i++)
			set_title(test_ctls[i].win, test_ctls[i].title);
}

#ifdef FPROTO
static void get_control_text(void)
#else
static void get_control_text()
#endif
{
	int i;
	char buf[256], collect[256];

	collect[0] = '\0';
	for (i = 0; test_ctls[i].wtype != 0; i++) {
		get_title(test_ctls[i].win, buf, sizeof(buf));
		if (buf[0] != '\0') {
			if (i != 0)
				strcat(collect, "...");
			strcat(collect, buf);
		}
	}
	note(collect);
}

void XVTENTRY main_event(win, ep)
WINDOW win;
EVENT *ep;
{
	RCT rct;
	DRAW_CTOOLS tools;
	int i, *valp = NULL;

	switch (ep->type) {
	case E_UPDATE:
		get_normal_ctools(&tools);
		get_client_rect(win, &rct);
		tools.brush.color = COLOR_WHITE; 
		tools.brush.pat = PAT_SOLID;
		tools.pen.pat = PAT_HOLLOW;
		set_draw_ctools(&tools);
		draw_rect(&rct);
		set_rect(&rct, RLEFT, RTOP, RRIGHT, RBOTTOM);
		tools.pen.width = 2;
		tools.pen.color = COLOR_BLUE;
		tools.pen.pat = PAT_SOLID;
		tools.brush.pat = PAT_HOLLOW;
		tools.opaque_text = TRUE;
		tools.fore_color = COLOR_RED;
		tools.back_color = COLOR_WHITE;
		set_draw_ctools(&tools);
		draw_rect(&rct);
		show_scroll_values();
		break;
	case E_CONTROL:
		switch (ep->v.ctl.id) {
		case OPER_CREATE:
			create_controls();
			break;
		case OPER_DESTROY:
			for (i = 0; test_ctls[i].wtype != 0; i++)
				if (test_ctls[i].win != NULL) {
					close_window(test_ctls[i].win);
					test_ctls[i].win = NULL;
				}
			enable_window(find_win(OPER_CREATE), TRUE);
			enable_window(find_win(OPER_DESTROY), FALSE);
			enable_window(find_win(OPER_SHOW), FALSE);
			enable_window(find_win(OPER_HIDE), FALSE);
			enable_window(find_win(OPER_MOVE), FALSE);
			enable_window(find_win(OPER_RESTORE), FALSE);
			enable_window(find_win(OPER_GETTEXT), FALSE);
			enable_window(find_win(OPER_SETTEXT), FALSE);
			enable_window(find_win(OPER_ENABLE), FALSE);
			enable_window(find_win(OPER_DISABLE), FALSE);
			break;
		case OPER_SHOW:
			for (i = 0; test_ctls[i].wtype != 0; i++)
				show_window(test_ctls[i].win, TRUE);
			enable_window(find_win(OPER_HIDE), TRUE);
			enable_window(find_win(OPER_SHOW), FALSE);
			break;
		case OPER_HIDE:
			for (i = 0; test_ctls[i].wtype != 0; i++)
				show_window(test_ctls[i].win, FALSE);
			enable_window(find_win(OPER_SHOW), TRUE);
			enable_window(find_win(OPER_HIDE), FALSE);
			break;
		case OPER_MOVE:
			for (i = 0; test_ctls[i].wtype != 0; i++)
				move_window(test_ctls[i].win, &test_ctls[i].rct2);
			enable_window(find_win(OPER_RESTORE), TRUE);
			enable_window(find_win(OPER_MOVE), FALSE);
			break;
		case OPER_RESTORE:
			for (i = 0; test_ctls[i].wtype != 0; i++)
				move_window(test_ctls[i].win, &test_ctls[i].rct1);
			enable_window(find_win(OPER_MOVE), TRUE);
			enable_window(find_win(OPER_RESTORE), FALSE);
			break;
		case OPER_GETTEXT:
			get_control_text();
			break;
		case OPER_SETTEXT:
			set_control_text();
			break;
		case OPER_ENABLE:
			for (i = 0; test_ctls[i].wtype != 0; i++)
				enable_window(test_ctls[i].win, TRUE);
			enable_window(find_win(OPER_DISABLE), TRUE);
			enable_window(find_win(OPER_ENABLE), FALSE);
			break;
		case OPER_DISABLE:
			for (i = 0; test_ctls[i].wtype != 0; i++)
				enable_window(test_ctls[i].win, FALSE);
			enable_window(find_win(OPER_ENABLE), TRUE);
			enable_window(find_win(OPER_DISABLE), FALSE);
			break;
		case TEST_CHECK1:
		case TEST_CHECK2:
			flip_checkbox(ep->v.ctl.id);
			break;
		case TEST_RADIO1:
		case TEST_RADIO2:
		case TEST_RADIO3:
			flip_radio(ep->v.ctl.id);
			break;
		case TEST_HSCROLL:
			valp = &hscroll_value;
			/* fall through */
		case TEST_VSCROLL:
			if (valp == NULL) /* e.g., didn't fall through from previous case */
				valp = &vscroll_value;
			switch (ep->v.ctl.ci.v.scroll.what) {
			case SC_LINE_UP:
				*valp = max(SCROLL_MIN, *valp - SCROLL_LINE);
				show_scroll_values();
				break;
			case SC_LINE_DOWN:
				*valp = min(SCROLL_MAX, *valp + SCROLL_LINE);
				show_scroll_values();
				break;
			case SC_PAGE_UP:
				*valp = max(SCROLL_MIN, *valp - SCROLL_PAGE);
				show_scroll_values();
				break;
			case SC_PAGE_DOWN:
				*valp = min(SCROLL_MAX, *valp + SCROLL_PAGE);
				show_scroll_values();
				break;
			case SC_THUMB:
				*valp = ep->v.ctl.ci.v.scroll.pos;
				show_scroll_values();
			}
		}
		break;
	case E_CLOSE:
		close_window(win);
		break;
	case E_COMMAND:
		if (ep->v.cmd.tag == M_FILE_QUIT)
			terminate();
		break;
	case E_QUIT:
		if (ep->v.query)
			quit_OK();
		else
			terminate();
	}
}

/* Application cleanup.  Nothing to do. */
void XVTENTRY appl_cleanup()
{
}
