/* $Header:   E:/src/xvt/pmwin/vcs/xvthelp.h_v   2.1   03 May 1989 16:23:10   MJR  $ */
/* XVT Version 1.2 */
/* Copyright 1987,1988 Advanced Programming Inst., Ltd. All rights reserved. */
 
/*
	Header file to be shared between SHELP.C and SCHELP.C.
*/

/* include menu tags and other defines */

#include "shelpmenu.h"
#include "hlpdefs.h"

typedef unsigned int TOPICNUM;

/* return indexing portion of TOPICNUM */
#define TOPICINDEX(n) ( (n))	

typedef struct {
	unsigned int no_wrap: 1, dummy:  15;
} TOPIC_ATTR_FLAGS;
 
typedef struct {
	long offset;				/* offset from end of header */
	short nlines;				/* number of lines of text in topic */
	TOPIC_ATTR_FLAGS flags;		/* attribute flags */
	int cbytes;				/* size of topic text & attrs in bytes */
	int cbText;				/* size of just the text in bytes */
	int iTitle;				/* index of title in string table */
} TOPIC;

#define SZ_TOPIC_BLK	sizeof(TOPIC)

/* 
** to size the header, we need to know how many shorts are in it
** if more are added, or anything else is added before 
** rgoffsets, then the macro SZ_FRONTSTUFF must change
*/
#define NSHORT 6
 
typedef struct {
	short hlpmagic;				/* magic number to identify file */
	short version;				/* version number */
	short ntopics;				/* number of topics */
	short ncstrings;			/* number of context strings */
	short nlists;				/* number of topic lists */
	short levCompress;			/* compression level */
	long  rgoffsets[N_FILE_POS];/* array of help offsets */	
	TOPIC topics[1];			/* topics (variable length array) */
} HEADER;
 
typedef struct {
	char *str;				/* pointer to context string */
	int topic;				/* topic string belongs to */
} CTABLE_ENTRY;

typedef struct {
	unsigned int  iStrIndex: 14, 		/* index into string table */
		iLevel: 2; 						/* hierarchy level */
} ITABLE_ENTRY;

/* text attribute stuff */

typedef union {
	struct {
		unsigned fBold: 1, fItalic: 1, fUnderlined: 1, 
				dummy: 8, fontID: 4, fHyper: 1;
		} Attrbits;
	unsigned intform;
} AttrType;


typedef struct {
	int oStart, oEnd;			/* starting and ending offsets */
	AttrType attr;				/* attribute flags */
} ATTRIBUTE_ENTRY;

typedef struct {
	int cAttrs;				/* count */
	ATTRIBUTE_ENTRY rgAttrs[0];	/* array of attributes */
	} ATTRIBUTE_LIST;

/* Hyperlink stuff */

/* link types */
#define LOCAL_HYPER 	0
#define NIL_HYPER		15

typedef struct {
	unsigned  linkID: 12, tyLink: 4;
	} LinkType;

typedef struct {
	int oStart, oEnd;			/* starting and ending offsets */
	char rgLinkID[1];			/* link ID */
	LinkType linkID;			/* if local, real link id, else overwritten 
								by string in rgLinkID */
} HYPER_ENTRY;

typedef struct {
	int cHypers;				/* count */
	HYPER_ENTRY rgHypers[0];		/* array of attributes */
	} HYPER_LIST;


/* Topic List stuff */

typedef struct {
	int cbList;
	char cbListName;
	char rgbListName[0];
	} TOPIC_LIST;

typedef struct {
	int cEntries;
	int rgListEntries[1];
	} TOPIC_ENTRY_LIST;
	

#define SZ_TOPIC		49
#define SZ_RGOFFSETS	N_FILE_POS * sizeof(long)
#define SZ_FRONTSTUFF	(NSHORT * sizeof(short) + SZ_RGOFFSETS)
#define SZ_HEADER		(SZ_FRONTSTUFF + SZ_TOPIC_BLK)
#define HEADER_SIZE(n)	(((n) - 1) * SZ_TOPIC_BLK + SZ_HEADER)
#define CTABLE_SIZE(n)  ( (n) * sizeof(CTABLE_ENTRY))
#define ITABLE_SIZE(n)  ( (n) * sizeof(ITABLE_ENTRY))
#define O_TOPIC_DESC(n) ( ((n) * SZ_TOPIC_BLK) + SZ_FRONTSTUFF)


/* string case comparison stuff */
#if XVTOS == CTOOS
#undef strncmp
#define strncmp nls_strncmpi
#undef strcmp
#define strcmp  nls_strcmpi
#undef isalnum
#define isalnum nls_isalnum
#undef isalpha
#define isalpha nls_isalpha
#undef isdigit
#define isdigit nls_isdigit
#undef tolower
#define tolower nls_tolower
#undef toupper
#define toupper nls_toupper

#ifdef PROTO
extern int nls_strcmpi(STR_FAR s1, STR_FAR s2);
extern int nls_strncmpi(STR_FAR s1, STR_FAR s2, unsigned short n);
extern int nls_toupper(int c);
extern int nls_tolower(int c);
extern int nls_isdigit(int c);
extern int nls_isalpha(int c);
extern int nls_isalnum(int c);
#else
extern int nlsstrcmpi();
extern int nls_strncmpi();
extern int nls_toupper();
extern int nls_tolower();
extern int nls_isdigit();
extern int nls_isalpha();
extern int nls_isalnum();
#endif
#endif

/*
** history stack
*/
typedef struct STK_TYPE STK_TYPE;

struct STK_TYPE {
	TOPICNUM topic_num;				/* topic saved */
	FILE *file;						/* file it came from */
	char *title;					/* title of topic */
	STK_TYPE *next;					/* link to next history item */
};

/*
** lookup structure 
*/

/*
** help window data
*/

typedef struct {
	WINDOW win;
	BOOLEAN enabled;
	char mne;
} CONTROL_BLK;

typedef struct {
	int sig;						/* help_win signature */
	TOPICNUM topic;					/* topic to bring up */
	BOOLEAN active;
	BOOLEAN fscrollevent;
	int rgolines[MAXLINES];			/* array of line offsets */
	int ifirst;						/* index of first line to display */
	int nlines;						/* count of lines to display */
	int fnowrap;					/* 0 = nowrap, 1 = wrap, -1 = not set */ 
	int height;						/* dimensions of window */
	int width;
	int cur_focus;					/* id of control with focus */
	WINDOW cur_win;					/* control in the window with the focus */
	CONTROL_BLK next_ctl;
	CONTROL_BLK prev_ctl;
	CONTROL_BLK return_ctl;
	CONTROL_BLK back_ctl;
	char *ptext;
	int  cbtext;
	char *pattrs;
	int  cbattrs;
	ATTRIBUTE_LIST *pAttrList;
	int  cAttrs;
	HYPER_LIST *pLinkList;
	int  cLinks;
	char *ptitle;
	FILE *file;						/* must remember file the topic is from */
	TOPICNUM parent_topic;			/* hyperlink - immediate ancestor */
	TOPICNUM ancestor_topic;		/* hyperlink - top-level ancestor */
} HELP_DATA;

#ifdef FPROTO
typedef void (*EVENT_HANDLER)(WINDOW win, EVENT *ep, HELP_DATA *data);
#else
typedef void (*EVENT_HANDLER)();
#endif

typedef struct {
	EVENT_HANDLER class_fcn;		/* fcn to handle events */
	HELP_DATA *instance_data;		/* data specific to window */
} HELP_DISPATCH;

typedef struct h_event_type {
    short type; 					/* E_HELP, E_FOCUS */
    TOPICNUM topic_num; 			/* topic to display */
	int ctl_focus;					/* switch focus to */
} HEVENT;

typedef struct win_rec_type {
	WINDOW win;						/* window of topic */
	TOPICNUM topic_num;				/* topic displayed */
	FILE *file;						/* file associated with this window */
} WINREC; 

typedef struct file_rec_type {
	char *name;						/* file name */
	FILE *file;						/* associated file pointer */
} FILEREC; 
 
typedef struct {
	char *context_str;				/* a context string */
	int index;						/* current lookup index */
	BOOLEAN exclusive;				/* look for multiple matches */
} LOOKSTRUCT;




/* this is the end of line character from the help compiler */
#define DELIM	0x00

/*
** help messages, button text, etc. 
** this range is defined in url.h, along with the 
** nationalizable text 
*/

#define BAD_TOPIC			-1		/* means context not found */
#define BAD_FOCUS			-1		/* means focus hasn't changed */
#define MAX_NLS_STR			128		/* from cnls.h */
#define LIST_ITEM			4		/* 4 in both boxes */
#define TOPICS_BOX			-1		/* phony "topic" that means topics box */
#define HIST_BOX			0		/* distinguish topics from history box */
#define HYPER_BOX			1		/* and again from hyper box */
#define DLG_MAINBOX_CLOSING 1001	/* special dlg item for main box closing */
#define DLG_SHOW			1002	/* special dlg item to keep topic list up*/

#define HLP_MSG_BASE		NLS_START+120
#define STR_HELP_HELP		HLP_MSG_BASE
#define STR_HELP_EXTENDED	HLP_MSG_BASE+1
#define STR_HELP_KEYS		HLP_MSG_BASE+2
#define STR_HELP_PATH		HLP_MSG_BASE+3
#define STR_NEXT_BUTTON		HLP_MSG_BASE+4
#define STR_PREV_BUTTON		HLP_MSG_BASE+5
#define STR_RETURN_BUTTON	HLP_MSG_BASE+6
#define STR_BACK_BUTTON		HLP_MSG_BASE+7

/*
** error message numbers for schelp
*/

#define MSG_MAX			  	255
#define MSG_NO_MORE_MEM 	1
#define MSG_WRITE_ERROR 	2
#define MSG_CONTEXT_EXISTS 	3
#define MSG_TOPIC_EXISTS 	4
#define MSG_NAME_LONG		5
#define MSG_TOPIC_START 	6
#define MSG_TOPIC_ENDS		7
#define MSG_CATEGORY		8
#define MSG_CONTEXT			9
#define MSG_TOPICLIST		10
#define MSG_TEXT_LONG		11
#define MSG_EOF				12
#define MSG_CREATE_FAILED	13
#define MSG_COPY_HDR		14
#define MSG_DONE			15
#define MSG_COPY_TEXT		16
#define MSG_COPY_CONTEXT	17
#define MSG_COPY_TOPICS     18
#define MSG_COPY_INDEX		19
#define MSG_N_TOPICS		20
#define MSG_N_CONTEXTS		21
#define MSG_N_TOPICLISTS	22
#define MSG_C_CONTEXTS		23
#define MSG_C_INDEX			24
#define MSG_USAGE			25
#define MSG_ERC_OPEN		26
#define MSG_TOPICS_MAXED	27
#define MSG_TOPIC_DETAIL	28
#define MSG_FATAL			29
#define MSG_NOT_YESNO		30
#define MSG_IN_TEXT			31
#define MSG_ILLEGAL_DOT		32
#define MSG_NO_TEXT			33
#define MSG_SUB_NO_MAIN		34
#define MSG_TMPFILE_FAIL	35
#define MSG_REMOVE_ILLEGAL	36
#define MSG_UNEXPECTED_EOF	37
#define MSG_LINE_TOO_LONG	38
#define MSG_PARAM_REQUIRED	39

#define MSG_FORMAT_UNRECOG	40
#define MSG_ILLEGAL_ATTR		41
#define MSG_LINK_UNRESOLVED	42
#define MSG_NO_QUICKHELP		43
#define MSG_NO_PMHELP		44
#define MSG_DOING_NEWHELP	45
#define MSG_DOING_OLDHELP	46

#define MSG_NO_PARLEV		47
#define MSG_NO_TOPIC		48
#define MSG_NO_PARENT		49

#define MSG_C_KEYWORD		50
#define MSG_C_HUFFMAN		51
#define MSG_LEVCOMPRESS		52
#define MSG_BUILD_KEYTBL		53
#define MSG_HYPER_VER		54
#define MSG_DUP_TOPIC		55
#define MSG_TOOMANY_TOPLISTS	56
#define MSG_LOCTOP_IN_TOPLIST 57
#define MSG_ERROR_INFO		58
#define MSG_CSTRING_IN_LOCTOP 59
#define MSG_LOCTOP_CANT_SUBTOP 60
#define MSG_COMP_DETAIL		61
#define MSG_YES			62
#define MSG_NO				63
#define MSG_TOOMANYCSTRINGS 64

#define MSG_TOPIC_TITLE		75
#define MSG_CATTRS			76
#define MSG_CLINKS			77
#define MSG_O_START			78
#define MSG_O_END			79
#define MSG_ATTR_VALUE		80
#define MSG_TOP_NUM			81
#define MSG_CSTRING			82

#define MSG_USE_UNHELP		83
#define MSG_BADFORMAT		84
#define MSG_BADVERSION		85
#define MSG_FILENAME		86
#define MSG_INDEX			87
#define MSG_TOPICNUM		88
#define MSG_NESTLEV			89

#define MSG_TOPICS			90
#define MSG_PROC_TOPIC		91

#define MSG_USE_CONVERT		105
#define MSG_NO_CONVERTVER	106
#define MSG_CONV_OK			107
