/* calculator.y:  parser for simple calculator program, as shown in
 *                "Compilers:  Principles, Techniques, and Tools" by Aho,
 *                Sethi, and Ullman, page 266.
 *
 * To build:
 *
 *    Lex
 *      Input file          calculator.l            <GO>
 *
 *    Yacc
 *      Input file          calculator.y            <GO>
 *
 *    hc
 *      Source file         y.tab.c
 *      [Parameters]        -mm big                 <GO>
 *
 *    Bind
 *      Object modules      y.tab.obj
 *      Run file            calculator.run
 *      ...
 *      [Run file mode]     protected
 *      ...
 *      Libraries           [sys]<toolkit>big\toolkit.lib [sys]<h>hcbe.lib
 */

%{
#include <ctype.h>
#include <stdio.h>
#define YYSTYPE double		/* double type for Yacc stack */
%}

%token NUMBER
%left '+' '-'
%left '*' '/'
%left UMINUS

%%
lines	:	lines expr '\n'			{ printf("%g\n", $2); }
		|	lines '\n'
		|	/* empty */
		|	error '\n'				{ yyerror("reenter last line:");
									  yyerrok; }
		;
expr	:	expr '+' expr			{ $$ = $1 + $3; }
		|	expr '-' expr			{ $$ = $1 - $3; }
		|	expr '*' expr			{ $$ = $1 * $3; }
		|	expr '/' expr			{ $$ = $1 / $3; }
		|	'(' expr ')'			{ $$ = $2; }
		|	'-' expr %prec UMINUS	{ $$ = - $2; }
		|	NUMBER
		;
%%
#include "lex.yy.c"
