# CompareMapFiles.awk - compares two map files for changed segments
#
# Compare Map Files
#	First map file
#	Second map file
#	[Log file]

BEGIN { 
	if (ARGV[1] == "") {
		print "First map file not specified."
		exit
	}	
	if (ARGV[2] == "") {
		print "Second map file not specified."
		exit
	}
	if (ARGV[3] == "")
		logfile = "[vid]"
	else {
		logfile = ARGV[3]
		ARGV[3] = ""				# avoid reading in log file
	}
}

# match on five-digit hex strings in first column
$1 ~ /[0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F]h/ {

	if (FILENAME == ARGV[1]) {
		if (nSegments == 0)
			printf("Reading %s ...", ARGV[1])
		nSegments++
		segments[nSegments,1] = $5
		segments[nSegments,2] = $3

		if (!(nSegments % 10))				# print dot every 10 segments
			printf (".")
	} 
	else {
		if (nNew == 0)
			printf(" done.\nReading %s ...", ARGV[2])

		# Initially assume that new map is as big or bigger than old map,
		# so we'll start searching from the same index and circle around 
		# if necessary.
		iSeg = ++nNew
		if (!(nNew % 10))					# print dot every 10 segments
			printf (".")
		while ($5 != segments[iSeg, 1]) {
			iSeg++
			if (iSeg == nNew)				# no match
				break
			if (iSeg > nSegments)
				iSeg = 1
		}
		if ($5 != segments[iSeg, 1]) {		# new segment
			--nNew							# sync back up with old map
			segments[++nSegments, 1] = $5 " (New)"
			segments[nSegments, 2] = "00000h"
			segments[nSegments, 3] = $3
		}
		if ($3 != segments[iSeg, 2])		# segment changed size
			segments[iSeg, 3] = $3
		else								# segment is unchanged, erase it
			segments[iSeg, 1] = ""
	}
}

END {
	printf(" done.\n\n")
	if (logfile != "[vid]")
		printf("Old map file:  %s\nNew map file:  %s\n\n", ARGV[1], 
			ARGV[2]) >logfile

	print "Segment size increase:\n" >logfile
	for(i = 1; i <= nSegments; i++)
		if (segments[i, 1] != "") {
			bytes = hex(segments[i, 3]) - hex(segments[i, 2])
			printf("%-40s\t%.0f\n", segments[i, 1], bytes) >logfile
			totalbytes += bytes
		}

	printf("\n%-40s\t%.0f bytes\n", "Total size difference", 
		totalbytes) >logfile
}


function hex(s,   j, n) {			# j and n are local variables
	hexstr = "0123456789ABCDEF"
	n = 0;
	for(j = 1; j <= 4; j++)
		n = (n * 16) + (index(hexstr, substr(s, j, 1)) - 1)
	return n;
}
