;*****************************  MODULE HEADER  *******************************;
;*                                                                           *;
;*                                                                           *;
;*  MACHINE:                LANGUAGE:  Assembler             OS: CTOS        *;
;*                                                                           *;
;*  QicInterrupts.Asm                                                        *;
;*                                                                           *;
;*  Workstation HB-001 and Flemington HB-001 interrupt service.              *;
;*                                                                           *;
;*                                                                           *;
;*  HISTORY:                                                                 *;
;*  --------                                                                 *;
;*                                                                           *;
;*  MM/DD/YY  VVVV/MM  PROGRAMMER    /  DESCRIPTION                          *;
;*                                                                           *;
;*  12/04/90  121E.00  P. Johansson  /  Created.                             *;
;*                                                                           *;
;*                    PROPRIETARY  PROGRAM  MATERIAL                         *;
;*                                                                           *;
;*  THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO         *;
;*  BE REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM       *;
;*  LICENSE OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF          *;
;*  UNISYS CORPORATION, DETROIT, MICHIGAN 48232, USA.                        *;
;*                                                                           *;
;*  COPYRIGHT (C) 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED               *;
;*                                                                           *;
;*****************************************************************************;
;*                                                                           *;
;*  UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE         *;
;*  AND RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION. HOWEVER,  *;
;*  NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY       *;
;*  CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS     *;
;*  OF PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO     *;
;*  WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                *;
;*                                                                           *;
;*  THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE     *;
;*  WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE       *;
;*  JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                          *;
;*                                                                           *;
;**************************  END OF MODULE HEADER  ***************************;

$TITLE(04 DEC 90: Workstation QIC Module(s) Interrupt Service)
$PAGEWIDTH(132)
$PAGELENGTH(60)
%SET(Debug, 1)

QicIntCode	SEGMENT	PUBLIC 'Code'
QicIntCode	ENDS

DGroup		GROUP	QicIntData
QicIntData	SEGMENT	PUBLIC 'Data'
QicIntData	ENDS

		ASSUME	CS:QicIntCode
		ASSUME	DS:DGroup

; San Jose QIC Module register addresses and bit assignments

qicCtrlLinesReg		EQU 0080h	;NB: These are offset by a base address
qicCommandReg		EQU 0080h
qicControlReg		EQU 0082h
qicCtrlLineReg		EQU 0084h
qicClearIntReg		EQU 0088h
qicDmaAddrLowReg	EQU 008Ah
qicDmaAddrMidReg	EQU 008Ch
qicDmaAddrHighReg	EQU 008Eh
qicCounter0Reg		EQU 0090h
qicCounter1Reg		EQU 0092h
qicCounter2Reg		EQU 0094h
qicTimerModeReg		EQU 0096h

qicSelect		EQU 10000000b	;Bit assignments in QIC Control
qicDmaRead		EQU 01000000b
qicDmaWrite		EQU 00100000b
qicONLINE		EQU 00000010b
qicRESET		EQU 00000001b

endOfCommand		EQU 00100000b	;Bit assignments in QIC Control Lines
terminalCount		EQU 00010000b
qicDIRC			EQU 00001000b
qicEXCP			EQU 00000100b
qicREADY		EQU 00000010b
qicACK			EQU 00000001b

; Flemington QIC Module register addresses and bit assignments

flemQicControlReg	EQU 0000h	;NB: These are offset by a base address
flemQicStatusReg	EQU 0000h
flemQicDataReg		EQU 0002h
flemQicBlockCountReg	EQU 0004h
flemQicDmaAddrLowReg	EQU 0006h
flemQicDmaAddrMidReg	EQU 0008h
flemQicDmaAddrHighReg	EQU 000Ah

flemQicLED		EQU 01000000b	;Bit assignments in QIC Adaptor Control
flemQicIntEnable	EQU 00100000b
flemQicDmaEnable	EQU 00010000b
flemQicDmaWrite		EQU 00001000b
flemQicDmaRead		EQU 00000000b	;NB: Bit 3 clear to read from memory
flemQicRESET		EQU 00000100b
flemQicREQUEST		EQU 00000010b
flemQicONLINE		EQU 00000001b

transferComplete	EQU 10000000b	;Bit assignments in QIC Adaptor Status
commandAccepted		EQU 00001000b
flemQicREADY		EQU 00000010b
flemQicEXCP		EQU 00000001b

; Format of QIC pseudo-request block (used to communicate the occurrence of
; an interrupt to a background process that can service it.

sCntInfo		EQU	BYTE PTR 0
rtCode			EQU	BYTE PTR 1
nReqpbCb		EQU	BYTE PTR 2
nRespPbCb		EQU	BYTE PTR 3
userNum			EQU	WORD PTR 4
exchResp		EQU	WORD PTR 6
ercRet			EQU	WORD PTR 8
rqCode			EQU	WORD PTR 10
fSendMsg		EQU	BYTE PTR 12	;Used by San Jose module
fCommandAccepted	EQU	BYTE PTR 12	;Used by Flemington module
fInterrupt		EQU	BYTE PTR 13
qicControl		EQU	BYTE PTR 14
qicCtrlLines		EQU	BYTE PTR 15

; External procedures referenced by this module

		EXTRN	qic_command_accepted_interrupt:FAR
		EXTRN	Send:FAR

; Public variables exported by this procedure

QicIntData	SEGMENT

		PUBLIC	qic_base_addr
		PUBLIC	qic_control
		PUBLIC	qic_iob

qic_base_addr	DW	0		; Module I/O base address
qic_control	DD	0		; Pointer to control lines image
qic_iob		DD	0		; Pointer to QIC "Iob"

%IF(%Debug) THEN(%'
		PUBLIC	XINT4Interrupts
		PUBLIC	bogusInterrupts
		PUBLIC	bogusSnapshot
		PUBLIC	qicInterrupts
		PUBLIC	qicSnapshot

XINT4Interrupts	DW	0
bogusInterrupts	DW	0
qicInterrupts	DW	0
bogusSnapshot	DW	0
qicSnapshot	DW	0

)FI%'

QicIntData	ENDS

QicIntCode	SEGMENT

		PUBLIC	QicISR
		PUBLIC	FlemQicISR

; Interrupt service for the San Jose QIC-02 tape backup modules.  These modules
; all require the presence of the XBus interface service; the procedure below
; is a multiplexed interrupt service called from the mediated handler in the
; XBus service.  We must ascertain whether or not we have a valid interrupt
; that matches an operation in progress and ultimately return TRUE or FALSE to
; the multiplex dispatcher.  When we do have a valid interrupt, clear the
; interrupt condition and dispatch a message to the (process level) interrupt
; handler.

QicISR		PROC	FAR

		PUSH	BP
		MOV	BP,SP
%IF(%Debug) THEN(%'
		INC	XINT4Interrupts
)FI%'
		MOV	DX,qic_base_addr
		OR	DX,DX		;Is a QIC module present?
		 JE	QicISRNull	;Nope, somebody else's interrupt
		MOV	DL,qicControlReg
		IN	AL,DX
		TEST	AL,qicSelect	;LED on, interrupts enabled?
		 JZ	QicISRNull	;Nope, must not be our interrupt
		MOV	CL,AL		;Save for use later
		MOV	DL,qicCtrlLineReg
		IN	AL,DX
		TEST	AL,endOfCommand OR terminalCount OR qicEXCP
		 JZ	QicISRBogus	;Alas, nothing of interest!
		MOV	CH,AL		;Both register images now in CX
%IF(%Debug) THEN(%'
		INC	qicInterrupts
		MOV	qicSnapshot,CX
)FI%'
		LES	BX,qic_control
;		AND	BYTE PTR ES:[BX],NOT (qicSelect OR qicDmaRead OR qicDmaWrite)
;			Because of an assembler bug, the above doesn't work!
		AND	BYTE PTR ES:[BX],1Fh	;OK, Work-around the bug
		MOV	AL,ES:[BX]
		MOV	DL,qicControlReg
		OUT	DX,AL		;Turn off DMA permission(s), select
		MOV	DL,qicClearIntReg
		MOV	AL,0FFh		;Actually, any value will do
		OUT	DX,AL		;Clear pending interrupt
		LES	BX,qic_iob	;ES:[BX] => "request" block
		CMP	ES:ercRet[BX],0FFFFh	;Operation in progress?
		 JNE	QicISRDone	;Nope, don't mess with "request" block
		XOR	AX,AX		;Clear the erc field
		MOV	ES:ercRet[BX],AX
		MOV	ES:fInterrupt[BX],0FFh	;Let waiting client know...
		MOV	ES:qicControl[BX],CL	;Stash images of registers
		MOV	ES:qicCtrlLines[BX],CH
		CMP	ES:fSendMsg[BX],AL	;Does client want a Send?
		 JE	QicISRDone		;No, just return to XBIF
		PUSH	ES:exchResp[BX]	;Send message to signal interrupt
		PUSH	ES
		PUSH	BX
		CALL	Send
QicISRDone:	MOV	AL,0FFh		;Return TRUE to XINT4 multiplexer
		POP	BP
		RET

QicISRBogus:
%IF(%Debug) THEN(%'
		INC	bogusInterrupts
		MOV	bogusSnapshot,CX
)FI%'
QicISRNull:	XOR	AX,AX		;Let ISR multiplexer know it's not ours
		POP	BP
		RET

QicISR		ENDP

; Interrupt service for the Flemington QIC-02 tape backup module.  On some
; hardware configurations the assistance of the XBus interface service is not
; required, but it is harmless to consider the interrupt service below as if
; it were always called from the interrupt multiplexer.  If we discover a
; valid interrupt, save any appropriate status and send a message to the
; (process level) interrupt service routine.

FlemQicISR	PROC	FAR

		PUSH	BP
		MOV	BP,SP
%IF(%Debug) THEN(%'
		INC	XINT4Interrupts
)FI%'
		MOV	DX,qic_base_addr
		OR	DX,DX		;Is a QIC module present?
		 JE	FlemQicISRNull	;Nope, somebody else's interrupt
		LES	BX,qic_control	;Mimic behavior of San Jose module
		MOV	AL,ES:[BX]
%IF(%Debug) THEN(%'
		MOV	CL,AL
)FI%'
		AND	AL,flemQicLED OR flemQicIntEnable	;LED on and...
		CMP	AL,flemQicLED OR flemQicIntEnable	;...enabled?
		 JNE	FlemQicISRNull	;Nope, must not be our interrupt
		MOV	DL,flemQicStatusReg
		IN	AL,DX
%IF(%Debug) THEN(%'
		MOV	CH,AL		;Both register images now in CX
)FI%'
		TEST	AL,transferComplete OR commandAccepted OR flemQicEXCP
		 JZ	FlemQicISRBogus	;Alas, nothing of interest!
%IF(%Debug) THEN(%'
		INC	qicInterrupts
		MOV	qicSnapshot,CX
)FI%'
		AND	AL,transferComplete OR commandAccepted OR flemQicEXCP
		CMP	AL,commandAccepted
		 JE	FlemQicCmndOK	;Accepted, but not necessarily done!
;		AND	BYTE PTR ES:[BX],NOT (flemQicLED OR flemQicIntEnable)
;			Because of an assembler bug, the above doesn't work!
		AND	BYTE PTR ES:[BX],9Fh	;OK, Work-around the bug
		TEST	AL,flemQicEXCP	;Is there an exception?
		 JE	FlemQicISRCtrl	;No, leave the DMA bit alone!!!!
		AND	BYTE PTR ES:[BX],NOT flemQicDmaEnable
FlemQicISRCtrl:	MOV	AL,ES:[BX]
		MOV	DL,flemQicControlReg
		OUT	DX,AL		;Turn off DMA permission, LED, etc.
		LES	BX,qic_iob	;ES:[BX] => "request" block
		CMP	ES:ercRet[BX],0FFFFh	;Operation in progress?
		 JNE	FlemQicISRDone	;Nope, don't mess with "request" block
		XOR	AX,AX		;Clear the erc field
		MOV	ES:ercRet[BX],AX
		MOV	ES:fInterrupt[BX],0FFh	;Let watchdog know...
		MOV	ES:qicControl[BX],CL	;Stash images of registers
		MOV	ES:qicCtrlLines[BX],CH
		PUSH	ES:exchResp[BX]	;Send message to signal interrupt
		PUSH	ES
		PUSH	BX
		CALL	Send
FlemQicISRDone:	MOV	AL,0FFh		;Return TRUE to XINT4 multiplexer
		POP	BP
		RET

FlemQicISRBogus:
%IF(%Debug) THEN(%'
		INC	bogusInterrupts
		MOV	bogusSnapshot,CX
)FI%'
FlemQicISRNull:	XOR	AX,AX		;Let ISR multiplexer know it's not ours
		POP	BP
		RET

FlemQicCmndOK:	MOV	AL,ES:[BX]
		MOV	DL,flemQicControlReg
		OUT	DX,AL
		LES	BX,qic_iob	;ES:[BX] => "request" block
		CMP	ES:ercRet[BX],0FFFFh	;Operation in progress?
		 JNE	FlemQicISRDone	;Nope, don't mess with "request" block
		MOV	ES:fCommandAccepted[BX],0FFh
		CALL	qic_command_accepted_interrupt	;Command specific
		JMP	FlemQicISRDone

FlemQicISR	ENDP

QicIntCode	ENDS

		END
