%MOD386

%SET(debug, 1)

%if (0) then (
Module: Fixup.asm

Public interfaces exported by this module:

	FixupPage: (laFault, qFixup) ercType
	
	Loader subroutines:
		AliasRfe: (sg, tyRfe)
		AliasImpLib: (sg, iLib)
		LoadUserLdtr: (wLdtr)
		FChecksum: (pla, cPar, qChecksum)


Description:

When the loader allocates linear space it asks the Pager associate the address
of the Fixup Info Block with the linear space. When a fault occurs the Pager calls here with laFault and a pointer to the FIB. The FIB contains a rough table which maps relative pages to a list of fixup addresses within the page. 
The rough table and fixup addresses are loaded from the run file; multiple FIBs may use the same table, fib.lampiPageoFixup describing which part of the table applies to the range of linear addresses associated with the FIB.



FIB													   FixupTable
---													   _________
laFixupBase----------------------------------         |fte0Pg0	|
laStart					 ___________		|		  |    .	|
laEnd					|oListPg0	|		|		  |fteNPg0  |
lampiPageoFixupList---->|	.		|-------+-------->|fte0Pg1  |
laMpSnSg				|	.		|				  |	   .	|
laIib					|	.       |				  |fteNPg1	|
sgXib					|oListPgN	|				  |	   .	|
						|___________|				  |ftePgN	|
						(rough table)				  |ftePgN	|
													  |_________|



FixupTableEntries (fte) contain the fixup type and the page relative address
of the fixup.

Fte Format:
	bits 0-13	: signed relative page address
	bit	 14		: unused
	bits 15-16  : tyFixup, where
					0: 	local sn fixup.
						if fixup spans page, the link-time sn follows fte.
					1:  import sn:ra fixup.
						never spans page, link-time sn:ra in incoming page.
					2:  import sn fixup.
						link-time sn:ra follows fte.
					3:  import ra fixup.
						link-time sn:ra and raDelta follows fte.
						

)fi
$INCLUDE(:f1:Descriptors.mdf)

fib_laFixupBase		EQU 0
fib_lampiPageoFixup	EQU	4
fib_laStart			EQU 8
fib_laEnd			EQU 12
fib_laMpSnSg		EQU 16
fib_laIib			EQU 20
fib_sgXib			EQU 24

impLib_cImport		EQU 12

importDesc_ra		EQU 0
importDesc_sn		EQU 2
sImportHdr			EQU 14
sImportDesc			EQU 4

mSnFixup			EQU 8000h
mDllFixup			EQU 4000h
mSignBit			EQU 2000h
miLib				EQU 0001h
moPage				EQU 03fffh

ercOk				EQU 0
ercInconsistency	EQU 3
ercCannotBind 		EQU 1108
ercBadRunFile		EQU 246

liMsgFixupError 	EQU 60006

rfe_pla		EQU 0
rfe_cpar	EQU 4
sRfe		EQU 12
desc_limit 	EQU 0
desc_laLow  EQU 2
desc_laMid  EQU 4
desc_laHi   EQU 7
desc_bAcc	EQU 5


EXTRN Crash: FAR
EXTRN ErrorExit: FAR
EXTRN EibLog: FAR	; EibLog (iMsg, pSb0, pSb1, sgXib) EXTERNAL


Data SEGMENT PUBLIC 'Data'
EXTRN pRun:DWORD
EXTRN sgTmp: WORD
EXTRN plaDir:DWORD
Data ENDS
Dgroup GROUP Data


FixupCode SEGMENT BYTE PUBLIC 'Code'
ASSUME CS:FixupCode

FixupCase LABEL WORD
	DW	  LocalSn, ImportSnRa, ImportSn, ImportRa

sArgs		EQU 8

;
;
; FixupPage: (laFault, pFib) ercType
;
; 
PUBLIC FixupPage
FixupPage PROC FAR
ASSUME DS: Nothing
ASSUME ES: Nothing
pFib		EQU DWORD PTR [BP+6]
oFib		EQU WORD PTR [BP+6]
laFault		EQU DWORD PTR [BP+0Ah]
sArgs		EQU 8
laMpSnSg	EQU DWORD PTR [BP-4]
sLocals		EQU 4

	PUSH  BP
	MOV   BP, SP
	SUB   SP, sLocals

%IF (%debug) THEN (
	CMP   DWORD PTR laFault, 0ffffffffh
	JNE   @0
	INT   3
@0:
)FI

	LES   BX, pFib
	MOV   EDI, laFault
	CMP   EDI, ES:DWORD PTR [BX + fib_laEnd]
	JAE   InternalError
	SUB	  EDI, ES:DWORD PTR [BX + fib_laStart]
	JC    InternalError
	SHR	  EDI, 10
; EDI = hyperseg relative page number * 4
	ADD   EDI, ES:DWORD PTR [BX + fib_lampiPageoFixup]
; EDI = la of mpiPageoFixupList(iPageFault)

	MOV   EAX, ES: DWORD PTR [BX + fib_laMpSnSg]
	MOV   laMpSnSg, EAX
	MOV   EDX, ES:DWORD PTR [BX + fib_laFixupBase]
	MOV   AX, sgZero
	MOV   FS, AX		

	MOV   ESI, FS:DWORD PTR [EDI]		
	ADD   ESI, EDX
; ESI = laFixupList this page 
	MOV   ECX, FS:DWORD PTR [EDI+4]	
	ADD   ECX, EDX
; ECX = laFixupList of next page 

Top:
; ESI = la of next fixup record
; ECX = la of fixup record for next page
; FS = 32-bit segment at linear 0
; ES = sgFib
	CMP   ESI, ECX
	JE 	  FixupsDone
	MOV   EDI, laFault
	XOR   EBX, EBX	; high(ebx)=0
	MOV   BX, FS: WORD PTR [ESI]
	MOV   DX, BX
	AND   DX, 1FFFh		; DX = page relative fixup addr
	AND   BX, 0C000h	; high 2 bits are tyFixup
	SHR   BX, 13		; make jmp table index
	JMP   WORD PTR FixupCase[BX]

InternalError:
	PUSH  ercInconsistency
	CALL  Crash


LocalSn:
;*
;* segment fixup, local reference (not import)
;*		sn in incoming page, or 
;*		sn follows FixupTableEntry if fixup on page boundary.
;*
; DX = offset of fixup in incoming page 
; EDI = la of incoming page
; ESI = la of FixupTableEntry
	CMP	  laMpSnSg, 0
	JNE   LocalSn_HasMap
; has no sn-sg map - must be ldt application. no need for local fixups
	CMP   DX, 0FFFh 
; increment fte pointer if boundary fixup
	JB	  @3
	ADD   ESI, 2
@3:
	JMP   NextFixup

LocalSn_HasMap:
	MOV   BX, DX
	CMP   BX, 0FFFh
; test for page boundary, 0FFFh (end of page) or 1FFFh (-1, start of page).
	JAE   LocalSn_OnPageBoundary
	MOV   DX, FS: WORD PTR [EDI][EBX]	
; DX = link-time selector
	CALL  LookupSg
; DX = run-time selector
; EDI = page, EBX = page offset
	MOV   FS: WORD PTR [EDI][EBX], DX
	JMP   NextFixup

LocalSn_OnPageBoundary:
	ADD   ESI, 2
	MOV   DX, FS: WORD PTR [ESI] ; sn follow FixupTableEntry
; DX = link-time selector
	CALL  LookupSg
; DX = run-time selector
; EDI = page, EBX = page offset
	TEST  BX, 1000h 
	JZ    LocalSn_EndOfPage
; sn fixup straddles start of page
	MOV   FS: BYTE PTR [EDI], DH
	JMP   NextFixup
LocalSn_EndOfPage:
	MOV   FS: BYTE PTR [EDI][0FFFh], DL
	JMP   NextFixup
	

ImportSnRa:
;*
;* sn:ra pair fixup, import reference 
;*		sn:ra in incoming page. reference never straddles boundary.
;* 
; DX = offset of fixup in incoming page 
; EDI = la of incoming page
; ESI = la of FixupTableEntry
	MOV   BX, DX
	CMP   BX, 0FFEh
	JA    ImportSnRa_BogusFixupData
	CMP   BX, 2
	JB    ImportSnRa_BogusFixupData
	MOV	  DX, FS: WORD PTR [EDI][EBX]
; DX = import sn (iLib in bits 1-15m, bit 0 always set)
	TEST  DX, 1
	JZ	  ImportSnRa_BogusFixupData
	MOV   AX, FS: WORD PTR [EDI][EBX-2]
; DX:AX = link-time import reference
	CALL  LookupExport
; DX:AX = run-time import reference
	MOV	  FS: WORD PTR [EDI][EBX], DX
	MOV	  FS: WORD PTR [EDI][EBX-2], AX
	JMP   NextFixup
ImportSnRa_BogusFixupData:
	CALL  ReturnCrazyFixup	; never returns

	

ImportSn:
;* 
;* sn fixup, import reference 
;*		sn:ra follows FixupTableEntry.
;* 
; DX = offset of fixup in incoming page 
; EDI = la of incoming page
; ESI = la of FixupTableEntry
	MOV   BX, DX
	ADD   ESI, 4
	MOV   DX, FS: WORD PTR [ESI]		; iLib 
	MOV   AX, FS: WORD PTR [ESI-2]		; iProc
	CALL  LookupExport
	MOV   AX, DX	; AX = run time sn
	JMP	  DoSnOrRaFixup
	

ImportRa:
;*
;* an fixup, import reference 
;*		sn:ra follows FixupTableEntry.
;* 
; DX = offset of fixup in incoming page 
; EDI = la of incoming page
; ESI = la of FixupTableEntry
	MOV   BX, DX
	ADD   ESI, 6
	MOV   DX, FS: WORD PTR [ESI-2]		; iLib 
	MOV   AX, FS: WORD PTR [ESI-4]		; iProc
	CALL  LookupExport
	ADD   AX, FS: WORD PTR [ESI]		; raDelta
; AX = run time ra 


DoSnOrRaFixup:
; AX = word to write
; EBX = oPage
; EDI = laPageFault
	TEST  BX, 1000h 
	JNZ   StartOfPage
	CMP   BX, 0fffh
	JE    EndOfPage
	MOV   FS: WORD PTR [EDI][EBX], AX
	JMP   NextFixup
EndOfPage:
	MOV   FS: BYTE PTR [EDI][0FFFh], AL
	JMP   NextFixup
StartOfPage:
	MOV   FS: BYTE PTR [EDI], AH

NextFixup:
	ADD   ESI, 2
	JMP   Top
	
FixupsDone:
	XOR   AX, AX
	MOV   SP, BP
	POP   BP
	RET   sArgs

FixupPage ENDP





PUBLIC LookupExport
LookupExport PROC NEAR
; DX = sn (encoded iLib )
; AX = ra (iProc)
; ES = sgFib
; FS = sgAllMem
; return sn:ra in DX:AX
; preserves ESI, EDI, ECX, EBX
	PUSH ESI
	PUSH EBX
	MOV  SI, DX
	AND  ESI, 0ffffh	; reset high(esi)
	SHR  SI, 3
	MOV  BX, oFib
	MOV	 EBX, ES: DWORD PTR [BX + fib_laIib]
	OR   EBX, EBX
	JE   CrazyImports
	CMP  SI,  FS: WORD PTR [EBX]	; iLib < iib.cLib?
	JAE	 CrazyImports
	SHL  SI, 2
	ADD  EBX, FS: DWORD PTR [EBX][ESI+2]
; EBX = laImpLib
	AND  EAX, 0ffffh	; reset high(eax)

	CMP  AX, FS: WORD PTR [EBX + impLib_cImport]	; iProc < impLib.cImports?
	JAE  CrazyImports

	SHL  AX, 2
	ADD  EBX, EAX
; EBX = laImport - sImportHdr
	MOV  DX, FS: WORD PTR [EBX + sImportHdr + importDesc_sn]	
	MOV  AX, FS: WORD PTR [EBX + sImportHdr + importDesc_ra]	
	POP  EBX
	POP  ESI
	RET

CrazyImports:
	CALL ReturnCrazyFixup	; never returns

LookupExport ENDP

ReturnCrazyFixup PROC NEAR
PUBLIC ReturnCrazyFixup
; log error and return from far call to FixupPage with error

; CALL EibLog(liMsgFixupError, 0, 0, @fix.sgXib)
	LES   BX, pFib
	PUSH  liMsgFixupError
	DB 66h
	PUSH  0	; quad
	DB 66h
	PUSH  0 ; quad
	PUSH  ES:WORD PTR [BX + fib_sgXib] ; fib owner
	CALL  EibLog	

	MOV   AX, ercBadRunFile
	MOV   SP, BP
	POP   BP
ReturnCrazyFixup ENDP
FarRet PROC FAR
	RET   sArgs
FarRet ENDP


PUBLIC LookupSg
LookupSg PROC NEAR
; DX = link-time sn
; ES = sgFib
; returns run-time sn in DX
; preserves ESI, EDI, EBX
	OR    DX, DX
	JNZ   Resolvable
	RET	  ; unresolved reference in run file, selector stays zero
Resolvable:
	PUSH  EBX
	AND   EDX, 0fff8h	; reset ldt bit, reset high(edx)
	SHR	  DX, 3			; sn -> iSn 
	MOV   EBX, laMpSnSg
	SUB   DX, FS: WORD PTR [EBX +2] ; iSn = iSn - iSnFirst
	CMP   DX, FS: WORD PTR [EBX] ; iSn > cSn?
	JB	  SnInRange
	CALL  ReturnCrazyFixup ; never returns

SnInRange:
	SHL   DX, 1
	ADD   EBX, EDX
	MOV   DX, FS: WORD PTR [EBX + 4]
	POP   EBX
	RET
LookupSg ENDP


; LoadUserLdtr: PROCEDURE (wLdtr) PUBLIC REENTRANT
PUBLIC LoadUserLdtr
LoadUserLdtr PROC FAR
tss_ldtr	EQU 60h
	PUSH  BP
	MOV   BP, SP
	MOV   AX, WORD PTR [BP+6]
$MOD386
	STR   BX
	SUB   BX, 8
	MOV   ES, BX
	MOV   ES: WORD PTR [tss_ldtr], AX
	LLDT  AX
$MOD186
	POP   BP
	RET   2
LoadUserLdtr ENDP



; AliasRfe: PROCEDURE (sg, tyRfe) PUBLIC REENTRANT
;   make an alias for a run file element
PUBLIC AliasRfe
AliasRfe PROC FAR
tyRfe 		EQU BYTE PTR [BP+6]
sg   		EQU WORD PTR [BP+8]
run_rgRfe	EQU 50h

ASSUME DS:Dgroup

	PUSH  BP
	MOV   BP, SP
	LES   BX, DWORD PTR [pRun]
	ADD   BX, run_rgRfe
; ES:BX -> run.rgRfe
	MOV   AL, tyRfe
	MOV   DL, sRfe
	MUL   DL
	ADD   BX, AX
; ES:BX -> run.rgRfe(tyRfe)
$MOD386
	MOV   ECX, ES:DWORD PTR [BX + rfe_cpar]
	OR	  ECX, ECX		; 12.1 assembler doesn't do JECXZ properly
	JZ	  AliasRfeErc
	SHL	  ECX, 4
	MOV   EDX, ES:DWORD PTR [BX + rfe_pla]
	ADD   EDX, DWORD PTR [plaDir]
	SHL	  EDX, 4
; EDX = la, ECX = limit

	MOV   SI, sg
	MOV   AX, sgGdt
	MOV   ES, AX
	PUSH  EDX
$MOD186
	POP   AX
	POP   DX
	MOV   ES: WORD PTR [SI+desc_laLow], AX
	MOV   ES: BYTE PTR [SI+desc_laMid], DL
	MOV   ES: BYTE PTR [SI+desc_laHi], DH
	MOV   ES: WORD PTR [SI+desc_limit], CX
	MOV   ES: BYTE PTR [SI+desc_bAcc], 92h	; writableData
	XOR   AX, AX
AliasRfeRet:
	POP   BP
	RET   4
AliasRfeErc:
	MOV   AX, 246	;ercBadRunFile 	
	JMP   AliasRfeRet
AliasRfe ENDP


; AliasImpLib: PROCEDURE (sg, iLib) PUBLIC REENTRANT
;   make an alias for nth implib structure of run file
PUBLIC AliasImpLib
AliasImpLib PROC FAR
iLib 		EQU WORD PTR [BP+6]
sg   		EQU WORD PTR [BP+8]
lIib		EQU 10
iib_cLib	EQU 0

ASSUME DS:Dgroup

	PUSH  BP
	MOV   BP, SP
	PUSH  sg
	PUSH  lIib
	CALL  AliasRfe
	
	MOV   SI, sg
	MOV   ES, SI
	MOV   BX, iLib
	CMP   BX, ES: WORD PTR [iib_cLib]
	JB    iLibOk
	PUSH  ercInconsistency
	CALL  Crash
iLibOk:
	SHL   BX, 2
	MOV   CX, ES:WORD PTR [BX+2]
	MOV   DI, ES:WORD PTR [BX+4]
; CX,DI = iib.rgqImpLib(iLib)
	MOV   AX, sgGdt
	MOV   ES, AX
	MOV   AX, ES: WORD PTR [SI+desc_laLow]
	MOV   DL, ES: BYTE PTR [SI+desc_laMid]
	MOV   DH, ES: BYTE PTR [SI+desc_laHi]
	ADD   AX, CX
	ADC   DX, DI
; AX,DX = laImpLib
	MOV   ES: WORD PTR [SI+desc_laLow], AX
	MOV   ES: BYTE PTR [SI+desc_laMid], DL
	MOV   ES: BYTE PTR [SI+desc_laHi], DH
	POP   BP
	RET   4
AliasImpLib ENDP


;
; FChecksum: (pla, cPar, qChecksum) FLAG PUBLIC REENTRANT
;
$MOD386
FChecksum	PROC	FAR
PUBLIC FChecksum
qChecksum	EQU DWORD PTR [BP+6]
cPar		EQU DWORD PTR [BP+10]
plaLow		EQU WORD PTR [BP+14]
plaHi		EQU WORD PTR [BP+16]
ASSUME DS: DGroup
	PUSH BP
	MOV  BP, SP

	CMP  cPar, 0
	JE   @20
	MOV  AX, plaLow
	MOV  DX, plaHi
	MOV  CX, 4
MakeLaFromPla:
	SHL  AX, 1
	RCL  DX, 1
	LOOP MakeLaFromPla	

; make alias descriptor 
	MOV  BX, sgGdt
	MOV  ES, BX
	MOV  BX, sgTmp
	AND  BX, 0fff8h
	MOV  ES:WORD PTR [BX], 0ffffh	; limit 0ffffh*4k
	MOV  ES:WORD PTR [BX+2], AX		; plaLow
	MOV  ES:BYTE PTR [BX+4], DL 	; plaMid
	MOV  ES:BYTE PTR [BX+7], DH		; plaHi
	MOV  ES:BYTE PTR [BX+6], 80h  	; 4K granular 
	MOV  ES:BYTE PTR [BX+5], 92h	; access = writable data

	MOV  ES, BX	
	XOR  EAX, EAX
	XOR  ESI, ESI
	MOV  ECX, cPar
@10:
	ADD  EAX, ES:DWORD PTR [ESI]
	ADD  EAX, ES:DWORD PTR [ESI+4]
	ADD  EAX, ES:DWORD PTR [ESI+8]
	ADD  EAX, ES:DWORD PTR [ESI+12]
	ADD  ESI, 10h
	DB   67h	; loop on ecx
	LOOP @10
	CMP  EAX, qChecksum
	MOV  AX, 0
	JNE	 @30
@20:
	MOV  AX, 1
@30:
	POP  BP
	RET  12
FChecksum	ENDP
$MOD186


FixupCode ENDS

END

;
; Modification history:
;
;	12/7/89  JM created
;	02/14/90 JM page boundary fixups
;	04/18/90 DR use sgZero and descriptors.mdf
;	08/02/90 JM check for bogus iProc in LookupExport.
;	09/07/90 JM fix dword math bug in AliasImpLib
;	11/12/90 JM handle ra-only and sa-only import fixups.
;	01/13/91 JM obsolete BindError.
;	05/13/91 JM AliasRfe returns erc.
;	07/08/91 JM Allow unresolved externals: LookupSg handles nil selectors.
;	09/25/91 JM log errors.


