/***
*termios.h - function declarations for terminal handling
*
*	Copyright 1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This include file contains the function declarations for the library
*	functions related to terminal handling.
*	[POSIX]
*
****/

#if !defined(_TERMIOS_DEFINED) && defined(_POSIX_SOURCE)

#define _TERMIOS_DEFINED

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif


#define NCCS 24

/* terminal structures */

typedef unsigned long tcflag_t;
typedef unsigned char cc_t;
typedef tcflag_t      speed_t;

struct termios {
	tcflag_t c_iflag;
	tcflag_t c_oflag;
	tcflag_t c_cflag;
	tcflag_t c_lflag;
	signed int c_line;
	cc_t c_cc[NCCS];
	};

#define TCSANOW   0
#define TCSADRAIN 1
#define TCSAFLUSH 2

#define TCIFLUSH  0x01
#define TCOFLUSH  0x02
#define TCIOFLUSH (TCIFLUSH | TCOFLUSH)
#define TCOOFF    0x04
#define TCOON     0x08
#define TCIOFF    0x10
#define TCION     0x20

#define VINTR     0
#define VQUIT     1
#define VERASE    2
#define VKILL     3
#define VEOF      4
#define VEOL      5
#define VEOL2     6
#define VSUSP     7
#define VSTOP     8
#define VSTART    9
#define VMIN     10
#define VTIME    11
#define VREPRINT 12
#define VDISCARD 13
#define VWERASE  14
#define VLNEXT   15

#define CINTR    ((cc_t) 0x7F)		/* Delete */
#define CQUIT    ((cc_t) 0xDC)		/* Code \ */
#define CERASE   ((cc_t) 0x08)		/* Back Space */
#define CKILL    ((cc_t) 0x07)		/* Cancel */
#define CEOF     ((cc_t) 0xE4)		/* Code d */
#define CEOL     ((cc_t) _POSIX_VDISABLE)
#define CEOL2    ((cc_t) _POSIX_VDISABLE)
#define CSUSP    ((cc_t) 0xFA)		/* Code z */
#define CSTOP    ((cc_t) 0x13)		/* XOFF */
#define CSTART   ((cc_t) 0x11)		/* XON */
#define CMIN     ((cc_t) 0)
#define CTIME    ((cc_t) 0)
#define CREPRINT ((cc_t) 0xF2)		/* Code r */
#define CDISCARD ((cc_t) 0xEF)		/* Code o */
#define CWERASE  ((cc_t) 0x88)		/* Code Back Space */
#define CLNEXT   ((cc_t) 0xA7)		/* Code ' */

#define IGNBRK ((tcflag_t) 0x0001)
#define BRKINT ((tcflag_t) 0x0002)
#define IGNPAR ((tcflag_t) 0x0004)
#define PARMRK ((tcflag_t) 0x0008)
#define INPCK  ((tcflag_t) 0x0010)
#define ISTRIP ((tcflag_t) 0x0020)
#define INLCR  ((tcflag_t) 0x0040)
#define IGNCR  ((tcflag_t) 0x0080)
#define ICRNL  ((tcflag_t) 0x0100)
#define IUCLC  ((tcflag_t) 0x0200)
#define IXON   ((tcflag_t) 0x0400)
#define IXANY  ((tcflag_t) 0x0800)
#define IXOFF  ((tcflag_t) 0x1000)

#define OPOST  ((tcflag_t) 0x0001)
#define OLCUC  ((tcflag_t) 0x0002)
#define ONLCR  ((tcflag_t) 0x0004)
#define OCRNL  ((tcflag_t) 0x0008)
#define ONOCR  ((tcflag_t) 0x0010)
#define ONLRET ((tcflag_t) 0x0020)
#define OFILL  ((tcflag_t) 0x0040)
#define OFDEL  ((tcflag_t) 0x0080)
#define NL0    ((tcflag_t) 0)
#define NL1    ((tcflag_t) 0x0100)
#define NLDLY  (NL0 | NL1)
#define CR0    ((tcflag_t) 0)
#define CR1    ((tcflag_t) 0x0200)
#define CR2    ((tcflag_t) 0x0400)
#define CR3    (CR1 | CR2)
#define CRDLY  (CR0 | CR1 | CR2 | CR3)
#define TAB0   ((tcflag_t) 0)
#define TAB1   ((tcflag_t) 0x0800)
#define TAB2   ((tcflag_t) 0x1000)
#define TAB3   (TAB1 | TAB2)
#define TABDLY (TAB0 | TAB1 | TAB2 | TAB3)
#define BS0    ((tcflag_t) 0)
#define BS1    ((tcflag_t) 0x2000)
#define BSDLY  (BS0 | BS1)
#define VT0    ((tcflag_t) 0)
#define VT1    ((tcflag_t) 0x4000)
#define VTDLY  (VT0 | VT1)
#define FF0    ((tcflag_t) 0)
#define FF1    ((tcflag_t) 0x8000)
#define FFDLY  (FF0 | FF1)

#define B0         ((tcflag_t) 0)
#define B50        ((tcflag_t) 0x00000001)
#define B75        ((tcflag_t) 0x00000002)
#define B110       ((tcflag_t) 0x00000003)
#define B134       ((tcflag_t) 0x00000004)
#define B150       ((tcflag_t) 0x00000005)
#define B200       ((tcflag_t) 0x00000006)
#define B300       ((tcflag_t) 0x00000007)
#define B600       ((tcflag_t) 0x00000008)
#define B1200      ((tcflag_t) 0x00000009)
#define B1800      ((tcflag_t) 0x0000000A)
#define B2400      ((tcflag_t) 0x0000000B)
#define B4800      ((tcflag_t) 0x0000000C)
#define B9600      ((tcflag_t) 0x0000000D)
#define B19200     ((tcflag_t) 0x0000000E)
#define B38400     ((tcflag_t) 0x0000000F)
#define CBAUDO     (B0 | B50 | B75 | B110 | B134 | B150 | B200 | B300 | \
	B600 | B1200 | B1800 | B2400 | B4800 | B9600 | B19200 | B38400)
#define CBAUDISHFT 13
#define CBAUDI     (CBAUDO << CBAUDISHFT)
#define CBAUD      CBAUDO
#define EXTA       B19200
#define EXTB       B38400
#define CS5        ((tcflag_t) 0)
#define CS6        ((tcflag_t) 0x00000010)
#define CS7        ((tcflag_t) 0x00000020)
#define CS8        (CS6 | CS7)
#define CSIZE      (CS5 | CS6 | CS7 | CS8)
#define CSTOPB     ((tcflag_t) 0x00000040)
#define CREAD      ((tcflag_t) 0x00000080)
#define PARENB     ((tcflag_t) 0x00000100)
#define PARODD     ((tcflag_t) 0x00000200)
#define HUPCL      ((tcflag_t) 0x00000400)
#define CLOCAL     ((tcflag_t) 0x00000800)
#define LOBLK      ((tcflag_t) 0x00001000)
#define CRTSCTS    ((tcflag_t) 0x00020000)

#define ISIG    ((tcflag_t) 0x0001)
#define ICANON  ((tcflag_t) 0x0002)
#define XCASE   ((tcflag_t) 0x0004)
#define ECHO    ((tcflag_t) 0x0008)
#define ECHOE   ((tcflag_t) 0x0010)
#define ECHOK   ((tcflag_t) 0x0020)
#define ECHONL  ((tcflag_t) 0x0040)
#define NOFLSH  ((tcflag_t) 0x0080)
#define TOSTOP  ((tcflag_t) 0x0100)
#define IEXTEN  ((tcflag_t) 0x0200)
#define ECHOCTL ((tcflag_t) 0x0400)


/* function prototypes */

extern signed int _FAR_ _cdecl cfsetospeed(struct termios _FAR_ *, speed_t);
extern speed_t    _FAR_ _cdecl cfgetospeed(const struct termios _FAR_ *);
extern signed int _FAR_ _cdecl cfsetispeed(struct termios _FAR_ *, speed_t);
extern speed_t    _FAR_ _cdecl cfgetispeed(const struct termios _FAR_ *);
extern signed int _FAR_ _cdecl tcgetattr(signed int, struct termios _FAR_ *);
extern signed int _FAR_ _cdecl tcflush(signed int, signed int);
extern signed int _FAR_ _cdecl tcflow(signed int, signed int);
extern signed int _FAR_ _cdecl tcsetattr(signed int, signed int,
	const struct termios _FAR_ *);
extern signed int _FAR_ _cdecl tcdrain(signed int);
extern signed int _FAR_ _cdecl tcsendbreak(signed int, signed int);

#endif /* !_TERMIOS_DEFINED && _POSIX_SOURCE */
