/***
*math.h - definitions and declarations for math library
*
*	Copyright 1985-1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file contains constant definitions and external subroutine
*	declarations for the math subroutine library.
*	[POSIX/ANSI/System V]
*
****/

#if !defined(_MATH_DEFINED)

#define _MATH_DEFINED

#include <errno.h>

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif


/* definition of exception struct - this struct is passed to the matherr
 * routine when a floating point exception is detected
 */

struct exception {
	signed int type;	/* exception type - see below */
	char _FAR_ *name;	/* name of function where error occured */
	double arg1;		/* first argument to function */
	double arg2;		/* second argument (if any) to function */
	double retval;		/* value to be returned by function */
	};


/* definition of a complex struct to be used by those who use cabs and
 * want type checking on their argument
 */

struct complex {
	double x, y;	/* real and imaginary parts */
	};


/* Constant definitions for the exception type passed in the exception struct
 */

#define DOMAIN		1	/* argument domain error */
#define SING		2	/* argument singularity */
#define OVERFLOW	3	/* overflow range error */
#define UNDERFLOW	4	/* underflow range error */
#define TLOSS		5	/* total loss of precision */
#define PLOSS		6	/* partial loss of precision */


/* definitions of HUGE and HUGE_VAL - respectively the XENIX and ANSI names
 * for a value returned in case of error by a number of the floating point
 * math routines
 */

#if !defined(_DLL)
extern double _near _cdecl _HUGE;
#else	/* _DLL */
extern double _FAR_ _cdecl _HUGE;
#endif	/* _DLL */
#if !defined(_POSIX_SOURCE)
#define HUGE _HUGE
#endif
#define HUGE_VAL _HUGE


/* function prototypes */

#if defined(_MT)    /* function prototypes for _MT version */
extern signed int  _FAR_ _cdecl  abs(signed int);
extern double      _FAR_ _pascal acos(double);
extern double      _FAR_ _pascal asin(double);
extern double      _FAR_ _pascal atan(double);
extern double      _FAR_ _pascal atan2(double, double);
extern double      _FAR_ _pascal atof(const char _FAR_ *);
extern double      _FAR_ _pascal cabs(struct complex);
extern double      _FAR_ _pascal ceil(double);
extern double      _FAR_ _pascal cos(double);
extern double      _FAR_ _pascal cosh(double);
extern signed int  _FAR_ _cdecl  dieeetomsbin(double _FAR_ *, double _FAR_ *);
extern signed int  _FAR_ _cdecl  dmsbintoieee(double _FAR_ *, double _FAR_ *);
extern double      _FAR_ _pascal exp(double);
extern double      _FAR_ _pascal fabs(double);
extern signed int  _FAR_ _cdecl  fieeetomsbin(float _FAR_ *, float _FAR_ *);
extern double      _FAR_ _pascal floor(double);
extern double      _FAR_ _pascal fmod(double, double);
extern signed int  _FAR_ _cdecl  fmsbintoieee(float _FAR_ *, float _FAR_ *);
extern double      _FAR_ _pascal frexp(double, signed int _FAR_ *);
extern double      _FAR_ _pascal hypot(double, double);
extern double      _FAR_ _pascal j0(double);
extern double      _FAR_ _pascal j1(double);
extern double      _FAR_ _pascal jn(signed int, double);
extern signed long _FAR_ _cdecl  labs(signed long);
extern double      _FAR_ _pascal ldexp(double, signed int);
extern double      _FAR_ _pascal log(double);
extern double      _FAR_ _pascal log10(double);
extern signed int  _FAR_ _cdecl  matherr(struct exception _FAR_ *);
extern double      _FAR_ _pascal modf(double, double _FAR_ *);
extern double      _FAR_ _pascal pow(double, double);
extern double      _FAR_ _pascal sin(double);
extern double      _FAR_ _pascal sinh(double);
extern double      _FAR_ _pascal sqrt(double);
extern double      _FAR_ _pascal tan(double);
extern double      _FAR_ _pascal tanh(double);
extern double      _FAR_ _pascal y0(double);
extern double      _FAR_ _pascal y1(double);
extern double      _FAR_ _pascal yn(int, double);

#else		/* function prototypes for non _MT version */
extern signed int  _FAR_ _cdecl abs(signed int);
extern double      _FAR_ _cdecl acos(double);
extern double      _FAR_ _cdecl asin(double);
extern double      _FAR_ _cdecl atan(double);
extern double      _FAR_ _cdecl atan2(double, double);
extern double      _FAR_ _cdecl atof(const char _FAR_ *);
extern double      _FAR_ _cdecl cabs(struct complex);
extern double      _FAR_ _cdecl ceil(double);
extern double      _FAR_ _cdecl cos(double);
extern double      _FAR_ _cdecl cosh(double);
extern signed int  _FAR_ _cdecl dieeetomsbin(double _FAR_ *, double _FAR_ *);
extern signed int  _FAR_ _cdecl dmsbintoieee(double _FAR_ *, double _FAR_ *);
extern double      _FAR_ _cdecl exp(double);
extern double      _FAR_ _cdecl fabs(double);
extern signed int  _FAR_ _cdecl fieeetomsbin(float _FAR_ *, float _FAR_ *);
extern double      _FAR_ _cdecl floor(double);
extern double      _FAR_ _cdecl fmod(double, double);
extern signed int  _FAR_ _cdecl fmsbintoieee(float _FAR_ *, float _FAR_ *);
extern double      _FAR_ _cdecl frexp(double, signed int _FAR_ *);
extern double      _FAR_ _cdecl hypot(double, double);
extern double      _FAR_ _cdecl j0(double);
extern double      _FAR_ _cdecl j1(double);
extern double      _FAR_ _cdecl jn(signed int, double);
extern signed long _FAR_ _cdecl labs(signed long);
extern double      _FAR_ _cdecl ldexp(double, signed int);
extern double      _FAR_ _cdecl log(double);
extern double      _FAR_ _cdecl log10(double);
extern signed int  _FAR_ _cdecl matherr(struct exception _FAR_ *);
extern double      _FAR_ _cdecl modf(double, double _FAR_ *);
extern double      _FAR_ _cdecl pow(double, double);
extern double      _FAR_ _cdecl sin(double);
extern double      _FAR_ _cdecl sinh(double);
extern double      _FAR_ _cdecl sqrt(double);
extern double      _FAR_ _cdecl tan(double);
extern double      _FAR_ _cdecl tanh(double);
extern double      _FAR_ _cdecl y0(double);
extern double      _FAR_ _cdecl y1(double);
extern double      _FAR_ _cdecl yn(signed int, double);
#endif


/* definition of _exceptionl struct - this struct is passed to the _matherrl
 * routine when a floating point exception is detected in a long double routine
 */

struct _exceptionl {
	signed int type;	/* exception type - see below */
	char _FAR_ *name;	/* name of function where error occured */
	long double arg1;	/* first argument to function */
	long double arg2;	/* second argument (if any) to function */
	long double retval;	/* value to be returned by function */
	};


/* definition of a _complexl struct to be used by those who use _cabsl and
 * want type checking on their argument
 */

struct _complexl {
	long double x, y;	/* real and imaginary parts */
	};


#if !defined(_DLL)
extern long double _near _cdecl _LHUGE;
#define _LHUGE_VAL _LHUGE

#else	/* _DLL */
extern long double _FAR_ _cdecl _LHUGE;
#define _LHUGE_VAL _LHUGE

#endif	/* _DLL */

extern long double _FAR_ _cdecl acosl(long double);
extern long double _FAR_ _cdecl asinl(long double);
extern long double _FAR_ _cdecl atanl(long double);
extern long double _FAR_ _cdecl atan2l(long double, long double);
extern long double _FAR_ _cdecl _atold(const char _FAR_ *);
extern long double _FAR_ _cdecl cabsl(struct _complexl);
extern long double _FAR_ _cdecl ceill(long double);
extern long double _FAR_ _cdecl cosl(long double);
extern long double _FAR_ _cdecl coshl(long double);
extern long double _FAR_ _cdecl expl(long double);
extern long double _FAR_ _cdecl fabsl(long double);
extern long double _FAR_ _cdecl floorl(long double);
extern long double _FAR_ _cdecl fmodl(long double, long double);
extern long double _FAR_ _cdecl frexpl(long double, signed int _FAR_ *);
extern long double _FAR_ _cdecl hypotl(long double, long double);
extern long double _FAR_ _cdecl _j0l(long double);
extern long double _FAR_ _cdecl _j1l(long double);
extern long double _FAR_ _cdecl _jnl(int, long double);
extern long double _FAR_ _cdecl ldexpl(long double, signed int);
extern long double _FAR_ _cdecl logl(long double);
extern long double _FAR_ _cdecl log10l(long double);
extern signed int  _FAR_ _cdecl _matherrl(struct _exceptionl _FAR_ *);
extern long double _FAR_ _cdecl modfl(long double, long double _FAR_ *);
extern long double _FAR_ _cdecl powl(long double, long double);
extern long double _FAR_ _cdecl sinl(long double);
extern long double _FAR_ _cdecl sinhl(long double);
extern long double _FAR_ _cdecl sqrtl(long double);
extern long double _FAR_ _cdecl tanl(long double);
extern long double _FAR_ _cdecl tanhl(long double);
extern long double _FAR_ _cdecl _y0l(long double);
extern long double _FAR_ _cdecl _y1l(long double);
extern long double _FAR_ _cdecl _ynl(signed int, long double);

#endif /* !_MATH_DEFINED */
