;################################################################
; File GenSyncRequest.0.Asm
;
; These macros construct tables which are used by CTOS
; to route requests to installable system services. When a new
; request needs to be in a loadable request file, an entry
; has to be added using the macro "Request".  Request codes have
; to be within 1000h - FFDFh. Only request beginning with an even
; hex digit may have entries in the (format) field.
; The "requestNumber" field is used by the macro just to verify
; the contiguousness of the requests.
; New requests may also be added using
; the "UsrRequest" declarations which preceed the "Request"'s.
; "UsrRequest"'s are loadable only if CTOS is built with
; SET (fCheckRequestBlockConsistency, FALSE) in the sysgen prefix
; file for that OS.
;
$INCLUDE(<Gen>Request.Mdf)
%' REQUEST MACRO DEFINITION --
%'
%'  MACRO FORMAT --
%'	The "Request" macro takes 9 arguments which are
%' described below.  The first 7 arguments must be on the same
%' line, and the last two arguments, the parameter format
%' and the net routing code, can be on
%' additional lines.  A full description of the fields of the
%' macro and their use can be found in the CTOS manual and in
%' the System Programmers Guide.  The macro arguments are
%' defined as follows:
%'
%'   %Request(
%'	 rqCode ....... The request number of the service
%'			interface.  These numbers must be in
%'			order with no omissions.
%'	,name ......... The name of the procedure.  This field
%'			is here for convenience only and is not
%'			used internally by the macro.
%'	,exchange ..... This is the CTOS exchange that the
%'			request will be routed to by the
%'			Request interface.
%'	,ServiceCode .. This field is for the convenience of
%'			the Service process, and can be used in
%'			any way the process desires.
%'	,sCntInfo ..... 
%'	,nReqPbCb ..... 
%'	,nRespPbCb .... These values are put into the request
%'			block which the CTOS procedural
%'			interface creates for the user in the
%'			fields of the same name.
%'	, %( format ) . The "format" is described in the
%'			following section.
%'	, %( netRouting ) . The "netRouting" is described in the
%'			following section.
%'	)
%'
%' FORMAT --
%'	The format is a set of short macros which define the
%' order and type of arguments that are pushed onto the stack
%' when a user calls the CTOS procedural interface.  Also in
%' the "format" are any constants which go into the request
%' block.  The CTOS procedural initializes the request block to
%' zeros, so any zero constants may be omitted.  The macros are
%' defined as follows:
%'
%'  name:	    meaning:
%'	%illegal ...... call to this request is an error.
%'	%none ......... no arguments on stack (this call is
%'			optional).
%'	%c(v,o) ....... byte value "v" is placed in request
%'			block at offset "o" in the request
%'			block.
%'	%w(o) ......... the next word on the stack goes at
%'			offset "o".
%'	%b(o) ......... the low byte of next word on stack goes
%'			 at offset "o"
%'
%' For convenience, the following abbreviations are also defined:
%'
%'  abbreviation:  definition:
%'	%fh .......... %w(12)
%'	%lfa ......... %w(16) %w(14)
%'	%p(o) ........ %w(o+2) %w(o)
%'	%p0 .......... %w(20) %w(18)
%'	%s0 .......... %w(22)
%'	%p1 .......... %w(26) %w(24)
%'	%s1 .......... %w(28)
%'	%p2 .......... %w(32) %w(30)
%'	%s2 .......... w(34)
%'	%p3 .......... %w(38) %w(36)
%'
%' NET ROUTING --
%' The table rgNetRouting is used by the CTOS Kernel to decide whether a 
%' request gets routed by file handle, by file spec, or not at all. 
%' It is also used by the Agent to determine how to expand file specs.
%' The following is a set of general rules for request blocks that have
%' file specs. These rules permit routing information to be encoded.
%'
%'	1. A request may not have more than two file specs.
%'	2. The first file spec must be specified by the first pb/cb pair.
%'	3. If a file spec has a password, it must be specified by the pb/cb
%'		pair that immediately follows the pb/cb for the file spec.
%'	4. If one file spec has a password associated with it, then
%'		all file specs in the request must have passwords.
%'
%'	%RW		This request is a read or write and may have to be
%'			be broken up in to smaller requests.
%'	%ESC	This request does not follow the rules above, and must be
%'			handled seperately (e.g., SpoolerPassword).
%'	%SpecPW	All file spec pb/cb pairs are followed by password pb/cb pairs.
%'	%rFh	Route this request by the file handle.
%'	%DevSpec	Route this request by div spec
%'	%DirSpec	Route this request by dir Spec
%'	%FileSpec	Route this request by file spec
%'	%FileSpec2	Route this request by file spec (request has 2 of them)
%'	%FileSpecP2S2	Route by file spec in p2/s2
;################################################################
;
; Exchange definitions --
;	Exchanges 0 to 27 are reserved for CTOS processes.
;
; Virtual exchanges, replaced at boot time.
;  Translation table created in Sysgen.Mdf,
;  varies with CTOS version.
    exchAgent	EQU  -1
    exchNotInstalled EQU  -2
    exchMassIO	EQU  -3		; Mass storage I/O manager
    exchFilSys1	EQU  -4		; File system manager/ Utility
    exchFilSys2	EQU  -5
    exchFilSys3	EQU  -6
    exchFilSys4	EQU  -7
    exchChgUsrN	EQU  -8		; Multi-Part Change User Num Rq for FS
    exchSrpAgent EQU -9
    exchLog	EQU  -10
;
; Exchanges constant over all versions of CTOS,
;  or equated to virtual exchanges.
    exchISAM	EQU  exchNotInstalled	; ISAM service
    exchDBMS	EQU  exchNotInstalled	; DBMS service
    exch3270	EQU  exchNotInstalled	; 3270
    exchKbd	EQU  1		; Keyboard manager/ Debugger
    exchSysIn	EQU  3		; System Input proccess
    exchTerm	EQU  5		; Application terminator
    exchLclFs	EQU 10		; File system manager/ Utility
    exchSplr	EQU  0		; Print Spooler
    exchSplrOld	EQU  exchNotInstalled	; Print Spooler
    exchQueMgr	EQU  exchNotInstalled   ; Queue Manager
    exchRJE	EQU  exchNotInstalled   ; RJE
    exchResex	EQU exchLclFs
    exchTask	EQU exchLclFs
    exchVideo	EQU exchLclFs
    exchCommSer	EQU exchNotInstalled
    exchTape	EQU exchNotInstalled	; Tape Server
    exchX25	EQU exchNotInstalled	; X.25
    exchSNA     EQU exchNotInstalled	; SNA
    exchMailSer EQU exchNotInstalled	; Mail Server

%'	SYSREQUEST ENTRIES MUST COME FIRST,
%'	NO ENTRIES ALLOWED IN LOADABLE REQUEST LEVEL FILES.

%SysRequestInit
%'	LOADABLE USER REQUESTS COME NEXT
%'	WITHIN EACH LEVEL REQUESTS MUST BE IN NUMERIC ORDER

%UsrRequestInit

; Request 4000h is included only as an example of a loadable user request,
; and is "commented out".
;
%'  %Request(4000h,Rq4000,0,0h,4,1,1,
%'		%( %p(12) %w(16) %p(18) %w(22) ),
%'		%( %noRouting )) 
%'

%Request(8000h,AbortGenSync,exchNotInstalled,0000h,2,0,0,
		%( %w(12) ),
		%( %noRouting ))

%Request(8001h,ChgUserNumGenSync,exchNotInstalled,0000h,2,0,0,
		%( %w(12) ),
		%( %noRouting ))

%Request(8002h,SwappingGenSync,exchNotInstalled,0000h,2,0,0,
		%( %w(12) ),
		%( %noRouting ))

%Request(8003h,OpenGenSync,exchNotInstalled,0000h,6,3,1,
		%( %p0 %c(32,22) %pbcb1 %pbcb2 %w(12) %w(14) %w(16) %p3
		   %c(2,40) ),
		%( %noRouting ))

%Request(8004h,CloseGenSync,exchNotInstalled,0000h,2,0,0,
		%( %w(12) ),
		%( %noRouting ))

%Request(8005h,ReadGenSync,exchNotInstalled,0000h,6,0,2,
		%( %w(12) %pbcb0 %p1 %c(2,28) %w(14) %w(16) ),
		%( %noRouting ))

%Request(8006h,WriteGenSync,exchNotInstalled,0000h,6,1,1,
		%( %w(12) %pbcb0 %p1 %c(2,28) %w(14) %w(16) ),
		%( %noRouting ))

%Request(8007h,DeinstalllGenSync,exchNotInstalled,0000h,0,0,0,
		%( ),
		%( %noRouting ))

%Request(8008h,StatusGenSync,exchNotInstalled,0000h,6,0,1,
		%( %w(12) %p0 %c(2,22) ),
		%( %noRouting ))

%Request(8009h,ControlGenSync,exchNotInstalled,0000h,6,0,0,
		%( %w(12) %w(14)),
		%( %noRouting ))
EVEN
; Requests issued by the OS on behalf of applications may be load.
; Requests of a given class (term, abort etc) must be listed together.
; However, requests need not be listed by level or number.
; Requests within a class may not be issued in the order listed when
; .
;
; The list of request codes which the CTOS termination process
; issues to quiet the process activities during subsystem
; termination (invoked with "Exit" or "Chain").  The requests
; are generated with no arguments and with request numbers as
; given to the macro.
;

%TerminationRequest(8000h)	;AbortGenSync
EVEN
;
;  The list of request codes which the CTOS master workstation
;  agent or the CtNetServer issues on behalf of cluster workstation
;  when the master or the CtNetServer determines that a cluster
;  workstation is not communicating with it any more.
;

%WsAbortRequest(8000h)		;AbortGenSync
EVEN
;
;  The list of request codes which a Multi-Partitioned CTOS
;  issues on behalf of a system service to notify other system
;  services its user number is changing. These requests are
;  issued when the system service does a ConvertToSys request.
;  The system service's new user number is contained in a word
;  at offset 4 in the request block. The system service's
;  previous user number is contained in a word at offset 12 in
;  the request block.
;

%ChgUserNumRequest(8001h)	;ChgUserNumGenSync
;
; The list of request codes which the CTOS termination process
; issues to quiet the process activities before subsystem
; swap-out (invoked with "SuspendContext").  The requests
; are generated with no arguments and with request numbers as
; given to the macro.
;

%'%SwappingRequest(8002h)		;SwappingGenSync

%final

END
