;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: Request.asm                                                         *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: CTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;* Request codes for the Operating System (with procedural interface)        *;
;*                                                                           *;
;* Although a system builder may replace a request definition with one of    *;
;* their own, adding new requests is not allowed here, as this may conflict  *;
;* with future OS requests.  New requests should be added using the loadable *;
;* request facility as described in the CTOS System Programmers Guide.       *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;*                                                                           *;
;*                                                                           *;
;* TITLE:  CTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1990 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED     *;
;* COPYRIGHT (C) 1980, 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;
;
; NOTES FOR CHANGING THIS FILE --
;
; Please be aware that in Assembly language
; there are two types of comments: normal comments (any text on
; a line after a ";" character, and a macro comment (%' text ').
; It is not possible to "comment out" a macro by inserting a
; ";" in front of it.  You may comment out a macro by replacing
; the percent sign in the call with a ";", or by precceding the
; call with "%'".  This will cause the macro processor to
; ignore any text up to and including the next "'" or RETURN
; (0Ah) character,whichever comes first.
;
; Macro calls must not be mixed.  In general,the invocation of
; a macro causes an entry to be added to a table,and mixing
; macro calls would result in scrambled tables.
;
$INCLUDE (Request.Mdf)

;
; The next set of macros construct tables which are used
; to implement OS service request. When a new request code
; is added to the OS, a new entry has to be added using the
; macros "SysRequest", "UsrRequest" or "Request".
; "SysRequest" codes have to be within 0 - 4095 (0FFFh) and
; contiguous.  "UsrRequest" codes have to be within -1 - -32
; (0FFFFh - 0FFE0h) and contiguous.  "Request" is used for codes
; in any range of 4096 starting with 4096 (1000h - 1FFFh,
; 2000h - 2FFFh, ..., 0E000h - 0EFFFh, 0F000h - 0FFDFh) and must
; be contiguous within each range.  The "requestNumber" field is
; used by the macros just to verify the contiguousness of the
; requests.  


%' SYSREQUEST MACRO DEFINITION --
%'
%'  MACRO FORMAT --
%'	The "SysRequest" macro takes 10 arguments which are
%' described below.  The first 7 arguments must be on the same
%' line, and the last three arguments, the parameter format,
%' the Srp routing code and the net routing code, can be on
%' additional lines.  A full description of the fields of the
%' macro and their use can be found in the CTOS manual and in
%' the System Programmers Guide.  The macro arguments are
%' defined as follows:
%'
%'   %SysRequest(
%'	 rqCode ....... The request number of the service
%'			interface.  These numbers must be in
%'			order with no omissions.
%'	,name ......... The name of the procedure.  This field
%'			is here for convenience only and is not
%'			used internally by the macro.
%'	,exchange ..... This is the CTOS exchange that the
%'			request will be routed to by the
%'			Request interface.
%'	,ServiceCode .. This field is for the convenience of
%'			the Service process, and can be used in
%'			any way the process desires.
%'	,sCntInfo .....
%'	,nReqPbCb .....
%'	,nRespPbCb .... These values are put into the request
%'			block which the CTOS procedural
%'			interface creates for the user in the
%'			fields of the same name.
%'	, %( format ) . The "format" is described in the
%'			following section.
%'	, %( netRouting ) . The "netRouting" is described in the
%'			following section.
%'	, %( srpRouting ) . The "srpRouting" is described in the
%'			following section.
%'	)
%'
%' FORMAT --
%'	The format is a set of short macros which define the
%' order and type of arguments that are pushed onto the stack
%' when a user calls the CTOS procedural interface.  Also in
%' the "format" are any constants which go into the request
%' block.  The CTOS procedural initializes the request block to
%' zeros, so any zero constants may be omitted.  The macros are
%' defined as follows:
%'
%'  name:           meaning:
%'	%illegal ...... call to this request is an error.
%'	%none ......... no arguments on stack (this call is
%'			optional).
%'	%c(v,o) ....... byte value "v" is placed in request
%'			block at offset "o" in the request
%'			block.
%'	%w(o) ......... the next word on the stack goes at
%'			offset "o".
%'	%b(o) ......... the low byte of next word on stack goes
%'			 at offset "o"
%'
%' For convenience, the following abbreviations are also defined:
%'
%'  abbreviation:  definition:
%'	%fh .......... %w(12)
%'	%ph .......... %w(12)
%'	%lfa ......... %w(16) %w(14)
%'	%p(o) ........ %w(o+2) %w(o)
%'	%d(o) ........ %w(o+2) %w(o)
%'	%pbCb0 ....... %w(20) %w(18) %w(22)
%'	%p0 .......... %w(20) %w(18)
%'	%s0 .......... %w(22)
%'	%pbCb1 ....... %w(26) %w(24) %w(28)
%'	%p1 .......... %w(26) %w(24)
%'	%s1 .......... %w(28)
%'	%pbCb2 ....... %w(32) %w(30) %w(34)
%'	%p2 .......... %w(32) %w(30)
%'	%s2 .......... %w(34)
%'	%pbCb3 ....... %w(38) %w(36) %w(40)
%'	%p3 .......... %w(38) %w(36)
%'	%s3 .......... %w(40)
%'	%pbCb4 ....... %w(44) %w(42) %w(46)
%'	%p4 .......... %w(44) %w(42)
%'	%s4 .......... %w(46)
%'
%' NET ROUTING --
%' The table rgNetRouting is used by the CTOS Kernel to decide whether a
%' request gets routed by file handle, by file spec, or not at all.
%' It is also used by the Kernel to determine how to expand file specs.
%' The following is a set of general rules for request blocks that have
%' file specs. These rules permit routing information to be encoded.
%'
%'	1. A request may not have more than two file specs.
%'	2. The first file spec must be specified by the first pb/cb pair.
%'	3. If a file spec has a password, it must be specified by the pb/cb
%'		pair that immediately follows the pb/cb for the file spec.
%'	4. If one file spec has a password associated with it, then
%'		all file specs in the request must have passwords.
%'
%'	%RW  This request is a read or write and may have to be
%'		 be broken up in to smaller requests.
%'	    SpecPW  All file spec pb/cb pairs are followed by password pb/cb pairs.
%'	%rFh          Route this request by the file handle.
%'	%openFh       This request opens a resource that owns a file handle
%'	              and returns the handle in the first response pb/cb pair.
%'	%closeFh      This request closes a resource that owns a file handle.
%'	%devSpec      Route this request by dev spec
%'	%dirSpec      Route this request by dir Spec
%'	%fileSpec     Route this request by file spec
%'	%fileSpec2    Route this request by BOTH file specs
%'	%fileSpecP2S2 Route by file spec in p2/s2
%' SRP ROUTING --
%' The field srpRouting is used by the CTOS Kernel to decide which processor
%' services the request, and whether the request gets routed by file handle,
%' by device handle, by device spec, or not at all.
%'
%'	%rLocal       Served on the issuing processor - no routing.
%'	%rRemote      Served on exactly one processor at this node - route it there.
%'	%rMasterFp    Served on the master file processor - route it there.
%'	%rHandle      Used in conjunction with netRouting rFh - route to FP.
%'	%rFileId      Low byte of handle is Srp processor slot - route it there.
%'	%rMasterCp    Obsolete.
%'	%rLineNumber  Low 7 bits of handle is RS422 line# - route to that processor.
%'	%rDevice      In conjunction with netRouting route by device spec or handle.
%'	%rBroadcast   Route to all processors at this node.  nRespPbCb must be 0.
%'	%dmaLocal     1st pbcb is buss address, not a pointer.  rtInfo is slot.
%'	%dmaRemote    1st pbcb,rtInfo is translated to buss address,slot when
%'	              routing occurs.
%' Note that dmaLocal requests make use of the rtInfo field of the request
%'  block.  Request using this routing code cannot be transported over CT-Net
%'  because of conflicting use of that field.  Requests using dmaRemote can
%'  be transported over CT-Net, however no pbcb translation is done and the
%'  pbcb data must fit into ICC and Net buffers.
;################################################################

;
; Exchange definitions --
;	Exchanges 0 to 27 are reserved for CTOS processes.
;
; Virtual exchanges, replaced at boot time;
;  translation table created below,
;  varies with CTOS version.

    vExchAgent			EQU  -1
    vExchNotInstalled	EQU  -2
    vExchMassIO			EQU  -3		; Mass storage I/O manager
    vExchFilSys1		EQU  -4		; File system manager/ Utility
    vExchFilSys2		EQU  -5
    vExchFilSys3		EQU  -6
    vExchFilSys4		EQU  -7
    vExchScsiMgr		EQU  -8
    vExchSrpAgent		EQU  -9
    vExchLog			EQU  -10
    vExchFilterPros		EQU  -11
    vExchMem			EQU  -12
    vExchVp				EQU  -13	; Var-Part only rqs
    vExchKbd			EQU  -14	; Kbd manager/Debugger (may be resident)
    vExchResex			EQU  -15	; Overlay manager
    vExchTpReq			EQU  -16	; SRP Tp 8251 service
	vExchHwId			EQU  -17	; Hardware Id
	vExchAgentOrResex	EQU  -18	; Resex if StandAlone, Agent otherwise
	vExchAgentOrResex2	EQU  -19	; Agent if cws, resex otherwise
    vExchFilterPros2	EQU  -20	; vExchFilterPros but 0 on Stnd & Mstr


; other virtual exchange synonyms

    vExch3270		EQU  vExchNotInstalled	; 3270
    vExchCommLine 	EQU  vExchResex
    vExchCommSer	EQU  vExchNotInstalled
    vExchDBMS		EQU  vExchNotInstalled	; DBMS service
    vExchISAM		EQU  vExchNotInstalled	; ISAM service
    vExchMaster		EQU  vExchNotInstalled	; Service from master, if exists
    vExchQueMgr		EQU  vExchNotInstalled   ; Queue Manager
    vExchRJE		EQU  vExchNotInstalled   ; RJE
    vExchTape		EQU  vExchNotInstalled	; Tape Server
    vExchTask		EQU  vExchResex
    vExchMailSer 	EQU  vExchNotInstalled	; Mail Server
	vExchMcr		EQU  vExchNotInstalled	; Mcr Server
    vExchSched		EQU  vExchVp
    vExchSNA    	EQU  vExchNotInstalled	; SNA
    vExchSplrOld	EQU  vExchNotInstalled	; Print Spooler
    vExchUser		EQU  vExchMem		; userNum creation/deletion
    vExchX25		EQU  vExchNotInstalled	; X.25

; Exchanges constant over all versions of CTOS

    lExchNotPresent	EQU  0			; not installed, don't try master
    lExchObsolete 	EQU  0			;
    lExchSplr		EQU  0			; Print Spooler
    lExchSysIn		EQU  3			; System Input proccess
    lExchTia		EQU  0
    lExchUFS		EQU  0
    lExchVideo		EQU  0			; No video until Vdm_xx.run.
    lExchTerm		EQU  5			; Termination
    lExchKbdRes		EQU  1			;
    lFilterPros		EQU  4			; srp filter process
    lExchRCS		EQU  0			; No Remote Cache Service until created
	lExchQuiet		EQU  0			; QuietPros does ServeRq

    lscResexVpOnly	EQU 0D27h



;###############################################################
;
; EXCHANGE MAPPING TABLE:
;
;	Virtual exchanges are negative numbers, -1,-2..
;	At boot time, exchange tables are scanned,
;	all virtual exchanges replaced by:
;		rgExchReal(NOT vexch)
;
;	The macros SymExchange and MapExchange define the table:
;
;	 SymExchange(name, value)
;		defines a local symbolic name for an exchange,
;		for readability. Doesn't make a table entry.
;
;	 MapExchange(-n, name, value)
;		defines a local name and makes a table entry.
;		The numbers -n must be in order, -1 -2 -3 ...
;		with no duplicates and no omissions.
;
;    There are ten configurations:
;
;       cws, lfs, stnd, mstr   (Workstation)
;       fp/dp, tp, cp, sp, gp/gp+ci, gp+si   (SRP)
;
;    When a virtual exchange is added, all configurations must
;    be updated.
;
; This table shows the current virtual exchange mapping.
; - means the exchange is not serviced by the operating system.
;
;                  Cws  Lfs  Stnd  Mstr  Fp  Tp  Cp  Sp  Gp  Si  Pc
; exchResex         11   11    11    11  11  10  10  10  10  11  11
;
; exchAgent         12   12     -    12   -   -  12   -  12  12  12
; exchNotInstalled  12   12     -     -   -   -   -   -   -   -
; exchMassIo        12    8     8     8   8   -   -   -   -   8   8
; exchFilSys1       12   10    10    10  10  10  10  10  10  10  10
; exchFilSys2       (same as exchMassIo)
; exchFilSys3       17   17    11    11  11  10  10  10  10  11  11
; exchFilSys4       12   12    11    11  11  10  10  10  10  11  11
; exchScsiManager    -   14    14    14   -   -   -   -   -  14  14
; exchMstrAgent      -    -     -    12   -   -  12   -  12  12  12
; exchLog           12   12    10    10  10   -   -   -   -  10  10
; exchFilterPros    17   17    10    10   4   4   4   4   4   4   4
; exchMem            6    6     6     6  11  10  10  10   6   6   6
; exchVp             6    6     6     6   -   -   -   -   6   6   6
; exchKbd           (always 1)
; exchOvly          (same as exchResex)
; exchTp             -    -     -     -   -  20  20   -   -   -   -
; exchHwId			27   27    27    27   -   -   -   -   -   -  27
; exchAgentOrResex  12	 12	   11    12   -   -  12	  -  12  12  12
; exchAgentOrResex2 12   11    11    11  11  10  10  10  10  11  11
; exchFilterPros2   17   17    0     0    4   4   4   4   4   4   4
;
;###############################################################
;
; Exchange definitions --
;	Exchanges 0 to 27 are reserved for CTOS processes.
;

%InitExchMap(%cws)
    %SymExchange(exchResex, 11) 
    %MapExchange(-1,exchAgent, 12)	; Cluster work station agent
    %MapExchange(-2,exchNotInstalled, exchAgent)
    %MapExchange(-3,exchMassIo, exchAgent)	; Mass storage I/O manager
    %MapExchange(-4,exchFilSys1, exchAgent)	; LFS File Spec Filter Process
    %MapExchange(-5,exchFilSys2, exchMassIo)
    %MapExchange(-6,exchFilSys3, 17)	; FS filter sends to agent and local fs
    %MapExchange(-7,exchFilSys4, exchAgent)	; File system manager/ Utility
    %MapExchange(-8,exchScsiManager, 0)
    %MapExchange(-9,exchMstrAgent, 0)
    %MapExchange(-10,exchLog,  exchAgent)
    %MapExchange(-11,exchFilterPros, 17)
    %MapExchange(-12,exchMem, 6)
    %MapExchange(-13,exchVp, 6)
    %MapExchange(-14,exchKbd, 1)
    %MapExchange(-15,exchOvly, exchResex)
    %MapExchange(-16,exchTpReq, 0)
	%MapExchange(-17,exchHwId, 27)
	%MapExchange(-18,exchAgentOrResex, exchAgent)
	%MapExchange(-19,exchAgentOrResex2, exchAgent)
    %MapExchange(-20,exchFilterPros2, 17)


%InitExchMap(%lfs)
    %SymExchange(exchResex, 11)
    %MapExchange(-1,exchAgent, 12)	; Cluster work station agent
    %MapExchange(-2,exchNotInstalled, exchAgent)
    %MapExchange(-3,exchMassIo,  8)	; Mass storage I/O manager
    %MapExchange(-4,exchFilSys1, 10)
    %MapExchange(-5,exchFilSys2, exchMassIo)
    %MapExchange(-6,exchFilSys3, 17)	; FS filter sends to agent and local fs
    %MapExchange(-7,exchFilSys4, exchAgent)	; File system manager/ Utility
    %MapExchange(-8,exchScsiManager, 14)
    %MapExchange(-9,exchMstrAgent, 0)
    %MapExchange(-10,exchLog,  exchAgent)
    %MapExchange(-11,exchFilterPros, 17)
    %MapExchange(-12,exchMem, 6)
    %MapExchange(-13,exchVp, 6)
    %MapExchange(-14,exchKbd, 1)
    %MapExchange(-15,exchOvly, exchResex)
    %MapExchange(-16,exchTpReq, 0)
	%MapExchange(-17,exchHwId, 27)
	%MapExchange(-18,exchAgentOrResex, exchAgent)
	%MapExchange(-19,exchAgentOrResex2, exchResex)
    %MapExchange(-20,exchFilterPros2, 17)

%InitExchMap(%stnd)
    %SymExchange(exchResex, 11)
    %MapExchange(-1,exchAgent, 0)	; no agent
    %MapExchange(-2,exchNotInstalled, 0)
    %MapExchange(-3,exchMassIo, 8)	; Mass storage I/O manager
    %MapExchange(-4,exchFilSys1, 10)	; File system manager
    %MapExchange(-5,exchFilSys2, exchMassIo)
    %MapExchange(-6,exchFilSys3, exchResex)	; File system manager
    %MapExchange(-7,exchFilSys4, exchResex)	; Utility
    %MapExchange(-8,exchScsiManager, 14)
    %MapExchange(-9,exchMstrAgent, 0)
    %MapExchange(-10,exchLog, 10)
    %MapExchange(-11,exchFilterPros, 10)
    %MapExchange(-12,exchMem, 6)
    %MapExchange(-13,exchVp, 6)
    %MapExchange(-14,exchKbd, 1)
    %MapExchange(-15,exchOvly, exchResex)
    %MapExchange(-16,exchTpReq, 0)
	%MapExchange(-17,exchHwId, 27)
	%MapExchange(-18,exchAgentOrResex, exchResex)
	%MapExchange(-19,exchAgentOrResex2, exchResex)
    %MapExchange(-20,exchFilterPros2, 0)

%InitExchMap(%mstr)
    %SymExchange(exchResex, 11)
    %MapExchange(-1,exchAgent, 12)	; Master work station agent
    %MapExchange(-2,exchNotInstalled,  0)
    %MapExchange(-3,exchMassIo,  8)	; Mass storage
    %MapExchange(-4,exchFilSys1, 10)	; File system manager
    %MapExchange(-5,exchFilSys2, exchMassIo)
    %MapExchange(-6,exchFilSys3, exchResex)	; File system manager
    %MapExchange(-7,exchFilSys4, exchResex)	; Utility
    %MapExchange(-8,exchScsiManager, 14)
    %MapExchange(-9,exchMstrAgent, exchAgent)
    %MapExchange(-10,exchLog,  10)
    %MapExchange(-11,exchFilterPros, 10)
    %MapExchange(-12,exchMem, 6)
    %MapExchange(-13,exchVp, 6)
    %MapExchange(-14,exchKbd, 1)
    %MapExchange(-15,exchOvly, exchResex)
    %MapExchange(-16,exchTpReq, 0)
	%MapExchange(-17,exchHwId, 27)
	%MapExchange(-18,exchAgentOrResex, exchAgent)
	%MapExchange(-19,exchAgentOrResex2, exchResex)
    %MapExchange(-20,exchFilterPros2, 0)



%InitExchMap(%fp)		; FP or DP board
    %SymExchange(exchResex, 11)		; Utility
    %SymExchange(exchTpReq, 0)
    %MapExchange(-1,exchAgent, 0)
    %MapExchange(-2,exchNotInstalled,  0)
    %MapExchange(-3,exchMassIo,  8)		; Mass storage
    %MapExchange(-4,exchFilSys1, 10)	; File system manager/Utility
    %MapExchange(-5,exchFilSys2, exchMassIo)
    %MapExchange(-6,exchFilSys3, exchResex)	; File system manager/ Utility
    %MapExchange(-7,exchFilSys4, exchResex)	; File system manager/ Utility
    %MapExchange(-8,exchScsiManager, 0)
    %MapExchange(-9,exchMstrAgent, 0)
    %MapExchange(-10,exchLog,  10)
    %MapExchange(-11,exchFilterPros, 4)
    %MapExchange(-12,exchMem, exchResex)
    %MapExchange(-13,exchVp, 0)
    %MapExchange(-14,exchKbd, 1)
    %MapExchange(-15,exchOvly, exchResex)
    %MapExchange(-16,exchTp, exchTpReq)
	%MapExchange(-17,exchHwId, 0)
	%MapExchange(-18,exchAgentOrResex, exchAgent)
	%MapExchange(-19,exchAgentOrResex2, exchResex)
    %MapExchange(-20,exchFilterPros2, 4)



%InitExchMap(%tp)			; TP Board
    %SymExchange(exchResex, 10)%' CTOS.LIB sends ResetVideo to exch 10.
    %SymExchange(exchTpReq, 20)
    %MapExchange(-1,exchAgent, 0)
    %MapExchange(-2,exchNotInstalled,  0)
    %MapExchange(-3,exchMassIo,  0)		; Mass storage
    %MapExchange(-4,exchFilSys1, 10)		; File system manager/Utility
    %MapExchange(-5,exchFilSys2,  exchMassIo)
    %MapExchange(-6,exchFilSys3, exchResex)		; No lfs filter on master
    %MapExchange(-7,exchFilSys4, exchResex)	; File system manager/ Utility
    %MapExchange(-8,exchScsiManager, 0)
    %MapExchange(-9,exchMstrAgent, 0) ; No longer support PTs
    %MapExchange(-10,exchLog,  0)
    %MapExchange(-11,exchFilterPros, 4)
    %MapExchange(-12,exchMem, exchResex)
    %MapExchange(-13,exchVp, 0)
    %MapExchange(-14,exchKbd, 1)
    %MapExchange(-15,exchOvly, exchResex)
    %MapExchange(-16,exchTp, exchTpReq)
	%MapExchange(-17,exchHwId, 0)
	%MapExchange(-18,exchAgentOrResex, exchAgent)
	%MapExchange(-19,exchAgentOrResex2, exchResex)
    %MapExchange(-20,exchFilterPros2, 4)


%InitExchMap(%cp)			; CP Board
    %SymExchange(exchResex, 10)%' CTOS.LIB sends ResetVideo to exch 10.
    %SymExchange(exchTpReq, 20)
    %MapExchange(-1,exchAgent, 12)
    %MapExchange(-2,exchNotInstalled,  0)
    %MapExchange(-3,exchMassIo,  0)		; Mass storage
    %MapExchange(-4,exchFilSys1, 10)		; File system manager/Utility
    %MapExchange(-5,exchFilSys2,  exchMassIo)
    %MapExchange(-6,exchFilSys3, exchResex)		; No lfs filter on master
    %MapExchange(-7,exchFilSys4, exchResex)	; File system manager/ Utility
    %MapExchange(-8,exchScsiManager, 0)
    %MapExchange(-9,exchMstrAgent, exchAgent)
    %MapExchange(-10,exchLog,  0)
    %MapExchange(-11,exchFilterPros, 4)
    %MapExchange(-12,exchMem, exchResex)
    %MapExchange(-13,exchVp, 0)
    %MapExchange(-14,exchKbd, 1)
    %MapExchange(-15,exchOvly, exchResex)
    %MapExchange(-16,exchTp, exchTpReq)
	%MapExchange(-17,exchHwId, 0)
	%MapExchange(-18,exchAgentOrResex, exchAgent)
	%MapExchange(-19,exchAgentOrResex2, exchResex)
    %MapExchange(-20,exchFilterPros2, 4)


%InitExchMap(%sp)				; SP Board
    %SymExchange(exchResex, 10)		; Utility
    %SymExchange(exchTpReq, 0)
    %MapExchange(-1,exchAgent, 0)
    %MapExchange(-2,exchNotInstalled,  0)
    %MapExchange(-3,exchMassIo,  0)		; Mass storage
    %MapExchange(-4,exchFilSys1, 10)		; File system manager/Utility
    %MapExchange(-5,exchFilSys2, exchMassIo)
    %MapExchange(-6,exchFilSys3, exchResex)	; File system manager/ Utility
    %MapExchange(-7,exchFilSys4, exchResex)	; File system manager/ Utility
    %MapExchange(-8,exchScsiManager, 0)
    %MapExchange(-9,exchMstrAgent, 0)
    %MapExchange(-10,exchLog,  0)
    %MapExchange(-11,exchFilterPros, 4)
    %MapExchange(-12,exchMem, exchResex)
    %MapExchange(-13,exchVp, 0)
    %MapExchange(-14,exchKbd, 1)
    %MapExchange(-15,exchOvly, exchResex)
    %MapExchange(-16,exchTp, exchTpReq)
	%MapExchange(-17,exchHwId, 0)
	%MapExchange(-18,exchAgentOrResex, exchAgent)
	%MapExchange(-19,exchAgentOrResex2, exchResex)
    %MapExchange(-20,exchFilterPros2, 4)


%InitExchMap(%gp)		; GP Board
    %SymExchange(exchResex, 10)		; Utility
    %SymExchange(exchTpReq, 0)
    %MapExchange(-1,exchAgent, 12)
    %MapExchange(-2,exchNotInstalled,  0)
    %MapExchange(-3,exchMassIo,  0)		; Mass storage
    %MapExchange(-4,exchFilSys1, 10)	; File system manager/Utility
    %MapExchange(-5,exchFilSys2, exchMassIo)
    %MapExchange(-6,exchFilSys3, exchResex)	; File system manager/ Utility
    %MapExchange(-7,exchFilSys4, exchResex)	; File system manager/ Utility
    %MapExchange(-8,exchScsiManager, 0)
    %MapExchange(-9,exchMstrAgent, exchAgent)
    %MapExchange(-10,exchLog,  0)
    %MapExchange(-11,exchFilterPros, 4)
    %MapExchange(-12,exchMem, 6)
    %MapExchange(-13,exchVp, 6)
    %MapExchange(-14,exchKbd, 1)
    %MapExchange(-15,exchOvly, exchResex)
    %MapExchange(-16,exchTp, 0)
	%MapExchange(-17,exchHwId, 0)
	%MapExchange(-18,exchAgentOrResex, exchAgent)
	%MapExchange(-19,exchAgentOrResex2, exchResex)
    %MapExchange(-20,exchFilterPros2, 4)


%InitExchMap(%si)		; GP Board with Scsi adapter
    %SymExchange(exchResex, 11)		; Utility
    %SymExchange(exchTpReq, 0)
    %MapExchange(-1,exchAgent, 12)
    %MapExchange(-2,exchNotInstalled,  0)
    %MapExchange(-3,exchMassIo,  8)		; Mass storage
    %MapExchange(-4,exchFilSys1, 10)	; File system manager/Utility
    %MapExchange(-5,exchFilSys2, exchMassIo)
    %MapExchange(-6,exchFilSys3, exchResex)	; File system manager/ Utility
    %MapExchange(-7,exchFilSys4, exchResex)	; File system manager/ Utility
    %MapExchange(-8,exchScsiManager, 14)
    %MapExchange(-9,exchMstrAgent, exchAgent)
    %MapExchange(-10,exchLog,  10)
    %MapExchange(-11,exchFilterPros, 4)
    %MapExchange(-12,exchMem, 6)
    %MapExchange(-13,exchVp, 6)
    %MapExchange(-14,exchKbd, 1)
    %MapExchange(-15,exchOvly, exchResex)
    %MapExchange(-16,exchTp, exchTpReq)
	%MapExchange(-17,exchHwId, 0)
	%MapExchange(-18,exchAgentOrResex, exchAgent)
	%MapExchange(-19,exchAgentOrResex2, exchResex)
    %MapExchange(-20,exchFilterPros2, 4)


%InitExchMap(%bt)							; BootTape/OsLoader
    %SymExchange(exchResex, 10)				; Utility
    %SymExchange(exchTpReq, 0)
    %MapExchange(-1,exchAgent, 0)
    %MapExchange(-2,exchNotInstalled, 0)
    %MapExchange(-3,exchMassIo, 0)			; Mass storage
    %MapExchange(-4,exchFilSys1, 0)			; File system manager/Utility
    %MapExchange(-5,exchFilSys2, exchMassIo)
    %MapExchange(-6,exchFilSys3, 0)			; No lfs filter on master
    %MapExchange(-7,exchFilSys4, exchResex)	; File system manager/Utility
    %MapExchange(-8,exchScsiManager, 0)
    %MapExchange(-9,exchMstrAgent, 0)
    %MapExchange(-10,exchLog, 0)
    %MapExchange(-11,exchFilterPros, 4)
    %MapExchange(-12,exchMem, exchResex)
    %MapExchange(-13,exchVp, 0)
    %MapExchange(-14,exchKbd, 1)
    %MapExchange(-15,exchOvly, exchResex)
    %MapExchange(-16,exchTp, exchTpReq)
	%MapExchange(-17,exchHwId, 0)
	%MapExchange(-18,exchAgentOrResex, exchAgent)
	%MapExchange(-19,exchAgentOrResex2, exchResex)
    %MapExchange(-20,exchFilterPros2, 4)


%InitExchMap(%pc)		; Pc Srp
    %SymExchange(exchResex, 11)		; Utility
    %SymExchange(exchTpReq, 0)
    %MapExchange(-1,exchAgent, 0)
    %MapExchange(-2,exchNotInstalled,  0)
    %MapExchange(-3,exchMassIo,  8)		; Mass storage
    %MapExchange(-4,exchFilSys1, 10)	; File system manager/Utility
    %MapExchange(-5,exchFilSys2, exchMassIo)
    %MapExchange(-6,exchFilSys3, exchResex)	; File system manager/ Utility
    %MapExchange(-7,exchFilSys4, exchResex)	; File system manager/ Utility
    %MapExchange(-8,exchScsiManager, 14)
    %MapExchange(-9,exchMstrAgent, exchAgent)
    %MapExchange(-10,exchLog,  10)
    %MapExchange(-11,exchFilterPros, 4)
    %MapExchange(-12,exchMem, 6)
    %MapExchange(-13,exchVp, 6)
    %MapExchange(-14,exchKbd, 1)
    %MapExchange(-15,exchOvly, exchResex)
    %MapExchange(-16,exchTp, exchTpReq)
	%MapExchange(-17,exchHwId, 27)
	%MapExchange(-18,exchAgentOrResex, exchResex)
	%MapExchange(-19,exchAgentOrResex2, exchResex)
    %MapExchange(-20,exchFilterPros2, 4)


%InitExchMap(%Comarch)		; Pc Comarch Eisa card
    %SymExchange(exchResex, 11)		; Utility
    %SymExchange(exchTpReq, 0)
    %MapExchange(-1,exchAgent, 0)
    %MapExchange(-2,exchNotInstalled,  0)
    %MapExchange(-3,exchMassIo,  0)		; Mass storage
    %MapExchange(-4,exchFilSys1, 10)	; File system manager/Utility
    %MapExchange(-5,exchFilSys2, exchMassIo)
    %MapExchange(-6,exchFilSys3, exchResex)	; File system manager/ Utility
    %MapExchange(-7,exchFilSys4, exchResex)	; File system manager/ Utility
    %MapExchange(-8,exchScsiManager, 0)
    %MapExchange(-9,exchMstrAgent, exchAgent)
    %MapExchange(-10,exchLog,  0)
    %MapExchange(-11,exchFilterPros, 4)
    %MapExchange(-12,exchMem, 6)
    %MapExchange(-13,exchVp, 6)
    %MapExchange(-14,exchKbd, 1)
    %MapExchange(-15,exchOvly, exchResex)
    %MapExchange(-16,exchTp, 0)
	%MapExchange(-17,exchHwId, 27)
	%MapExchange(-18,exchAgentOrResex, exchResex)
	%MapExchange(-19,exchAgentOrResex2, exchResex)
    %MapExchange(-20,exchFilterPros2, 4)



%'	SYSREQUEST ENTRIES MUST COME FIRST

%SysRequestInit

%SysRequest(0,(illegal),0,0000h,0,0,0,
	    %( %illegal ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(1,SetPath,vExchResex,0D13h,6,3,0,
	    %( %pbcb0 %pbcb1 %pbcb2 ), 
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(2,ClearPath,vExchResex,0D14h,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(3,SetPrefix,vExchResex,0D15h,6,1,0,
	    %( %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(4,OpenFile,vExchFilSys1,0001h,6,2,1,
	    %( %c(2,34) %p2 %pbcb0 %pbcb1 %w(14) ),
	    %( %rLocal ),
	    %( %FileSpec %SpecPW %openFh %CloseAtTermination))

%SysRequest(5,CreateFile,vExchFilSys1,0000h,6,2,0,
	    %( %pbcb0 %pbcb1 %lfa ),
	    %( %rLocal ),
	    %( %FileSpec %SpecPW ))

%SysRequest(6,DeleteFile,vExchFilSys1,000Ch,2,0,0,
	    %( %fh ),
	    %( %rHandle ),
	    %( %rFh %closeFh ))

%SysRequest(7,RenameFile,vExchFilSys1,0002h,6,2,0,
	    %( %fh %pbcb0 %pbcb1 ),
	    %( %rHandle ),
	    %( %rFh %FileSpec %SpecPW ))

%SysRequest(8,GetFileStatus,vExchFilSys1,0700h,6,0,1,
	    %( %fh %w(14) %pbcb0 ),
	    %( %rHandle ),
	    %( %rFh ))

%SysRequest(9,SetFileStatus,vExchFilSys1,0701h,6,1,0,
	    %( %fh %w(14) %pbcb0 ),
	    %( %rHandle ),
	    %( %rFh ))

%SysRequest(10,CloseFile,vExchFilSys1,000Bh,2,0,0,
	    %( %fh ),
	    %( %rHandle ),
	    %( %rFh %closeFh))

%SysRequest(11,MountVolume,vExchFilSys1,0800h,6,2,0,
	    %( %pbcb0 %pbcb1 ),
	    %( %rLocal ),
	    %( %DevSpec %SpecPW ))

%SysRequest(12,DismountVolume,vExchFilSys1,0801h,6,2,0,
	    %( %pbcb0 %pbcb1 ),
	    %( %rLocal ),
	    %( %DevSpec %SpecPW ))

%SysRequest(13,ChangeFileLength,vExchFilSys1,0009h,6,0,0,
	    %( %fh %lfa ),
	    %( %rHandle ),
	    %( %rFh ))

%SysRequest(14,GetDateTime,vExchFilSys3,0200h,6,0,1,
	    %( %p0 %c(4,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(15,GetVhb,vExchFilSys1,0803h,6,1,1,
	    %( %pbcb0 %pbcb1 ),
	    %( %rLocal ),
	    %( %DevSpec ))

%SysRequest(16,SetDevParams,vExchFilSys1,0804h,6,2,0,
	    %( %pbcb0 %pbcb1 %w(12) ),
	    %( %rLocal ),
	    %( %DevSpec %SpecPW ))

%SysRequest(17,CreateDir,vExchFilSys1,0003h,6,3,0,
	    %( %pbcb0 %pbcb1 %pbcb2 %w(14) %w(16) ),
	    %( %rLocal ),
	    %( %DirSpec %SpecPW ))

%SysRequest(18,DeleteDir,vExchFilSys1,0004h,6,2,0,
	    %( %pbcb0 %pbcb1 ),
	    %( %rLocal ),
	    %( %DirSpec %SpecPW ))

%SysRequest(19,CloseAllFiles,vExchFilterPros,000Dh,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(20,QuietMassIo,vExchMassIO,0000h,2,0,0,
	    %( %none ),
	    %( %rDevice ),
	    %( %noRouting ))	; *2

%SysRequest(21,QueryVidHdw,lExchVideo,0C03h,6,0,1,
	    %( %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(22,LoadFontRam,lExchVideo,0B00h,6,1,0,
	    %( %fh %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(23,LoadStyleRam,lExchVideo,0B03h,6,1,0,
	    %( %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(24,LoadCursorRam,lExchVideo,0B02h,6,1,0,
	    %( %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(25,ReadDirSector,vExchFilSys1,0005h,6,2,1,
	    %( %pbcb0 %pbcb1 %w(14) %p2 %c(2,35) ),
	    %( %rLocal ),
	    %( %DirSpec %SpecPW ))  ; *1

%SysRequest(26,GetDcbOld,vExchFilSys1,0805h,6,2,1,
	    %( %pbcb0 %pbcb1 %pbcb2),
	    %( %rLocal ),
	    %( %DevSpec ))

%SysRequest(27,GetUcb,vExchResex,0D17h,6,0,1,
	    %( %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(28,Chain,lExchTerm,0101h,6,2,0,
	    %( %pbcb0 %pbcb1 %w(12) %w(14) %w(16) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(29,LoadTask,lExchTerm,0004h,6,0,0,
	    %( %fh %w(14) %w(16) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(30,SetFhLongevity,vExchFilSys1,0011h,4,0,0,
	    %( %w(12) %w(14) ),
	    %( %rHandle ),
	    %( %rFh ))

%SysRequest(31,GetFhLongevity,vExchFilSys1,0010h,6,0,1,
	    %( %fh %p0 %c(1,22) ),
	    %( %rHandle ),
	    %( %rFh ))

%SysRequest(32,ResetSubsys,vExchTask,0E00h,6,0,0,
	    %( %fh %w(14) %w(16) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(33,DeviceRead,vExchMassIO,8000h,6,0,2,
	    %( %w(12) %pbcb0 %lfa %p1 %c(2,28) ),
	    %( %rLocal ),
	    %( %RW ))

%SysRequest(34,DeviceWrite,vExchMassIO,8001h,6,1,1,
	    %( %w(12) %pbcb0 %lfa %p1 %c(2,28) ),
	    %( %rLocal ),
	    %( %RW ))

%SysRequest(35,Read,vExchFilSys2,0000h,6,0,2,
	    %( %fh %pbcb0 %lfa %p1 %c(2,28) ),
	    %( %rHandle %dmaRemote ),
	    %( %rFh %RW ))

%SysRequest(36,Write,vExchFilSys2,0001h,6,1,1,
	    %( %fh %pbcb0 %lfa %p1 %c(2,28) ),
	    %( %rHandle %dmaRemote ),
	    %( %rFh %RW ))

%SysRequest(37,DeviceReadIdAndData,vExchMassIO,0002h,6,0,2,
	    %( %w(12) %pbcb0 %lfa %p1 %c(2,28) ),
	    %( %rHandle ),
	    %( %noRouting ))

%SysRequest(38,Format,vExchFilSys2,0003h,6,1,1,
	    %( %w(12) %pbcb0 %lfa %p1 %c(2,28) ),
	    %( %rHandle ),
	    %( %rFh %RW ))

%SysRequest(39,DeviceReadID,vExchMassIO,8004h,6,0,2,
	    %( %w(12) %pbcb0 %lfa %p1 %c(2,28) ),
	    %( %rHandle ),
	    %( %noRouting ))

%SysRequest(40,AllocExch,vExchResex,0D00h,6,0,1,
	    %( %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(41,DeallocExch,vExchResex,0D01h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(42,AllocMemorySL,vExchMem,0D02h,6,0,1,
	    %( %w(12) %p0 %c(4,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(43,DeallocMemorySL,vExchMem,0D03h,6,0,0,
	    %( %p(14) %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(44,AllocMemoryLL,vExchMem,0D04h,6,0,1,
	    %( %w(12) %p0 %c(4,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(45,DeallocMemoryLL,vExchMem,0D05h,6,0,0,
	    %( %p(14) %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(46,AllocAllMemorySL,vExchMem,0D06h,6,0,2,
	    %( %p0 %p1 %c(2,22) %c(4,28) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(47,ResetMemoryLL,vExchMem,0D07h,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(48,QueryMemAvail,vExchMem,0D08h,6,0,1,
	    %( %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(49,OpenRTClock,vExchKbd,0300h,6,1,0,
	    %( %p0 %c(12,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(50,CloseRTClock,vExchKbd,0400h,6,1,0,
	    %( %p0 %c(12,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(51,SetDateTime,vExchFilSys3,0201h,4,0,0,
	    %( %w(12) %w(14) ),
	    %( %rBroadcast ),
	    %( %noRouting ))

%SysRequest(52,Beep,vExchKbd,0100h,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(53,ReadKbd,lExchSysIn,0001h,6,0,1,
	    %( %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(54,ReadKbdDirect,vExchKbd,0001h,6,0,1,
	    %( %w(12) %p0 %c(1,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(55,QueryKbdLEDs,vExchKbd,0003h,6,0,1,
	    %( %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(56,SetKbdLED,vExchKbd,0004h,4,0,0,
	    %( %w(12) %w(14) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(57,SetKbdUnencodedMode,lExchSysIn,0005h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(58,QueryKbdState,lExchSysIn,0006h,6,0,1,
	    %( %p0 %c(4,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(59,SetSysInMode,lExchSysIn,0008h,4,0,0,
	    %( %w(14) %fh ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(60,ReadActionCode,vExchKbd,000Ah,6,0,1,
	    %( %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(61,QueryWSNum,vExchAgentOrResex,0706h,6,0,1,
	    %( %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(62,CloseAllFilesLL,vExchFilterPros,000Eh,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(63,KbdWakeUp,vExchKbd,0002h,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting )) 	; *2

%SysRequest(64,BeeperOff,0,0200h,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting )) 	; *2

%SysRequest(65,SetKbdUnencodedModeReal,vExchKbd,0005h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting )) 	; *2

%SysRequest(66,KbdResetSysIn,lExchSysIn,000Ch,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting )) 	; *2

%SysRequest(67,DisableActionFinish,vExchKbd,0007h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(68,CheckpointSysIn,lExchSysIn,0009h,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(69,SetIntHandler,vExchResex,0D0Bh,12,0,0,
	    %( %w(12) %p(14) %w(18) %w(20) %w(22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(70,ResetKbd,vExchKbd,0000h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting )) 	; *2

%SysRequest(71,ResetSysIn,lExchSysIn,0000h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting )) 	; *2

%SysRequest(72,ResetAgent,vExchAgent,0000h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting )) 	; *2

%SysRequest(73,FileSystemTermination,vExchFilterPros,000Dh,2,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(74,ResetVideo,lExchVideo,0C00h,6,0,1,
	    %( %b(12) %b(13) %b(14) %b(15) %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(75,InitVidFrame,lExchVideo,0C01h,10,0,0,
	    %( %b(12) %b(13) %b(14) %b(15) %b(16) %b(17)
	       %b(18) %b(19) %b(20) %b(21) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(76,InitCharMap,lExchVideo,0C02h,6,0,1,
	    %( %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(77,SetScreenVidAttr,lExchVideo,0B01h,4,0,0,
	    %( %w(12) %w(14) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(78,CloseISAM,vExchISAM,8400h,2,0,1,
	    %( %w(12) %p(14) %c(4,18) ),
	    %( %rRemote ),
	    %( %rFh %closeFh ))

%SysRequest(79,CreateISAM,vExchISAM,0001h,0,5,1,
	    %( %p(12) %w(16) %p(18) %w(22) %p(24) %w(28)
	       %p(30) %w(34) %p(36) %w(40) %p(42) %c(4,46) ),
	    %( %rRemote ),
	    %( %FileSpec2 %SpecPW ))

%SysRequest(80,DeleteISAM,vExchISAM,8002h,2,0,1,
	    %( %w(12) %p(14) %c(4,18) ),
	    %( %rRemote ),
	    %( %rFh %closeFh ))

%SysRequest(81,DeleteISAMRecord,vExchISAM,0D803h,6,0,1,
	    %( %w(12) %p(14) %p(18) %c(4,22) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(82,GetISAMRecords,vExchISAM,0C004h,4,0,3,
	    %( %w(12) %b(14) %p(16) %w(20)
	       %p(22) %c(2,26) %p(28) %c(4,32) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(83,LockISAM,vExchISAM,0EFFFh,2,1,1,
	    %( %w(12) %p(14) %w(18) %p(20) %c(4,24) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(84,ModifyISAMRecord,vExchISAM,0D805h,6,1,1,
	    %( %w(12) %p(14) %p(18) %w(22) %p(24) %c(4,28) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(85,OpenISAM,vExchISAM,0006h,4,2,2,
	    %( %p(28) %c(2,32) %p(16) %w(20) %p(22) %w(26)
	       %w(12) %w(14) %p(34) %c(4,38) ),
	    %( %rRemote ),
	    %( %FileSpec %SpecPW %openFh %CloseAtTermination ))

%SysRequest(86,ReadISAMRecordByUri,vExchISAM,0C007h,6,0,2,
	    %( %w(12) %p(14) %p(18) %w(22) %p(24) %c(4,28) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(87,ReadNextISAMRecord,vExchISAM,0C008h,2,0,3,
	    %( %w(12) %p(14) %w(18) %p(20) %c(4,24) %p(26)
	       %c(4,30) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(88,ReadUniqueISAMRecord,vExchISAM,0C009h,4,1,3,
	    %( %w(12) %w(14) %p(16) %w(20) %p(22) %w(26)
	       %p(28) %c(4,32) %p(34) %c(4,38) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(89,RenameISAM,vExchISAM,800Ah,2,4,1,
	    %( %w(12) %p(14) %w(18) %p(20) %w(24)
	       %p(26) %w(30) %p(32) %w(36) %p(38) %c(4,42) ),
	    %( %rRemote ),
	    %( %rFh %FileSpec2 %SpecPW ))

%SysRequest(90,SetISAMProtection,vExchISAM,800Bh,2,2,1,
	    %( %w(12) %p(14) %w(18) %p(20) %w(24) %p(26)
	       %c(4,30) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(91,SetupISAMIterationKey,vExchISAM,0EFFFh,4,1,1,
	    %( %w(12) %w(14) %p(16) %w(20) %p(22) %c(4,26) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(92,SetupISAMIterationPrefix,vExchISAM,800Ch,4,1,1,
	    %( %w(12) %w(14) %p(16) %w(20) %p(22) %c(4,26) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(93,SetupISAMIterationRange,vExchISAM,0EFFFh,6,2,1,
	    %( %w(12) %w(14) %p(18) %w(22) %b(16) %p(24)
	       %w(28) %b(17) %p(30) %c(4,34) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(94,StoreISAMRecord,vExchISAM,0D80Dh,2,1,2,
	    %( %w(12) %p(14) %w(18) %p(20) %c(4,24) %p(26)
	    %c(4,30) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(95,UnlockISAM,vExchISAM,0EFFFh,0,0,1,
	    %( %p(12) %c(4,16) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(96,PurgeISAMUser,vExchISAM,000Eh,2,0,0,
	    %( %w(12) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(97,OpenFileLL,vExchFilSys1,0001h,6,2,1,
	    %( %c(2,34) %p2 %pbcb0 %pbcb1 %w(14) ),
	    %( %rLocal ),
	    %( %FileSpec %SpecPW %openFh ))

%SysRequest(98,ConvertToSys,vExchUser,0D0Ch,0,0,0,
	    %( %none),
	    %( %rLocal ),
	    %( %none))

%SysRequest(99,ServeRq,vExchResex,0D0Dh,4,0,0,
	    %( %w(12) %w(14) ),
	    %( %rBroadcast ),
	    %( %none))

%SysRequest(100,GetClusterStatus,vExchAgent,0000h,6,0,1,
	    %( %w(12) %pbcb0),
	    %( %rLineNumber ),
	    %( %noRouting ))

%SysRequest(101,SetCommISR,vExchCommLine,0303h,22,0,0,
	    %( %w(12) %p(14) %p(18) %p(22) %p(26) %p(30)),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(102,ResetCommISR,vExchCommLine,0305h,2,0,0,
	    %( %w(12)),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(103,KbAttn3270,vExch3270,0000h,6,2,0,
	    %( %c(1,22) %p(18) %p(24) %w(28)),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(104,ScreenRead3270,vExch3270,0001h,6,2,0,
	    %( %c(1,22) %p(18) %p(24) %w(28)),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(105,StatusRead3270,vExch3270,0002h,6,2,0,
	    %( %c(1,22) %p(18) %p(24) %w(28)),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(106,ReadyForCmd3270,vExch3270,0003h,6,1,1,
	    %( %c(1,22) %p(18) %p(24) %w(28)),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(107,StartEm3270,vExch3270,0004h,6,1,1,
	    %( %c(1,22) %p(18) %p(24) %w(28)),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(108,StopEm3270,vExch3270,0005h,2,0,0,
	    %( %w(12)),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(109,CancelRq3270,vExch3270,0006h,6,1,0,
	    %( %c(1,22) %p(18)),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(110,ReportStatus3270,vExch3270,0007h,6,1,1,
	    %( %c(1,22) %p(18) %p(24) %w(28)),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(111,SetVerifyCount,vExchNotInstalled,0h,2,0,0,
	    %( %w(12) ),
	    %( %rMasterFp ),
	    %( %noRouting ))

%SysRequest(112,FileSystemAbort,vExchFilterPros,000Eh,2,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(113,QueryFrameAttrs,lExchVideo,0B86h,4,0,2,
		%( %b (12) %b(13) %b(14) %w(20) %p(16) %p(22) %c(2,26) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(114,QueryFrameString,lExchVideo,0B87h,4,0,2,
		%( %b (12) %b(13) %b(14) %w(20) %p(16) %p(22) %c(2,26) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(115,LoadColorStyleRam,lExchVideo,0B80h,0,1,0,
		%( %p(12) %c(8,16) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(116,SetStyleRam,lExchVideo,0B81h,2,0,0,
		%( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(117,SetStyleRamEntry,lExchVideo,0B82h,4,0,0,
		%( %w(12) %w(14) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(118,ProgramColorMapper,lExchVideo,0B83h,0,2,2,
		%( %p(12) %w(16) %p(18) %w(22) %p(24) %w(28) %p(30) %w(34) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(119,UpdateColorHardware,lExchVideo,0B84h,2,2,0,
		%( %w(12) %p(14) %c(24,18) %p(20) %c(5,24) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(120,GetNxtFilePrt,vExchSplrOld,0000h,0,1,1,
	    %( %p(12) %w(16) %p(18) %w(22) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(121,SetLpISR,vExchResex,0D10h,6,0,0,
	    %( %p(14) %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(122,DisableCluster,vExchSrpAgent,0,4,0,0,
	    %( %w(12) %w(14) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(123,GetRunFileHdr,vExchResex,0E00h,6,0,1,
	    %( %fh %pbcb0 ),
	    %( %rHandle ),
	    %( %rFh ))

%SysRequest(124,QueryDcb,vExchFilSys1,0805h,6,1,1,
	    %( %pbcb0 %pbcb1),
	    %( %rLocal ),
	    %( %DevSpec ))

%SysRequest(125,WriteLog,vExchResex,0901h,6,1,0,
	    %( %pbcb0),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(126,SetCommISRRaw,vExchCommLine,0304h,30,0,0,
	    %( %w(12) %p(14) %p(18) %p(22) %p(26)
	    %p(30) %w(34) %w(36) %w(38) %w(40)),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(127,PurgeISAMTransaction,vExchISAM,0EFFFh,0,0,1,
	    %( %p(12) %c(4,16) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(128,EndISAMTransaction,vExchISAM,0EFFFh,0,0,1,
	    %( %p(12) %c(4,16) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(129,GetISAMRecordsHold,vExchISAM,0F004h,4,0,3,
	    %( %w(12) %b(14) %p(16) %w(20)
	       %p(22) %c(2,26) %p(28) %c(4,32) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(130,HoldISAMRecord,vExchISAM,0D00Fh,6,0,1,
	    %( %w(12) %p(14) %p(18) %c(4,22) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(131,ReadISAMRecordByUriHold,vExchISAM,0F007h,6,0,2,
	    %( %w(12) %p(14) %p(18) %w(22) %p(24) %c(4,28) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(132,ReadNextISAMRecordHold,vExchISAM,0F008h,2,0,3,
	    %( %w(12) %p(14) %w(18) %p(20) %c(4,24) %p(26)
	       %c(4,30) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(133,ReadUniqueISAMRecordHold,vExchISAM,0F009h,4,1,3,
	    %( %w(12) %w(14) %p(16) %w(20) %p(22) %w(26)
	       %p(28) %c(4,32) %p(34) %c(4,38) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(134,ReleaseISAMRecord,vExchISAM,0D410h,6,0,1,
	    %( %w(12) %p(14) %p(18) %c(4,22) ),
	    %( %rRemote ),
	    %( %rFh ))

%SysRequest(135,SetupISAMIteration,vExchISAM,0EFFFh,4,1,1,
	    %( %w(12) %w(14) %p(16) %w(20) %p(22) %c(4,26) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(136,StartISAMTransaction,vExchISAM,0EFFFh,4,1,1,
	    %( %b(12) %w(14) %p(16) %w(20) %p(22) %c(4,26) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(137,AddQueueEntry,vExchQueMgr,0000h,6,3,0,
	    %( %p(18) %w(22) %b(12) %b(13)   %w(14)
	    %p(24) %w(28) %p(30) %c(4,34) %w(16) ),
	    %( %rRemote ),
	    %( %DevSpec ))

%SysRequest(138,RemoveKeyedQueueEntry,vExchQueMgr,0001h,4,3,0,
	    %( %p(16) %w(20) %p(22) %w(26) %w(12) %p(28) %w(32) %w(14) ),
	    %( %rRemote ),
	    %( %DevSpec ))

%SysRequest(139,ReadNextQueueEntry,vExchQueMgr,0002h,4,1,2,
	    %( %p(16) %w(20) %p(12) %p(22) %w(26) %p(28) %w(32) ),
	    %( %rRemote ),
	    %( %DevSpec ))

%SysRequest(140,ReadKeyedQueueEntry,vExchQueMgr,0003h,4,3,2,
	    %( %p(16) %w(20) %p(22) %w(26) %w(12)
	    %p(28) %w(32) %w(14) %p(34) %w(38) %p(40) %w(44) ),
	    %( %rRemote ),
	    %( %DevSpec ))

%SysRequest(141,MarkNextQueueEntry,vExchQueMgr,0004h,2,1,2,
	    %( %p(14) %w(18) %b(12) %p(20) %w(24) %p(26) %w(30) ),
	    %( %rRemote ),
	    %( %DevSpec ))

%SysRequest(142,MarkKeyedQueueEntry,vExchQueMgr,0005h,4,3,2,
	    %( %p(16) %w(20) %p(22) %w(26) %w(12) %p(28)
	    %w(32) %w(14) %p(34) %w(38) %p(40) %w(44) ),
	    %( %rRemote ),
	    %( %DevSpec ))

%SysRequest(143,RemoveMarkedQueueEntry,vExchQueMgr,0006h,4,1,0,
	    %( %p(16) %w(20) %p(12) ),
	    %( %rRemote ),
	    %( %DevSpec ))

%SysRequest(144,UnMarkQueueEntry,vExchQueMgr,0007h,4,1,0,
	    %( %p(16) %w(20) %p(12) ),
	    %( %rRemote ),
	    %( %DevSpec ))

%SysRequest(145,ReWriteMarkedQueueEntry,vExchQueMgr,0008h,4,2,0,
	    %( %p(16) %w(20) %p(12) %p(22) %w(26) ),
	    %( %rRemote ),
	    %( %DevSpec ))

%SysRequest(146,EstablishQueueServer,vExchQueMgr,0009h,4,1,0,
	    %( %p(16) %w(20) %w(12) %b(14) ),
	    %( %rRemote ),
	    %( %DevSpec ))

%SysRequest(147,TerminateQueueServer,vExchQueMgr,000Ah,0,1,0,
	    %( %p(12) %w(16) ),
	    %( %rRemote ),
	    %( %DevSpec ))

%SysRequest(148,PurgeQueueServer,vExchQueMgr,000Bh,2,0,0,
	    %( %w(12) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(149,SignoffRJE,vExchRJE,0000h,2,0,0,
	    %( %w(12) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(150,SignonRJE,vExchRJE,0000h,0,2,0,
	    %( %p(12) %w(16) %p(18) %w(22) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(151,StatusRJE,vExchRJE,0000h,0,0,2,
	    %( %p(12) %c(2,16) %p(18) %w(22) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(152,AcceptCommCall,vExchCommSer,0000h,4,0,0,
	    %( %w(12) %w(14) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(153,CloseAllCommLines,vExchCommSer,0001h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(154,CloseCommLine,vExchCommSer,0002h,4,0,0,
	    %( %w(12) %w(14) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(155,DialComm,vExchCommSer,0003h,2,1,0,
	    %( %w(12) %p(14) %w(18) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(156,DisconnectComm,vExchCommSer,0004h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(157,FlushCommBuffer,vExchCommSer,0005h,4,0,0,
	    %( %w(12) %b(14) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(158,GetCommParameters,vExchCommSer,0006h,2,0,1,
	    %( %w(12) %p(14) %c(20,18) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(159,OpenCommLine,vExchCommSer,0007h,4,2,1,
	    %( %b(12) %p(16) %w(20) %p(22) %w(26) %w(14) %p(28) %c(2,32) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(160,ReadComm,vExchCommSer,0008h,4,0,2,
	    %( %w(12) %w(14) %p(16) %w(20) %p(22) %c(2,26) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(161,SetCommParameters,vExchCommSer,0009h,2,1,0,
	    %( %w(12) %p(14) %c(20,18) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(162,WriteComm,vExchCommSer,000Ah,4,1,1,
	    %( %w(12) %w(14) %p(16) %w(20) %p(22) %c(2,26) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(163,BreakComm,vExchCommSer,000Bh,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(164,ResetQueMgr,vExchQueMgr,0000h,2,0,0,
	    %( %w(12) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(165,NotifyNextIncomingCall,vExchX25,0,8,1,3,
	    %( %w(12) %p(38) %c(2,42) %p(26) %w(30) %p(32) %c(2,36)
	    %p(20) %w(24) %w(14) %w(16) %w(18) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(166,AcceptX25Call,vExchX25,0,6,2,0,
	    %( %w(12) %p(18) %w(22) %p(24) %w(28) %w(16) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(167,InitiateX25Call,vExchX25,0,6,3,3,
	    %( %w(12) %p(36) %c(2,40) %p(42) %w(46) %p(48) %c(2,52)
	    %p(30) %w(34) %p(18) %w(22) %p(24) %w(28) %w(14) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(168,ClearX25Call,vExchX25,0,6,1,0,
	    %( %w(12) %w(14) %p(18) %w(22) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(169,PurgeX25User,vExchX25,0,2,0,0,
	    %( %w(12) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(170,ReadX25Packet,vExchX25,0,6,0,3,
	    %( %w(12) %p(18) %w(22) %p(24) %c(2,28)
	    %p(30) %c(1,34) %w(14) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(171,WriteX25Packet,vExchX25,0,6,1,0,
	    %( %w(12) %w(14) %p(18) %w(22) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(172,WriteX25Interrupt,vExchX25,0,4,0,0,
	    %( %w(12) %w(14) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(173,ResetX25Call,vExchX25,0,2,0,0,
	    %( %w(12) %w(14) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(174,QueryX25Status,vExchX25,0,8,0,2,
	    %( %w(12) %p(20) %w(24) %b(14) %b(15)
	    %w(16) %w(18) %p(26) %c(1,30) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(175,ConnectX25Permanent,vExchX25,0,2,0,1,
	    %( %w(12) %p(14) %c(2,18) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(176,DeletePartition,vExchUser,0F01h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(177,GetPartitionHandle,vExchTask,0F02h,0,1,1,
	    %( %p(12) %w(16) %p(18) %c(2,22) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(178,LoadPrimaryTask,lExchTerm,0100h,6,2,0,
	    %( %w(12) %p(18) %w(22) %p(24) %w(28) %w(14) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(179,TerminatePartition,vExchTask,0F03h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(180,VacatePartition,lExchTerm,0002h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(181,CreatePartition,vExchUser,0F00h,6,1,1,
	    %( %p(18) %w(22) %w(12) %b(14) %p(24) %c(2,28) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(182,SetPartitionLock,vExchTask,0F04h,2,0,0,
	    %( %b(12) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(183,SetPartitionExch,vExchTask,0F05h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(184,GetPartitionExch,vExchTask,0F06h,2,0,1,
	    %( %w(12) %p(14) %c(2,18) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(185,GetPartitionStatus,vExchTask,0F07h,4,0,1,
	    %( %w(12) %w(14) %p(16) %w(20) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(186,SetExitRunFile,vExchTask,0D09h,6,2,0,
	    %( %p(18) %w(22) %p(24) %w(28) %w(12) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(187,QueryExitRunFile,vExchTask,0D0Ah,6,0,3,
	    %( %p(18) %w(22) %p(24) %w(28) %p(30) %c(2,34) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(188,ConfigureSpooler, lExchSplr,0000h,6,3,0,
	    %( %b(12) %pbcb0 %pbcb1 %pbcb2 %b(13) %b(14) ),
	    %( %rMasterFp ),
	    %( %FileSpecP2S2 ))

%SysRequest(189,SpoolerPassword,lExchSplr,0001h,6,2,0,
	    %( %pbcb0 %pbcb1 ),
	    %( %rMasterFp ),
	    %( %noRouting ))

%SysRequest(190,OpenTape,vExchTape,0,6,1,1,
	    %( %pbcb0 %b(12) %b(13) %b(14) %w(16) %p1 %c(2,28) ),
	    %( %rDevice ),
	    %( %DevSpec %openFh %CloseAtTermination ))

%SysRequest(191,ReadTapeRecords,vExchTape,1,6,0,3,
	    %( %fh %w(14) %pbcb0 %p1 %c(2,28) %p2 %c(2,34) ),
	    %( %rDevice %dmaRemote ),
	    %( %rFh ))

%SysRequest(192,WriteTapeRecords,vExchTape,2,6,1,2,
	    %( %fh %w(14) %pbcb0 %p1 %c(2,28) %p2 %c(2,34) ),
	    %( %rDevice %dmaRemote ),
	    %( %rFh ))

%SysRequest(193,TapeOperation,vExchTape,3,6,0,0,
	    %( %fh %b(14) %b(15) %w(16) ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(194,CloseTape,vExchTape,4,2,0,0,
	    %( %fh ),
	    %( %rDevice ),
	    %( %rFh %CloseFh ))

%SysRequest(195,PurgeTapeUser,vExchTape,5,2,0,0,
	    %( %w(12) ),
	    %( %rDevice ),
	    %( %noRouting ))

%SysRequest(196,TapeStatus,vExchTape,6,6,0,1,
	    %( %fh %p0 %c(2,22) ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(197,ResetSplr,lExchSplr,0000h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(198,ModifyISAMRecordByKey,vExchISAM,0F811h,4,1,2,
	    %( %w(12) %w(14) %p(16) %w(20) %p(22) %c(4,26) %p(28) %c(4,32) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(199,DeleteISAMRecordByKey,vExchISAM,0F812h,4,1,2,
	    %( %w(12) %w(14) %p(16) %w(20) %p(22) %c(4,26) %p(28) %c(4,32) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(200,LogRemote,vExchFilSys1,0900h,6,2,0,
	    %( %pbcb0 %pbcb1 ),
	    %( %rMasterFp ), 
	    %( %noRouting ))

%SysRequest(201,VacateParCleanup,vExchMaster,0000h,2,0,0,
	    %( %none),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(202,GetWsUserName,vExchAgentOrResex,0704h,6,0,1,
	    %( %w(12) %pbcb0 ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(203,SetWsUserName,vExchAgentOrResex,0705h,6,1,0,
	    %( %pbcb0 ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(204,FinishISAMCommit,vExchISAM,0013h,0,1,1,
	    %( %p(12) %w(16) %p(18) %c(4,22) ),
	    %( %rRemote ), 
	    %( %DevSpec ))

%SysRequest(205,HoldISAMDataSet,vExchISAM,0D014h,4,0,1,
	    %( %w(12) %b(14) %p(16) %c(4,20) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(206,ReleaseISAMDataSet,vExchISAM,0D415h,2,0,1,
	    %( %w(12) %p(14) %c(4,18) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(207,RollbackISAMTransaction,vExchISAM,0016h,0,1,1,
	    %( %p(12) %w(16) %p(18) %c(4,22) ),
	    %( %rRemote ), 
	    %( %DevSpec ))

%SysRequest(208,SetISAMTransactionParams,vExchISAM,0017h,0,2,1,
	    %( %p(12) %w(16) %p(18) %w(22)
	       %p(24) %c(4,28)),
	    %( %rRemote ), 
	    %( %DevSpec ))

%SysRequest(209,StartISAMCommit,vExchISAM,0018h,0,2,1,
	    %( %p(12) %w(16) %p(18) %w(22)
	       %p(24) %c(4,28) ),
	    %( %rRemote ), 
	    %( %DevSpec ))

%SysRequest(210,SetupISAMIterationLimits,vExchISAM,8019h,6,2,1,
	    %( %w(12) %w(14) %b(16) %p(18) %w(22)
           %p(24) %w(28) %p(30) %c(4,34) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(211,BeginISAMTransaction,vExchISAM,001Ah,0,1,2,
	    %( %p(12) %w(16) %p(18) %c(7,22)
	    %p(24) %c(4,28) ),
	    %( %rRemote ), 
	    %( %DevSpec ))

%SysRequest(212,DbResourceRequest,vExchDBMS,0FFFFh,10,3,3,
	    %( %none ),
	    %( %rRemote ), 
	    %( %DevSpec %openFh %CloseAtTermination ))

%SysRequest(213,DbCloseRequest,vExchDBMS,0FFFFh,10,3,3,
	    %( %none ),
	    %( %rRemote ), 
	    %( %rFh %closeFh ))

%SysRequest(214,DbHandleRequest,vExchDBMS,0FFFFh,10,3,3,
	    %( %none ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(215,ChangeOpenMode,vExchMassIO,0006h,6,1,0,
	    %( %fh %pbcb0 %w(14) ),
	    %( %rHandle ),
	    %( %rFh %SpecPW ))

%SysRequest(216,GetDirStatus,vExchFilSys1,0007h,6,2,1,
	    %( %pbcb0 %pbcb1 %w(12) %pbcb2 ),
	    %( %rLocal ),
	    %( %DirSpec %SpecPW ))

%SysRequest(217,SetDirStatus,vExchFilSys1,0008h,6,3,0,
	    %( %pbcb0 %pbcb1 %w(12) %pbcb2 ),
	    %( %rLocal ),
	    %( %DirSpec %SpecPW ))

%SysRequest(218,ChangeUserNumQmg,vExchQueMgr,0000h,2,0,0,
	    %( %w(12) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(219,ChangeUserNumFs,vExchFilterPros,0013h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(220,ReadSNAPIU,vExchSNA,0,6,0,4,
	    %( %w(12) %w(14) %w(16) %p(18) %w(22) %p(24) %w(28)
	       %p(30) %w(34) %p(36) %w(40) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(221,WriteSNAPIU,vExchSNA,0,2,1,0,
	    %( %w(12) %p(14) %w(18) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(222,XWriteSNAPIU,vExchSNA,0,2,1,0,
	    %( %w(12) %p(14) %w(18) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(223,AttachLu,vExchSNA,0,4,0,1,
	    %( %w(12) %p(16) %c(2,20) %b(14)  ),
	    %( %rRemote ), 
	    %( %noRouting ))

%SysRequest(224,InitiateSNASession,vExchSNA,0,2,5,0,
	    %( %w(12) %p(14) %w(18) %p(20) %w(24) %p(26)
	       %w(30) %p(32) %w(36) %p(38) %w(42) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(225,NotifyNextIncomingBind,vExchSNA,0,4,0,2,
	    %( %w(12) %w(14) %p(16) %w(20) %p(22) %w(26) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(226,TerminateSNASession,vExchSNA,0,2,0,0,
	    %( %w(12) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(227,AcceptSNASession,vExchSNA,0,2,1,0,
	    %( %w(12) %p(14) %w(18) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(228,RejectSNASession,vExchSNA,0,2,1,0,
	    %( %w(12) %p(14) %w(18) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(229,PurgeSNAUser,vExchSNA,0,2,0,0,
	    %( %w(12) ),
	    %( %rRemote ), 
	    %( %noRouting ))

%SysRequest(230,CloseSNASession,vExchSNA,0,2,1,0,
	    %( %w(12) %p(14) %w(18) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(231,DetachLu,vExchSNA,0,2,0,0,
	    %( %w(12) ),
	    %( %rRemote ), 
	    %( %rFh %CloseFh))

%SysRequest(232,QuerySNAStatus,vExchSNA,0,8,0,2,
	    %( %b(14) %w(16) %p(20) %w(24) %p(26) %c(1,30) ),
	    %( %rRemote ), 
	    %( %noRouting ))

%SysRequest(233,TerminateSNAUser,vExchSNA,0,2,0,0,
	    %( %w(12) ),
	    %( %rRemote ), 
	    %( %noRouting ))

%SysRequest(234,AcknowledgeMailReceipt,vExchMailSer,0,6,1,0,
	    %( %w(12) %p(18) %c(12,22) %w(14) %w(16) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(235,CheckForMail,vExchMailSer,1,4,1,2,
	    %( %p(12) %p(16) %w(20) %p(22) %c(2,26) %p(28) %c(2,32) ),
	    %( %rRemote ), 
	    %( %DevSpec ))

%SysRequest(236,ConfigureMail,vExchMailSer,2,4,2,0,
	    %( %w(12) %w(14) %p(16) %w(20) %p(22) %w(26) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(237,ConnectNextMailCenter,vExchMailSer,3,2,0,2,
	    %( %w(12) %p(14) %c(2,18) %p(20) %w(24) ),
	    %( %rRemote ), 
	    %( %rFh %OpenFh %CloseAtTermination))

%SysRequest(238,EstablishMailConnection,vExchMailSer,4,0,2,2,
	    %( %p(12) %w(16) %p(18) %w(22) %p(24) %c(2,28) %p(30) %w(34) ),
	    %( %rRemote ), 
	    %( %DevSpec %OpenFh %CloseAtTermination))

%SysRequest(239,PurgeMailUser,vExchMailSer,5,2,0,0,
	    %( %w(12) ),
	    %( %rRemote ), 
	    %( %noRouting ))

%SysRequest(240,QueryMailConfiguration,vExchMailSer,6,4,2,2,
	    %( %w(12) %w(14) %p(16) %w(20) %p(22) %w(26)
	    %p(28) %w(32) %p(34) %c(2,38) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(241,QueryMailStatus,vExchMailSer,7,6,0,2,
	    %( %w(12) %w(14) %w(16) %p(18) %w(22) %p(24) %c(2,28) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(242,QueryMailUniqueId,vExchMailSer,8,2,0,1,
	    %( %w(12) %p(14) %c(4,18) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(243,QueryServerForUser,vExchMailSer,9,0,2,1,
	    %( %p(12) %w(16) %p(18) %w(22) %p(24) %c(2,28) ),
	    %( %rRemote ), 
	    %( %DevSpec ))

%SysRequest(244,ReceiveMail,vExchMailSer,10,2,0,3,
	    %( %w(12) %p(14) %w(18) %p(20) %c(2,24) %p(26) %c(12,30) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(245,ResetMailServer,vExchMailSer,11,2,0,0,
	    %( %w(12) ),
	    %( %rRemote ), 
	    %( %noRouting ))

%SysRequest(246,SendMail,vExchMailSer,12,4,2,1,
	    %( %w(12) %p(16) %w(20) %p(22) %w(26) %p(28) %c(12,32) %w(14) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(247,SignoffMailUser,vExchMailSer,13,4,1,0,
	    %( %p(16) %w(20) %p(12) ),
	    %( %rRemote ), 
	    %( %DevSpec ))

%SysRequest(248,TerminateMailConnection,vExchMailSer,14,2,0,0,
	 	%( %w(12) ),
	    %( %rRemote ), 
	    %( %rFh %closeFh ))

%SysRequest(249,ValidateMail,vExchMailSer,15,2,2,2,
	    %( %w(12) %p(14) %w(18) %p(20) %w(24)
	       %p(26) %c(1,30) %p(32) %c(2,36) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(250,SetMailAgentStatus,vExchMailSer,16,2,1,0,
	    %( %w(12) %p(14) %w(18) ),
	    %( %rRemote ), 
	    %( %rFh ))

%SysRequest(251,PurgeMailUniqueId,vExchMailSer,17,2,0,0,
	    %( %none),
	    %( %rRemote ), 
	    %( %noRouting ))

%SysRequest(252,SetNode,vExchResex,0D16h,6,1,0,
	    %( %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(253,ExpandSpec,vExchFilSys1,0806h,6,2,1,
	    %( %pbcb0 %pbcb1 %pbcb2 %fh ),
	    %( %rLocal ),
	    %( %NoRouting ))

%SysRequest(254,QueryExchange,vExchResex,0D18h,6,0,1,
	    %( %fh %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %NoRouting ))

%SysRequest(255,SetVideoTimeout,vExchKbd,000Bh,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(256,ReadActionKbd,vExchKbd,000Ch,6,0,1,
	    %( %b(12) %p0 %c(1,22) ),
	    %( %rLocal ),
	    %( %NoRouting ))

%SysRequest(257,ReadKbdStatus,vExchKbd,000Dh,6,0,2,
	    %( %w(12) %p0 %c(2,22) %p1 %c(1,28) ),
	    %( %rLocal ),
	    %( %NoRouting ))

%SysRequest(258,NotifyCM,lExchNotPresent,0,6,1,0,
	    %( %w(12) %pbcb0 ),
	    %( %rLocal ),
	    %( %NoRouting ))

%SysRequest(259,ChangeUserNumMail,vExchMailSer,18,2,0,0,
	    %( %w(12) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(260,QuietMailUser,vExchMailSer,19,2,0,0,
	    %( %w(12) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(261,OSVersion,vExchKbd,0500h,0,0,1,
	    %( %p(12) %c(2,16) ),
	    %( %rLocal ),
	    %( %NoRouting ))

%SysRequest(262,LoadInterActiveTask,lExchTerm,0100h,6,2,0,
	    %( %w(12) %p(18) %w(22) %p(24) %w(28) %w(14) %w(16)),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(263,TerminateISAMServer,vExchISAM,001Bh,0,0,2,
	    %( %p(12) %c(2,16) %p(18) %c(4,22)),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(264,MapXBusWindow,vExchResex,0D1Ah,6,0,2,
	    %( %b(12) %b(13) %p(18) %c(4,22) %w(14) %p(24)
            %c(2,28) %w(16)),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(265,QuietKbdForSwap,vExchKbd,0000h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))	; *2

%SysRequest(266,Purge3270Em,lExchNotPresent,0000h,2,0,0,
	    %(  ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(267,PurgeX25,lExchNotPresent,0000h,2,0,0,
	    %(  ),
	    %(%rDevice),
	    %( %noRouting ))	;*2

%SysRequest(268,SetTrapHandler,vExchResex,0D0Bh,12,0,0,
	    %( %w(12) %p(14)  %c(0FFh, 22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(269,QueryNodeForMailUser,vExchMailSer,20,0,2,2,
	 	%( %p(12) %w(16) %p(18) %w(22) %p(24) %w(28) %p(30) %c(2,34) ),
	    %( %rRemote ),
	    %( %DevSpec ))

%SysRequest(270,(CtNetTermination),vExchNotInstalled,0000h,2,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(271,QueryRequestInfo,vExchResex,0D18h,6,0,1,
	    %( %fh %pbcb0 ),
	    %( %rLocal ),
	    %( %NoRouting ))

%SysRequest(272,GetUserStatus,vExchResex,0700h,6,0,1,
	    %( %fh %pbcb0 ),
	    %( %rUserID ),
	    %( %noRouting )) 

%SysRequest(273,CMTermination,lExchNotPresent,0000h,2,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(274,FilterProsTermination,vExchFilterPros2,0000h,2,0,0,
	    %( %none ),
	    %( %rBroadcast ),
	    %( %noRouting ))

%SysRequest(275,VacatePartitionA,vExchTask,0E01h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(276,VacatePartitionB,vExchTask,0E02h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(277,SetVectorArea,vExchResex,0D1Bh,6,0,1,
	    %( %fh %w(14) %p0 %c(1,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(278,AllocAreaSL,vExchMem,0D1Ch,6,0,1,
	    %( %w(12) %p0 %c(4,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(279,ExpandAreaSL,vExchMem,0D1Dh,6,0,1,
	    %( %w(12) %w(14) %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(280,ExpandAreaLL,vExchMem,0D1Eh,6,0,1,
	    %( %w(12) %w(14) %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(281,ShrinkAreaSL,vExchMem,0D1Fh,6,0,0,
	    %( %p(14) %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(282,ShrinkAreaLL,vExchMem,0D20h,6,0,0,
	    %( %p(14) %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(283,QueryBigMemAvail,vExchMem,0D21h,6,0,1,
	    %( %p0 %c(4,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(284,CreateAlias,vExchMem,0D22h,6,0,1,
	    %( %p(14) %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(285,SetSegmentAccess,vExchMem,0D23h,6,0,0,
	    %( %w(12) %b(14) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(286,SetColorData,lExchVideo,0C04h,0,2,2,
	    %( %p(12) %w(16) %pbcb0 %pbcb1 %pbcb2  ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(287,ProgramColorMapper,lExchNotPresent,0,0,2,2,
	    %( %p(12) %w(16) %pbcb0 %pbcb1 %pbcb2  ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(288,SetCommISRRawSFN,vExchCommLine,0304h,30,0,0,
	    %( %w(12) %p(14) %p(18) %p(22) %p(26)
	    %p(30) %w(34) %w(36) %w(38) %w(40)),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(289,OpenQueue,vExchQueMgr,0000h,4,2,0,
	    %( %p(16) %w(20) %p(22) %w(26) %w(12) %w(14)),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(290,ResetMemorySL,vExchSched,15,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(291,ResetAllSegs,vExchSched,16,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(292,FreeLargeLL,vExchSched,17,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(293,LoadFile,vExchMem,0A00h,10,0,3,
	    %( %fh %w(14) %w(16) %w(18) %c(0,20) %p(22) %w(26) %p(28) %w(32) %p(34) %w(38) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(294,ReOpenFile,vExchFilSys1,0001h,6,2,1,
	    %( %c(2,34) %p2 %pbcb0 %pbcb1 %w(14) ),
	    %( %rLocal ),
	    %( %FileSpec %SpecPW %openFh %CloseAtTermination))

%SysRequest(295,SwapInContext,vExchSched,22,2,0,0,
	    %( %fh ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(296,CreateUser,vExchSched,22,6,1,1,
	    %( %p(18) %w(22) %w(12) %c(4,14) %p(24) %c(2,28) %w(16) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(297,GetHandleStatus,vExchFilSys1,0702h,6,1,1,
	    %( %pbcb0 %fh %pbcb1 ),
	    %( %rDevice ),
	    %( %DevSpec ))

%SysRequest(298,Unused,0,0,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(299,AllocMemoryReal,lExchObsolete,18,6,0,1,
	    %( %w(12) %p0 %c(4,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(300,DeallocMemoryReal,lExchObsolete,18,6,0,0,
	    %( %p(14) %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(301,CallSourceDbgNub,vExchKbd,0600h,6,1,1,
	    %( %fh %p0 %c(2,22) %p1 %c(4,28) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(302,GetNodeName,vExchNotInstalled,0,0,0,2,
	    %( %p(12) %w(16) %p(18) %c(2,22) ),
	    %( %rRemote ),
	    %( %noRouting ))

%SysRequest(303,ReadSwap,vExchSched,22,6,0,3,
	    %( %fh %w(16) %w(14) %pbcb0 %p1 %c(2,28) %p2 %c(2,34) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(304,WriteSwap,vExchSched,22,6,1,0,
	    %( %fh %w(16) %w(14)  %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(305,DeactivateRunFile,vExchSched,22,2,0,0,
	    %( %fh ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(306,GetMemoryInfo,vExchSched,24,6,0,2,
	    %( %pbcb0 %p1 %c(2,28) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(307,ReservedForOem,0,0,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(308,AllocUserNumbers,vExchResex,0D80h,6,0,1,
		%( %fh %p0 %c(6,22) %c(0,23) ),
	    %( %rLocal ),
		%( %noRouting ))

%SysRequest(309,DeallocUserNumbers,vExchResex,0D81h,6,0,0,
		%( %fh ),
	    %( %rLocal ),
		%( %noRouting ))

%SysRequest(310,SetDeviceHandler,vExchResex,0D0Bh,12,0,0,
	    %( %w(12) %p(14) %w(18) %w(22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(311,RemoteBootCopy,vExchResex,0100h,18,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(312,GetRouteTable,vExchResex,0D19h,6,0,1,
	    %( %fh %pbcb0 ),
	    %( %rMasterFP ),
	    %( %noRouting ))

%SysRequest(313,UpdateRouteTable,vExchResex,0D11h,6,1,0,
	    %( %fh %pbcb0 ),
	    %( %rMasterFP ),
	    %( %noRouting ))

%SysRequest(314,QueryBoardInfo,vExchResex,0D12h,6,0,1,
	    %( %w(12) %w(14) %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(315,GetWsStatus,vExchNotInstalled,0,4,0,1,
	    %( %w(12) %w(14) %p(16) %w(20) ),
	    %( %rUserId ),
	    %( %noRouting ))

%SysRequest(316,SetWsStatus,vExchNotInstalled,0,4,1,0,
	    %( %w(12) %w(14) %p(16) %w(20) ),
	    %( %rUserId ),
	    %( %noRouting ))

%SysRequest(317,AvailableForUse,vExchNotInstalled,0,2,0,1,
	    %( %w(12) %p(14) %w(18) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(318,DoDirectRead,vExchFilSys2,0100h,6,1,2,
	    %( %fh %pbcb0 %pbcb1 %pbcb2 %w(14) %w(16) ),
	    %( %rLocal ),
	    %( %rFh %RW ))

%SysRequest(319,DoDirectWrite,vExchFilSys2,0101h,6,2,1,
	    %( %fh %pbcb0 %pbcb1 %pbcb2 %w(14) %w(16) ),
	    %( %rLocal ),
	    %( %rFh %RW ))

%SysRequest(320,DefineLocalPageMap,vExchMem,lscResexVpOnly,8,0,0,
	    %( %p(12) %w(16) %w(18) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(321,MapXBusWindowLarge,vExchResex,0D25h,6,0,3,
	    %( %b(12) %b(13) %p(18) %w(22) %p(30) %c(2,34) %w(14)
            %p(24) %c(2,28) %w(16)),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(322,Set386TrapHandler,vExchResex,0D0Bh,12,0,0,
	    %( %w(12) %p(14)  %c(255, 22) %c(255, 23) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(323,ServiceOverlayA,vExchSched,0,2,1,0,
	    %( %p(14) %c(2, 18) %c(0, 19) %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(324,ServiceOverlayB,vExchSched,0,4,0,0,
	    %( %w(14) %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(325,AllocMemoryFrameSL,vExchMem,lscResexVpOnly,6,0,1,
	    %( %w(12) %p0 %c(4,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(326,InitLocalPageMap,vExchMem,lscResexVpOnly,4,0,0,
	    %( %p(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(327,LinkFile,vExchFilSys1,0014h,6,2,0,
	    %( %fh %pbcb0 %pbcb1 ),
	    %( %rLocal ),
	    %( %rFh %FileSpec %SpecPw ))

%SysRequest(328,MakeDirectory,vExchFilSys1,0003h,6,3,0,
	    %( %pbcb0 %pbcb1 %pbcb2 %w(14) %w(16) ),
	    %( %rLocal ),
	    %( %FileSpec %SpecPW ))

%SysRequest(329,RemoveDirectory,vExchFilSys1,0004h,2,0,0,
	    %( %fh ),
	    %( %rHandle ),
	    %( %rFh %closeFh ))

%SysRequest(330,ProgramColorPalette,lExchVideo,0B85h,0,2,2,
		%( %p(12) %w(16) %p(18) %w(22) %p(24) %w(28) %p(30) %w(34) ),
	    %( %rLocal ),
		%( %noRouting ))

%SysRequest(331,CreateBigPartition,vExchUser,0F00h,6,1,1,
	    %( %p(18) %w(22) %w(16) %w(12) %b(14) %p(24) %c(2,28) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(332,SgFromSn,vExchSched,30,6,0,1,
	    %( %w(16) %w(14) %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(333,AllocLdtSlot,vExchSched,31,6,0,1,
	    %( %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(334,FSCableDrop,vExchFilSys1,0808h,6,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(335,FilterDebugInterrupts,vExchResex,0D26h,6,0,0,
	    %( %w(12) %w(14) %b(16) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(336,RemakeAliasForServer,vExchSched,32,6,0,1,
	    %( %w(16) %w(14) %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(337,DeallocAliasForServer,vExchSched,33,6,0,0,
	    %( %w(16) %w(14) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(338,AllocMemoryPermanent,vExchMem,lscResexVpOnly,6,0,1,
	    %( %w(12) %p0 %c(4,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(339,SetDefaultTrapHandler,vExchResex,0D0Bh,12,0,1,
	    %( %w(12) %p(14)  %p1 %c(0FFh, 22) %c(4,28) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(340,QueryDeviceNames,vExchAgentOrResex2,0D0Fh,6,1,2,
	    %( %pbcb0 %pbcb1 %p2 %c(2,34) ),
	    %( %rMasterFp ),
	    %( %DevSpec ))

%SysRequest(341,ShrinkPartition,vExchUser,lscResexVpOnly,0,0,0,
	    %( %none),
	    %( %rLocal ),
	    %( %none))

%SysRequest(342,CreateExpandDownAlias,vExchSched,36,6,0,1,
	    %( %p(14) %w(12) %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(343,AccessSystemCall,vExchMem,lscResexVpOnly,4,0,1,
	    %( %w(12) %w(14) %p(16) %c(4,20) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(344,InstallNet,vExchKbd,0700h,6,1,0,
	    %( %fh %pbCb0 ),
	    %( %rBroadcast ),
	    %( %noRouting ))

%SysRequest(345,DeallocSg,vExchMem,lscResexVpOnly,6,0,0,
	    %( %w(12) %w(14)),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(346,QueryDeviceName,vExchAgentOrResex2,0D0Fh,6,1,2,
	    %( %pbcb0 %fh %pbcb1 %p2 %c(2,34) ),
	    %( %rMasterFp ),
	    %( %DevSpec ))

%SysRequest(347,ReadKbdDataDirect,vExchKbd,0001h,6,0,1,
	    %( %w(12) %pbcb0 ),
	    %( %rLocal ),
	    %( %NoRouting ))

%SysRequest(348,SetIBusHandler,vExchKbd,0600h,6,0,0,
	    %( %w(12) %p(14)),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(349,ResetIBusHandler,vExchKbd,0600h,6,0,0,
	    %( %w(12) %p(14)),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(350,LoadRunFile,lExchTerm,0004h,6,0,2,
	    %( %fh %w(14) %w(16) %p0 %c(4,22) %pbcb1 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(351,DeallocRunFile,vExchMem,lscResexVpOnly,6,0,0,
	    %( %w(14) %w(12)),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(352,SetFSConfigParams,vExchFilSys1,080Ah,6,1,0,
	    %( %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(353,GetSCSIInfo,vExchFilSys1,080Bh,6,0,2,
	    %( %w(12) %w(14) %w(16) %pbcb0 %p1 %c(2,28)),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(354,ReservePartitionMemory,vExchMem,40,6,0,1,
	    %( %w(12) %w(14) %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(355,OpenScsiPath,vExchNotInstalled,0000h,6,3,1,
	    %( %pbcb0 %b(12) %b(13) %b(14) %p3 %c(2,40) %pbcb2 %pbcb1 %w(16) ),
	    %( %rDevice ),
	    %( %DevSpec %SpecPW %OpenFh ))

%SysRequest(356,GetScsiPathParameters,vExchNotInstalled,0200h,6,0,1,
	    %( %ph %pbcb0 ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(357,SetScsiPathParameters,vExchNotInstalled,0200h,6,1,0,
	    %( %ph %pbcb0 ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(358,CloseScsiPath,vExchNotInstalled,0100h,2,0,0,
	    %( %ph ),
	    %( %rDevice ),
	    %( %rFh %CloseFh ))

%SysRequest(359,ScsiReset,vExchNotInstalled,0600h,4,0,0,
	    %( %ph %b(14) ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(360,ScsiCdbDataIn,vExchNotInstalled,0303h,6,1,4,
	    %( %ph %w(16) %pbcb0 %pbcb1 %p2 %c(2,34) %p3 %c(1,40) %pbcb4 ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(361,ScsiCdbDataOut,vExchNotInstalled,0302h,6,2,3,
	    %( %ph %w(16) %pbcb0 %pbcb1 %p2 %c(2,34) %p3 %c(1,40) %pbcb4 ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(362,ScsiRequestSense,vExchNotInstalled,0383h,6,1,4,
	    %( %ph %w(16) %pbcb1 %p2 %c(2,34) %p3 %c(1,40) ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(363,ScsiManagerNameQuery,vExchNotInstalled,0800h,6,1,1,
	    %( %pbcb0 %pbcb1 ),
	    %( %rDevice ),
	    %( %DevSpec ))

%SysRequest(364,GetPartitionSwapMode,vExchTask,0F08h,2,0,1,
	    %( %w(12) %p(14) %c(2,18) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(365,SetPartitionSwapMode,vExchTask,0F09h,4,0,0,
	    %( %w(12) %w(14) ),
	    %( %rLocal ), 
	    %( %noRouting ))

%SysRequest(366,QueryDiskGeometry,vExchFilSys1,80Ch,6,2,1,
	    %( %pbcb0 %pbcb1 %pbcb2 ),
	    %( %rLocal ),
	    %( %DevSpec %SpecPW ))

%SysRequest(367,SetDiskGeometry,vExchFilSys1,80Dh,6,3,0,
	    %( %pbcb0 %pbcb1 %pbcb2 ),
	    %( %rLocal ),
	    %( %DevSpec %SpecPW ))

%SysRequest(368,GetRemoteStructure,vExchFilSys4,0702h,6,1,2,
	    %( %pbcb0 %lfa %w(12) %pbcb1 %p2 %c(2,34) ),
	    %( %rLocal ),
	    %( %DevSpec ))

%SysRequest(369,GetRemotepStructure,vExchFilSys4,0703h,6,1,1,
	    %( %pbcb0 %w(12) %w(14) %p1 %c(4,28) ),
	    %( %rLocal ),
	    %( %DevSpec ))

%SysRequest(370,TerminateScsiUser,vExchNotInstalled,0700h,2,0,0,
	    %( %none ),
	    %( %rDevice ),
	    %( %noRouting ))	; *2

%SysRequest(371,QuietScsiUserForSwap,vExchNotInstalled,0700h,2,0,0,
	    %( %none ),
	    %( %rDevice ),
	    %( %noRouting ))	; *2

%SysRequest(372,AllocateDiskPages,vExchFilSys1,0703h,6,1,1,
	    %( %fh %p0 %c(4, 22) %p1 %c(4, 28) %b(14) %w(16) ),
	    %( %rHandle ),
	    %( %rFh ))

%SysRequest(373,LockInCache,vExchFilSys2,0400h,12,0,1,
	    %( %fh %lfa %c(0,18) %c(0,20) %s0 %p1 %c(2,28) ),
	    %( %rHandle ),
	    %( %rFh %RW ))

%SysRequest(374,UnLockInCache,vExchFilSys2,0400h,12,0,1,
	    %( %fh %lfa %c(0,18) %c(0,20) %s0 %p1 %c(2,28) ),
	    %( %rHandle ),
	    %( %rFh %RW ))

%SysRequest(375,RemoteCacheUp,vExchFilSys1,080Eh,0,3,0,
	    %( %none ),
	    %( %rDevice ),
	    %( %DevSpec ))		; *2

%SysRequest(376,RemoteCacheOpen,lExchRCS,0,2,4,1,
	    %( %p(14) %w(18) %p(20) %w(24) %p(26) %c(8,30) %p(32) %c(8,36) %w(12) %p(38) %c(4,42) ),
	    %( %rDevice ),
	    %( %DevSpec %SpecPW %openFh %CloseAtTermination ))

%SysRequest(377,RemoteCacheClose,lExchRCS,8001h,4,0,0,
	    %( %p(12) ),
	    %( %rDevice ),
	    %( %rFh %closeFh ))

%SysRequest(378,RemoteCacheGetStatistics,lExchRCS,8002h,4,0,2,
	    %( %p(12) %p(16) %w(20) %p(22) %c(2,26) ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(379,RemoteCacheGetEntry,lExchRCS,0C003h,8,2,1,
	    %( %p(12) %p(26) %c(8,30) %w(16) %p(32) %c(4,36) %p(20) %w(24) %w(18) ),
	    %( %rDevice %dmaRemote ),
	    %( %rFh %RW ))

%SysRequest(380,RemoteCacheReleaseEntry,lExchRCS,0C004h,14,1,0,
	    %( %p(12) %p(18) %w(24) %w(26) %p(30) %w(34) %w(28) ),
	    %( %rDevice %dmaRemote ),
	    %( %rFh %RW ))

%SysRequest(381,RemoteCacheFlush,lExchRCS,8005h,8,2,1,
	    %( %p(12) %p(20) %c(8,24) %p(26) %c(8,30) %w(16) %w(18) %p(32) %c(2,36) ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(382,RemoteCacheProbe,lExchRCS,0E006h,10,1,0,
	    %( %none ),
	    %( %rDevice %dmaRemote ),
	    %( %rFh %RW ))		;MassIo use only

%SysRequest(383,RemoteCacheRelease,lExchRCS,0E007h,10,1,0,
	    %( %none ),
	    %( %rDevice %dmaRemote ),
	    %( %rFh %RW ))		;MassIo use only

%SysRequest(384,ResetRemoteCache,lExchRCS,8,2,0,0,
	    %( %none ),
	    %( %rDevice ),
	    %( %noRouting ))	;Termination

%SysRequest(385,QuietRemoteCache,lExchRCS,8,2,0,0,
	    %( %none ),
	    %( %rDevice ),
	    %( %noRouting ))	;Swapping

%SysRequest(386,RemoteCacheControl,lExchRCS,9,2,1,1,
	    %( %w(12) %p(14) %w(18) %p(20) %w(24) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(387,ScsiTargetDataReceive,vExchNotInstalled,0406h,6,0,5,
	    %( %ph %pbcb1 %pbcb0  %p2 %c(2,34) %p3 %c(1,40) %pbcb4 ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(388,ScsiTargetDataTransmit,vExchNotInstalled,0407h,6,1,4,
	    %( %ph %pbcb1 %pbcb0 %p2 %c(2,34) %p3 %c(1,40) %pbcb4 ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(389,CheckScsiTargetCdb,vExchNotInstalled,0504h,6,0,2,
	    %( %ph %p0 %pbcb1 ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(390,WaitScsiTargetCdb,vExchNotInstalled,0504h,6,0,2,
	    %( %ph %p0 %pbcb1 ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(391,GetSerialNumber,vExchResex,0D29h,6,0,1,
		%( %w(12) %p0 %c(4,22) ),
	    %( %rFileId ),
	    %( %noRouting ))

%SysRequest(392,ConfigurationQuery,vExchResex,0D28h,6,2,2,
		%( %pbcb0 %pbcb1 %pbcb2 %p3 %c(2,40) ),
		%( %rDevice ),
		%( %devSpec ))

%SysRequest(393,RemoteCacheGetStatus,lExchRCS,800Ah,4,1,1,
	    %( %p(12) %p(16) %c(8,20) %p(22) %c(2,26) ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(394,GetMemoryInfoPiece,vExchSched,41,6,0,2,
	    %( %w(12) %pbcb0 %p1 %c(2,28) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(395,LockFile,vExchFilSys1,001Eh,6,2,1,
		%( %c(2,34) %p2 %pbcb0 %pbcb1 %w(14) %w(12) ),
	    %( %FileSpec %SpecPW %openFh ))

%SysRequest(396,UnlockFile,vExchFilSys1,001Fh,2,0,0,
	    %( %fh ),
	    %( %rFh %closeFh))

%SysRequest(397,GetVerifyCode,vExchFilSys1,080Fh,6,1,1,
		%( %pbcb0 %p1 %c(2,28) ),
	    %( %rDevice ),
	    %( %DevSpec ))

%SysRequest(398,SetVerifyCode,vExchFilSys1,0810h,6,1,0,
		%( %pbcb0 %w(12) ),
	    %( %rDevice ),
	    %( %DevSpec ))

%SysRequest(399,ReadOSKbdTable,vExchKbd,0010h,6,1,0,
	    %( %w(12) %pbcb0 ),
	    %( %rLocal ),
	    %( %NoRouting ))

%SysRequest(400,PostKbdTable,vExchKbd,0010h,6,1,0,
	    %( %w(12) %pbcb0 ),
	    %( %rLocal ),
	    %( %NoRouting ))

%SysRequest(401,SetKeyboardID,vExchKbd,0011h,6,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %NoRouting ))

%SysRequest(402,WriteKbdBuffer,vExchKbd,0012h,6,1,1,
	    %( %w(12) %w(14) %w(16) %pbcb0 %p1 %c(2,28)),
	    %( %rLocal ),
	    %( %NoRouting ))

;  Now goes to SysIn Process for handling
%SysRequest(403,ReadKbdInfo,lExchSysIn,0001h,6,0,1,
	    %( %w(12) %pbcb0 ),
	    %( %rLocal ),
	    %( %NoRouting ))

%SysRequest(404,ConfigurationUpdate,vExchResex,0D2Ah,6,2,0,
		%( %pbcb0 %pbcb1 ),
		%( %rDevice ),
		%( %devSpec ))

%SysRequest(405,AbortScsiTargetOperations,vExchNotInstalled,0900h,2,0,0,
	    %( %ph ),
	    %( %rDevice ),
	    %( %rFh ))

%SysRequest(406,SemOpen,lExchTerm,0007h,4,1,1,
	    %( %w(18) %w(16) %w(20) %w(12) %w(24) %w(22) %c(0,14) %c(4,26) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(407,SemClose,lExchTerm,0008h,4,0,0,
	    %( %w(14) %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(408,LibLoad,vExchSched,0A00h,6,2,3,
	    %( %pbcb0 %pbcb1 %pbcb2 %p3 %c(2,40) %p4 %c(2,46)),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(409,Unused,0,0,0,0,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(410,NameRegister,vExchSched,1000h,8,1,0,
	    %( %p(20) %w(24) %w(12) %b(14) %w(18) %w(16)),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(411,NameQuery,vExchSched,1001h,8,1,1,
	    %( %p(20) %w(24) %w(12) %b(14) %p(26) %c(4,30)),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(412,NameRemove,vExchSched,1002h,8,1,0,
	    %( %p(20) %w(24) %w(12) %b(14)),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(413,NameTermination,vExchSched,1003h,2,0,0,
	    %( %w(12)),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(414,NameGetUniqueClassObsolete,vExchSched,1004h,8,0,1,
	    %( %p(20) %c(2,24)),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(415,MapPages,lExchNotPresent,0000h,24,0,0,
	    %( %w(12) %w(14) %w(18) %w(16) %w(20) %w(22) %w(26) %w(24) %w(28) %w(30) %w(34) %w(32) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(416,LockPages,lExchNotPresent,0000h,8,0,0,
	    %( %w(12) %w(14) %w(18) %w(16) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(417,SetPagingParameters,lExchNotPresent,0000h,4,1,0,
	    %( %w(12) %w(14) %w(18) %w(16) %w(20) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(418,MapUninitializedPages,lExchNotPresent,0000h,10,0,0,
	    %( %w(12) %w(14) %w(18) %w(16) %w(20)  ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(419,MapAbsolutePages,lExchNotPresent,0000h,14,0,0,
	    %( %w(12) %w(14) %w(16) %w(20) %w(18) %w(24) %w(22)  ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(420,RemapPages,lExchNotPresent,0000h,14,0,0,
	    %( %w(12) %w(14) %w(18) %w(16) %w(22) %w(20)  ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(421,CreateLocalPageMap,lExchNotPresent,0000h,8,0,1,
	    %( %w(12) %w(14) %w(18) %w(16) %p(20) %c(4,24)   ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(422,MapLocalPagesToLockedGla,lExchNotPresent,0000h,12,0,0,
	    %( %w(12) %w(14) %w(18) %w(16) %w(22) %w(20)  ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(423,QueryPagingStatistics,lExchNotPresent,0000h,2,0,2,
	    %( %w(12) %w(16) %w(14) %w(18) %w(22) %w(20) %c(2,24) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(424,AliasPages,lExchNotPresent,0000h,12,0,0,
	    %( %w(12) %w(14) %w(18) %w(16) %w(22) %w(20)  ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(425,LibFree,vExchSched,0A00h,6,0,0,
	    %( %fh ),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(426,LibGetNameObsolete,vExchSched,0A00h,6,0,2,
	    %( %fh %pbcb0 %p1 %c(2,28) ),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(427,LibGetHandle,vExchSched,0A00h,6,1,1,
	    %( %pbcb0 %p1 %c(2,28) ),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(428,LibGetProcInfo,vExchSched,0A00h,6,1,1,
	    %( %fh %pbcb0 %pbcb1 ),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(429,SetExitList,lExchQuiet,0000h,6,0,0,
	    %( %fh %lfa ),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(430,ReassignPages,lExchNotPresent,0000h,10,0,0,
	    %( %w(12) %w(14) %w(16) %w(20) %w(18) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(431,QuietUser,lExchQuiet,0000h,4,0,0,
	    %( %fh  %b(14)),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(432,UserNumFromGla,vExchMem,42,6,0,1,
	    %( %lfa %p0 %c(2,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(433,AllocateSegment,vExchMem,43,6,0,1,
	    %( %w(14) %w(12) %w(16) %p(18) %c(6,22) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(434,ResizeSegment,vExchMem,44,6,0,1,
	    %( %w(12) %w(16) %w(14) %p(18) %c(4,22)),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(435,DeallocateSegment,vExchMem,45,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(436,MapDmaBuffer,vExchMem,46,16,1,2,
	    %( %c(0,28) %w(30) %c(1,32) %d(14) %d(18) %w(22) %p(34) %c(4,38) %p(40)
		%c(4,44) %w(24) %w(26) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(437,ScrubFile,vExchFilSys1,0018h,2,0,0,
		%( %fh ),
		%( %rFh %closeFh ))

%SysRequest(438,UndeleteFile,vExchFilSys1,0019h,6,2,0,
		%( %fh %pbcb0 %pbcb1 ),
		%( %FileSpec %SpecPW ))

%SysRequest(439,UpdateBSACResourceStatus,vExchFilSys1,001ch,2,1,0,
		%( %w(12) %p(14) %w(18) ),
		%( %noRouting ))

%SysRequest(440,UpdateResourceRights,vExchFilSys1,001bh,6,3,0,
		%( %w(12) %p(18) %w(22) %p(24) %w(28) %p(30) %w(34) ),
		%( %noRouting ))

%SysRequest(441,QueryResourceRights,vExchFilSys1,001dh,6,2,1,
		%( %w(12) %p(18) %w(22) %p(24) %c(2, 28) ),
		%( %noRouting ))


%SysRequest(442,SetDefault386TrapHandler,vExchResex,0D0Bh,12,0,1,
	    %( %w(12) %p(14)  %p1 %c(0FFh, 22) %c(0FFh, 23) %c(4,28) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(443,GetModuleResourceInfo,vExchSched,0A00h,6,0,1,
	    %( %w(12) %w(14) %w(16) %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(444,GetModuleResourceDirInfo,vExchSched,0A00h,6,0,1,
	    %( %w(12) %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(445,LocalDiskMirroringRq,vexchMassIO,8000h,4,1,1,
		%( %w(12) %w(14) %pbcb0 %pbcb1),
	    %( %rLocal ),
		%( %DevSpec ))

%SysRequest(446,NotifyVam,lExchNotPresent,0000h,6,1,1,
	    %( %w(12) %w(14) %pbcb0 %pbcb1 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(447,ResumeTranslation,vExchKbd,013h,6,1,1,
	    %( %w(12) %pbcb0 %pbcb1 ),
	    %( %rLocal ),
	    %( %NoRouting ))

%SysRequest(448,SetKeyboardOptions,vExchKbd,015h,6,1,1,
	    %( %w(12) %pbcb0 %pbcb1 ),
	    %( %rLocal ),
	    %( %NoRouting ))

%SysRequest(449,GetKeyboardID,vExchKbd,0014h,6,0,1,
		%( %p0 %c(2,22) ),
	    %( %rLocal ),
		%( %norouting ))

%SysRequest(450,AllocHugeMemory,vExchSched,47,10,0,1,
		%( %w(16) %w(14) %w(20) %w(18) %w(12) %p(22) %c(2,26) ),
	    %( %rLocal ),
		%( %norouting ))

%SysRequest(451,DeallocHugeMemory,vExchSched,48,6,0,0,
		%( %w(12) ),
	    %( %rLocal ),
		%( %norouting ))

%SysRequest(452,MapFile,lExchNotPresent,0000h,14,0,0,
		%( %w(12) %w(16) %w(14) %w(20) %w(18) %w(22) %w(24) %p(26) %w(30)
		%p(32) %w(36) ),
	    %( %rLocal ),
		%( %norouting ))

%SysRequest(453,AllocateNVArea,lExchNotPresent,0,6,1,0,
	    %( %pbcb0 %w(14) %b(16) ),
		%( %rLocal ),
		%( %noRouting ))

%SysRequest(454,DeallocateNVArea,lExchNotPresent,1,6,1,0,
		%( %pbcb0 ),
		%( %rLocal ),
		%( %noRouting ))

%SysRequest(455,InitializeNvram,lExchNotPresent,2,6,0,0,
		%( %b(12) %b(13) ),
		%( %rLocal ),
		%( %noRouting ))

%SysRequest(456,QueryNvConfiguration,lExchNotPresent,3,6,2,1,
		%( %pbcb0 %pbcb1 %p2 %c(2,34) ),
		%( %rLocal ),
		%( %noRouting ))

%SysRequest(457,ReadNvArea,lExchNotPresent,4,6,0,1,
		%( %fh %p0 %w(14) %w(16) %b(22) ),
		%( %rLocal ),
		%( %noRouting ))

%SysRequest(458,WriteNvArea,lExchNotPresent,5,6,1,1,
		%( %fh %p0 %w(14) %w(16) %p1 %c(2,28) %b(22) ),
		%( %rLocal ),
		%( %noRouting ))

%SysRequest(459,OpenNvArea,lExchNotPresent,6,6,1,1,
	    %( %c(2,24) %p1 %pbcb0 ),
		%( %rLocal ),
		%( %noRouting ))

%SysRequest(460,CloseNvArea,lExchNotPresent,7,2,0,0,
		%( %fh ),
		%( %rLocal ),
		%( %noRouting ))

%SysRequest(461,ResetTrapHandler,vExchResex,0D2Bh,6,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(462,TerminateNvram,lExchNotPresent,8,2,0,0,
		%( %w(12) ),
		%( %rLocal ),
		%( %noRouting ))

%SysRequest(463,ReallocHugeMemory,vExchSched,49,6,0,0,
		%( %w(12) %w(16) %w(14) ),
	    %( %rLocal ),
		%( %norouting ))

%SysRequest(464,SetIoOwner,vExchSched,50,6,1,1,
		%( %pbcb0 %p1 %c(2,28) ),
	    %( %rLocal ),
		%( %norouting ))

%SysRequest(465,DebugOp,0,0000h,6,2,1,
		%( %pbcb0 %pbcb1 %pbcb2 ),
		%( %rLocal ),
		%( %noRouting ))

%SysRequest(466,QueryIoOwner,vExchSched,51,6,0,2,
		%( %w(12) %pbcb0 %p1 %c(2,28) ),
	    %( %rLocal ),
		%( %norouting ))

%SysRequest(467,MapPhysicalAddress,vExchSched,52,10,0,1,
		%( %d(14) %d(18) %w(12) %p(22) %c(4,26) ),
	    %( %rLocal ),
		%( %norouting ))

%SysRequest(468,UnmapPhysicalAddress,vExchSched,53,10,0,0,
		%( %d(14) %d(18) %w(12) ),
	    %( %rLocal ),
		%( %norouting ))

%SysRequest(469,ResetDeviceHandler,vExchResex,0D2Ch,6,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(470,QueryTrapHandler,vExchResex,0D2Dh,6,0,1,
	    %( %w(12) %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))
;
;  3.3 released
;

%SysRequest(471,ExitListQuery,lExchQuiet,0,6,0,1,
	    %( %w(12) %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(472,LibGetInfo,vExchSched,0A00h,6,0,2,
	    %( %w(12) %w(14) %pbcb0 %p1 %c(2,28) ),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(473,SetOSKernelHooks,vExchResex,0D2Eh,6,1,0,
	    %( %pbcb0 ), 
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(474,QueryOSKernelHooks,vExchResex,0D2Fh,6,0,1,
	    %( %pbcb0 ), 
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(475,CloneData,vExchSched,53,6,0,0,
	    %( %w(12) %w(14) %w(16) ), 
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(476,NameAllocClass,vExchSched,1004h,8,0,1,
	    %( %p(20) %c(2,24) %b(12)),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(477,LockUser,vExchSched,0,4,0,0,
	    %( %w(12) %w(14)),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(478,SetUserInfo,vExchMem,55,6,1,0,
	    %( %w(12) %pbcb0 ),
	    %( %rLocal ),
	    %( %noRouting))

%SysRequest(479,GetFileInfoByName,vExchFilSys1,0020h,6,2,1,
	    %( %pbcb0 %pbcb1 %w(12) %w(14) %pbcb2 ),
	    %( %rDevice ),
	    %( %DevSpec %SpecPW ))

%SysRequest(480,SetEBifHandler,vExchResex,0D30h,10,0,1,
	    %( %w(12) %p(22) %c(2,26) %w(14) %w(20) %w(18) %w(16) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(481,ResetEBifHandler,vExchResex,0D31h,2,0,0,
	    %( %w(12) ),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(482,ConfigFileNameQuery,vExchResex,0D32h,6,0,1,
	    %( %pbcb0),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(483,FileCacheFlush,vExchMassIo,0000h,2,0,0,
	    %( %none ),
	    %( %rBroadcast ),
	    %( %noRouting ))

%SysRequest(484,InstallAgent,vExchResex,0D33h,6,1,1,
	    %( %w(12) %pbCb0 %pbCb1),
	    %( %rLocal ),
	    %( %noRouting ))

%SysRequest(485,GetEISABusInfo,vExchResex,0D34h,6,0,1,
	    %( %w(12) %pbCb0 ),
	    %( %rMasterFp ),
	    %( %noRouting ))

%SysRequest(486,NotifyVam,lExchNotPresent,0A00h,4,0,0,
	    %( %w(12) %w(14) ),
	    %( %rLocal ),
	    %( %noRouting ))

; Subsequent requests up to 0FDFh (inclusive) are reserved for future expansion 
; by Convergent.
;
; NOTES --
; *1 ... Request number 25 (ReadDirSector) field for s2 is a
;        constant 512 (200h).  This is acheived by setting byte
;        35 of request block to 2,leaving byte 34 as 00h.
; *2 ... Request numbers 63,64,65,66,70,71,72,... are used
;        internally by CTOS.
;
%Request(1000h,ChangeUserNumISAM,vExchISAM,001Ch,2,0,0,
	%( %w(12) ),
	%( %rRemote ),
	%( %noRouting ))

%Request(1001h,QuietISAMUser,vExchISAM,001Dh,2,0,0,
	%( %w(12) ),
	%( %rRemote ),
	%( %noRouting ))

%Request(1002h,QuietContext,lExchTerm,0003h,2,0,0,
	%( %w(12) ),
	%( %rRemote ),
	%( %noRouting ))

%Request(1003h,QuietQMGR,vExchQueMgr,0h,2,0,0,
	%( %w(12) ),
	%( %rRemote ),
	%( %noRouting ))

%Request(1004h,QuietSplr,lExchSplr,0h,2,0,0,
	%( %w(12) ),
	%( %rRemote ),
	%( %noRouting ))

%Request(1005h,Execfh,lExchTerm,0005h,4,0,0,
	%( %w(12) %w(14) ),
	%( %rHandle ),
	%( %noRouting ))

%Request(1006h,InitCommLine,vExchCommLine,0300h,6,2,1,
	%( %pbcb0 %pbcb1 %pbcb2 ),
	%( %rLocal ),
	%( %noRouting ))

%Request(1007h,ResetCommLine,vExchCommLine,0301h,6,0,0,
	%(%w(12) ),
	%( %rLocal ),
	%( %noRouting ))

%Request(1008h,ChangeCommLineBaudRate,vExchCommLine,0302h,6,0,0,
	%(%w(12) %w(14) %w(16) ),
	%( %rLocal ),
	%( %noRouting ))

%Request(1009h,TerminateCommLine,lExchNotPresent,0000h,2,0,0,
	%(%w(12) ),
	%( %rLocal ),
	%( %noRouting ))

%Request(100Ah,ChangeUserNumCommLine,lExchNotPresent,0000h,2,0,0,
	%(%w(12) ),
	%( %rLocal ),
	%( %noRouting ))

%Request(100Bh,WaitSync,vExchNotInstalled,0000h,6,1,0,
	%(),
	%( %rDevice ),
	%( %DevSpec ))

%Request(100Ch,NewTapeIORead,vExchNotInstalled,0000h,6,0,3,
	%(),
	%( %rDevice %dmaRemote ),
	%( %rFh ))

%Request(100Dh,NewTapeIOWrite,vExchNotInstalled,0000h,6,1,2,
	%(),
	%( %rDevice %dmaRemote ),
	%( %rFh ))

%Request(100Eh,ReMakeFh,vExchFilSys1,000Fh,6,0,1,
	%( %none ),
	%( %rHandle ),
	%( %rFh %openFh %CloseAtTermination))

%Request(100Fh,KbdProsTerm,vExchKbd,0,2,0,0,
	%( %w(12) ),
	%( %rLocal ),
	%( %noRouting ))

%Request(1010h,SwapInContextAndLock,vExchSched,0,2,0,0,
	%( %fh ),
	%( %rLocal ),
	%( %noRouting ))

%Request(1011h,SetWsDaiNumber,vExchAgent,0707h,2,0,0,
	%( %fh ),
	%( %rLocal ),
	%( %noRouting ))

%Request(1012h,AvailableForUse,lExchNotPresent,0,0,0,0,
	%( %none ),
	%( %rLocal ),
	%( %noRouting ))

%Request(1013h,AvailableForUse,lExchNotPresent,0,0,0,0,
	%( %none ),
	%( %rLocal ),
	%( %noRouting ))

%Request(1014h,AvailableForUse,lExchNotPresent,0,0,0,0,
	%( %none ),
	%( %rLocal ),
	%( %noRouting ))

%Request(1015h,AvailableForUse,lExchNotPresent,0,0,0,0,
	%( %none ),
	%( %rLocal ),
	%( %noRouting ))

%Request(1016h,TerminateVideo,vExchNotInstalled,0,2,0,0,
	%( %w(12) ),
	%( %rLocal ),
	%( %noRouting ))

%Request(1017h,QuietFileSys,vExchFilterPros,0FFFFh,2,0,0,
	%( %w(12) ),
	%( %rLocal ),
	%( %noRouting ))

%Request(1018h,DebugSignal,vExchNotInstalled,0,6,1,1,
	%( %none ),
	%( %rLocal ),
	%( %noRouting ))

%Request(1019h,GoDebugger,vExchNotInstalled,000Eh,6,2,1,
	%( %w(14) %pbcb0 %p(24) %p(30) %c(01,28) %c(01,34) )
	%( %rLocal ),
	%( %noRouting ))

%Request(101Ah,RemoteTermination,vExchNotInstalled,6h,2,0,0,
	%( %w(12) ),
	%( %rBroadcast ),
	%( %noRouting ))

;
; WARNING! Do not add to the 1000h or 2000h level without consulting 
;          STandard Software.
; - The loadable request file Request.VM.txt defines level 1000h and 2000 
;   requests starting with 101Bh.
;
;  The level 2 block at 2000h has procedural interfaces.
;
;
%Request(2000h,ReadHardId,vExchHwId,0,2,0,1,
	%( %p(14) %c(2,18) ),
	%( %rMasterFp ),
	%( %noRouting) )

%Request(2001h,WriteHardId,vExchHwId,0,2,0,0,
	%( %w(12) ),
	%( %rMasterFp ), 
	%( %noRouting) )

;  The level 3 block at 3000h has no procedural interfaces
;
;
%Request(3000h,PtResponse,0,0,0,0,0,
	%( %none ),%( %rLocal ), %(%noRouting))

%Request(3001h,GetStatistics,vExchResex,0701h,2,0,5,
	%( %none ),%( %rFileId ), %(%noRouting))

%Request(3002h,RemoteBoot, vExchResex, 0100h, 4, 0, 0,
	%( %none ),%( %rLocal ), %(%noRouting))

%Request(3003h,UFSOpen, lExchUFS, 0, 26, 1, 1, %(%none),%( %rLocal ), %(%noRouting))

%Request(3004h,UFSRead, lExchUFS, 0, 12, 0, 2, %(%none),%( %rLocal ), %(%noRouting))

%Request(3005h,UFSWrite, lExchUFS, 0, 12, 1, 1, %(%none),%( %rLocal ), %(%noRouting))

%Request(3006h,UFSClose, lExchUFS, 0, 12, 0, 0, %(%none),%( %rLocal ), %(%noRouting))

%Request(3007h,UFSAccess, lExchUFS, 0, 22, 1, 1, %(%none),%( %rLocal ), %(%noRouting))

%Request(3008h,UFSLink, lExchUFS, 0, 28, 1, 0, %(%none),%( %rLocal ), %(%noRouting))

%Request(3009h,UFSDelete, lExchUFS, 0, 20, 1, 0, %(%none),%( %rLocal ), %(%noRouting))

%Request(300Ah,UFSStat, lExchUFS, 0, 20, 1, 1, %(%none),%( %rLocal ), %(%noRouting))

%Request(300Bh,UFSFStat, lExchUFS, 0, 8, 0, 1, %(%none),%( %rLocal ), %(%noRouting))

%Request(300Ch,UFSChange, lExchUFS, 0, 22, 2, 0, %(%none),%( %rLocal ), %(%noRouting))

%Request(300Dh,UFSMount, lExchUFS, 0, 10, 0, 0, %(%none),%( %rLocal ), %(%noRouting))

%Request(300Eh,UFSUMount, lExchUFS, 0, 2, 0, 0, %(%none),%( %rLocal ), %(%noRouting))

%Request(300Fh,UFSSync, lExchUFS, 0, 0, 0, 0, %(%none),%( %rLocal ), %(%noRouting))

%Request(3010h,UpdateMountTable,vExchFilterPros2, 0D0Eh, 2, 2, 0, %(%none),%( %rBroadcast ), %(%noRouting))

%Request(3011h,QueryRedirectStatus,lExchObsolete,00700h,0,0,1,%(%none),%( %rLocal ), %(%noRouting))

%Request(3012h,OpenTerminal,vExchTpReq,0,4,0,1,%(%none),%( %rFileId ), %(%noRouting))

%Request(3013h,CloseTerminal,vExchTpReq,0,4,0,0,%(%none),%( %rFileId ), %(%noRouting))

%Request(3014h,WhereTerminalBuffer,vExchTpReq,0,4,0,1,%(%none),%( %rFileId ), %(%noRouting))

%Request(3015h,ReadTerminal,vExchTpReq,0,6,0,2,%(%none),%( %rFileId ), %(%noRouting))

%Request(3016h,SetTerminal,vExchTpReq,0,6,1,1,%(%none),%( %rFileId ), %(%noRouting))

%Request(3017h,SetTerminalOwner,vExchTpReq,0,6,0,0, %(%none),%( %rFileId ), %(%noRouting))

%Request(3018h,RingOutTerminal,vExchTpReq,0,4,0,0, %(%none),%( %rFileId ), %(%noRouting))

%Request(3019h,DrainTerminalOutput,vExchTpReq,0,4,0,0, %(%none),%( %rFileId ), %(%noRouting))

%Request(301Ah,UFSUStat, lExchUFS, 0, 2, 0, 1, %(%none),%( %rLocal ), %(%noRouting))

%Request(301Bh, UFSUTimes, lExchUFS, 0, 20, 2, 0, %(%none),%( %rLocal ), %(%noRouting))

%Request(301Ch, UFSDummy, lExchUFS, 0, 0, 0, 0, %(%none),%( %rRemote ), %(%noRouting))

%Request(301Dh, UFSDummy, lExchUFS, 0, 0, 0, 0, %(%none),%( %rLocal ), %(%noRouting))

%Request(301Eh, UFSDummy, lExchUFS, 0, 0, 0, 0, %(%none),%( %rLocal ), %(%noRouting))

%Request(301Fh, UFSDummy, lExchUFS, 0, 0, 0, 0, %(%none),%( %rLocal ), %(%noRouting))

%Request(3020h, UFSDummy, lExchUFS, 0, 0, 0, 0, %(%none),%( %rLocal ), %(%noRouting))

%Request(3021h, UFSDummy, lExchUFS, 0, 0, 0, 0, %(%none),%( %rLocal ), %(%noRouting))

%Request(3022h, UFSDummy, lExchUFS, 0, 0, 0, 0, %(%none),%( %rRemote ), %(%noRouting))

%Request(3023h, UFSDummy, lExchUFS, 0, 0, 0, 0, %(%none),%( %rRemote ), %(%noRouting))

%Request(3024h,UpdateDCB,lExchObsolete,0,6,3,0,
	    %( %none ),
	    %( %rLocal ),
	    %( %noRouting ))

%Request(3025h,ReadRemote,vExchFilSys2,200h,6,0,2,
	    %( %fh %p0 %s0 %lfa %p1 %c(2,28) ),
	    %( %rHandle %dmaLocal ),
	    %( %noRouting ))

%Request(3026h,WriteRemote,vExchFilSys2,201h,6,1,1,
	    %( %fh %p0 %s0 %lfa %p1 %c(2,28) ),
	    %( %rHandle %dmaLocal ),
	    %(%noRouting))

%Request(3027h,CleanupRemoteExecution,lExchObsolete,0800h,0,0,0, %(%none),%( %rLocal ), %(%noRouting))

%Request(3028h,SetIoRedirectionMode,lExchObsolete,0900h,2,0,0, %(%none),%( %rLocal ), %(%noRouting))

%Request(3029h,UffTerminal,0,0,6,2,3, %(%none),%( %rFileId ), %(%noRouting))

%Request(302Ah,WriteTerminal,0,0,4,1,0,%(%none),%( %rFileId ), %(%noRouting))

%Request(302Bh,SizeWindow,0,0,6,0,1, %(%none),%( %rFileId ), %(%noRouting))

%Request(302Ch,PlaceWindow,0,0,6,0,1, %(%none),%( %rFileId ), %(%noRouting))

%Request(302Dh,CreateWindow,0,0,6,0,2, %(%none),%( %rFileId ), %(%noRouting))

%Request(302Eh,DeleteWindow,0,0,6,0,1, %(%none),%( %rFileId ), %(%noRouting))

%Request(302Fh,SelectWindow,0,0,4,0,1, %(%none),%( %rFileId ), %(%noRouting))

%Request(3030h,GetWindowLayout,0,0,4,0,1, %(%none),%( %rFileId ), %(%noRouting))

%Request(3031h,CatchWindowKeys,0,0,4,0,2, %(%none),%( %rFileId ), %(%noRouting))

%Request(3032h,SetWindowText,0,0,4,2,0, %(%none),%( %rFileId ), %(%noRouting))

%Request(3033h,MultibusRequest,vExchResex,0D24h,6,0,0,%( %b(12) %b(13) %p(14) ),%( %rLocal ), %(%noRouting))
%Request(3034h,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3035h,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3036h,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3037h,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3038h,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3039h,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(303Ah,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(303Bh,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(303Ch,TpTerminate,vExchTpReq,0,2,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(303Dh,FlushLog,lExchObsolete,0903h,6,1,0,%(%p0 %s0 ),%( %rMasterFp ), %(%noRouting))
%Request(303Eh,StartPT,vExchSrpAgent,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(303Fh,TapeRegisterSlave,vExchTape,7,4,0,0,%(%b(12) %b(13) %b(14)),%( %rDevice ), %(%DevSpec))
%Request(3040h,LocalOpenTape,vExchTape,8,6,1,1,
	%( %p0 %s0 %b(12) %b(13) %b(14) %w(16) %p1 %c(2,28) ),%( %rLocal ), %(%noRouting))
%Request(3041h,LocalPurgeTapeUser,vExchTape,9,2,0,0,
	%( %w(12) ),%( %rLocal ), %(%noRouting))
%Request(3042h,TerminatePT,vExchSrpAgent,2,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3043h,RPTia,lExchTia,0,6,1,0,%(%none),%( %rFileId ), %(%noRouting))
%Request(3044h,LocalConfigureSpooler, lExchSplr,0000h,6,3,0,
	%( %b(12) %p0 %s0 %p1 %s1 %p2 %s2 %b(13) %b(14) ),%( %rLocal ), %(%noRouting))
%Request(3045h,LocalSpoolerPassword,lExchSplr,0001h,6,2,0,
	%( %p0 %s0 %p1 %s1 ),%( %rLocal ), %(%noRouting))
%Request(3046h,LocalResetSplr,lExchSplr,0000,2,0,0, %( %w(12)),%( %rLocal ), %(%noRouting))
%Request(3047h,TerminatePtEmulation-obsolete,lExchNotPresent,0000h,0,0,0,
	%( %none ),
	%( %rLocal ),
	%( %noRouting ))
%Request(3048h,MegaFrameDisableCluster,vExchSrpAgent,0,6,0,0,
		%( %w(12) %w(14) %w(16)),
		%( %rBroadcast ),
		%( %noRouting ))
%Request(3049h,HistRqCode,0,0,10,0,1,%( %w(12) %w(14) %w(16) %w(20) %w(18) %w(24) %w(22) %w(26) ),%( %rLocal ), %(%noRouting))
%Request(304Ah,RebootMasterFp,0,0,4,0,0,%(%w(12) %w(14)),%( %rRemote ), %(%noRouting))
%Request(304Bh,GetIobQueue-obsolete,lExchNotPresent,0000h,0,0,0,
	%( %none ),
	%( %rLocal ),
	%( %noRouting ))
%Request(304Ch,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(304Dh,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(304Eh,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(304Fh,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3050h,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3051h,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3052h,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3053h,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3054h,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3055h,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3056h,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3057h,MultiAp,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(3058h,InternalChangeUserNumFs-obsolete,lExchNotPresent,0000h,0,0,0,
	%( %none ),
	%( %rLocal ),
	%( %noRouting ))
%Request(3059h,Reserved,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(305Ah,Reserved,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(305Bh,Reserved,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(305Ch,Reserved,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(305Dh,Reserved,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(305Eh,Reserved,0,0,0,0,0,%(%none),%( %rLocal ), %(%noRouting))
%Request(305Fh,FilterProsTermination,lExchNotPresent,0000h,2,0,0,
	%( %none ),
	%( %rBroadcast ),
	%(%noRouting))

%Request(3060h,TermVideoClient,lExchVideo,0,2,0,0,
		%(%w(12) ),
		%( %rLocal ),
		%( %noRouting ))


;  The following are negative request codes.

%UsrRequestInit

%UsrRequest(-1,DCCommand,vExchNotInstalled,0000h,3,1,1,
	%( %illegal ),
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-2,DCReport,vExchNotInstalled,0000h,2,0,1,
	%( %illegal ),
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-3,BMCommand,vExchNotInstalled,0000h,4,1,1,
	%( %illegal ),
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-4,BMReport,vExchNotInstalled,0000h,2,0,1,
	%( %illegal ),
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-5,BMQuery,vExchNotInstalled,0000h,0,0,1,
	%( %illegal ),
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-6,BMClear,vExchNotInstalled,0000h,2,0,0,
	%( %none ),
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-7,BMPurge,vExchNotInstalled,0000h,2,0,0,
	%( %none ),
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-8,BMChangeUser,vExchNotInstalled,0000h,2,0,0,
	%( %none ),
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-9,QuietBMulti,vExchNotInstalled,0000h,2,0,0,
	%( %none ),
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-10,DCReserve,vExchNotInstalled,0000h,0,0,0,
	%( %illegal ),
	%( %rRemote ),
	%( %norouting ))

;* obsolete request
%UsrRequest(-11,LoadKbdxlat,lExchObsolete,0000h,2,0,0,
	%( %w(12) )
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-12,GetKbdID,vExchKbd,0014h,0,0,1,
	%( %p(12) %c(2,16) ),
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-13,ReadMCR,vExchMcr,0000h,6,0,2,
	%( %w(12) %p(18) %w(22) %p(24) %c(2,28) ),
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-14,PurgeMCR,vExchMcr,0000h,0,0,0,
	%( %none ),
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-15,FillBufMCR,vExchMcr,0000h,0,1,0,
	%( %w(16) %p(12) ),
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-16,TerminateMCR,vExchMcr,0000h,2,0,0,
	%( %w(12) ),
	%( %rRemote ),
	%( %norouting ))

;* obsolete request
%UsrRequest(-17,LoadKbdXlatFh,lExchObsolete,0000h,2,0,0,
	%( %w(12) ),
	%( %rRemote ),
	%( %norouting ))

%UsrRequest(-18,SetDMAHandler,vExchResex,0D80h,10,0,0,
	%( %w(12) %p(14) %w(18) %w(20) ),
	%( %rRemote ),
	%( %noRouting ))




%TerminationRequest(20)		; QuietMassIo
%TerminationRequest(70)		; ResetKbd
%TerminationRequest(71)		; ResetSysIn
%TerminationRequest(96)		; PurgeISAM
%TerminationRequest(108)	; StopEm3270
%TerminationRequest(153)        ; CloseAllCommLines
%TerminationRequest(164)        ; ResetQueMgr
%TerminationRequest(169)        ; PurgeX25User
%TerminationRequest(195)	; PurgeTapeUser
%TerminationRequest(197)        ; ResetSplr
%TerminationRequest(233)        ; TerminateSNAUser
%TerminationRequest(239)        ; PurgeMailUser
%TerminationRequest(270)	; CtNetTermination
%TerminationRequest(273)	; CMTermination
%TerminationRequest(274)	; Filter Process Termination
%TerminationRequest(370)	; TerminateScsiUser
%TerminationRequest(384)	; ResetRemoteCache
%TerminationRequest(413)	; TerminateNameMgr
%TerminationRequest(460)	; TerminateNvram
%TerminationRequest(1009h)	; TerminateCommLine
%TerminationRequest(100Fh)	; Terminate keyboard process and timers
%TerminationRequest(1016h)	; TerminateVideo
%TerminationRequest(303Ch)	; Terminate any Open Read or Drain Rqs
%TerminationRequest(305Fh)	; FilterProcessTermination
%TerminationRequest(3060h)	; Video Client Termination
%TerminationRequest(-6)		; Request code for BMClear
%TerminationRequest(-16)	; Unlink queued rq blks of a terminating 
EVEN
;
;  The list of request codes which the CTOS master workstation
;  agent or the CtNetServer issues on behalf of cluster workstation
;  when the master or the CtNetServer determines that a cluster
;  workstation is not communicating with it any more.
;

%WsAbortRequest(20)		; QuietMassIo
%WsAbortRequest(70)		;* ResetKbd
%WsAbortRequest(71)		;* ResetSysIn
%WsAbortRequest(96)		; PurgeISAM
%WsAbortRequest(108)		; StopEm3270
%WsAbortRequest(112)		; FileSystemAbort
%WsAbortRequest(148)		; PurgeQueueServer
%WsAbortRequest(153)		; CloseAllCommLines
%WsAbortRequest(195)		; PurgeTapeUser
%WsAbortRequest(197)		;* ResetSplr
%WsAbortRequest(201)		; VacateParCleanup 
%WsAbortRequest(229)		; PurgeSNAUser
%WsAbortRequest(239)		; PurgeMailUser
%WsAbortRequest(251)		; PurgeMailUniqueId
%WsAbortRequest(267)		; PurgeX25
%WsAbortRequest(274)		;* Filter Process
%WsAbortRequest(413)		; TerminateNameMgr
%WsAbortRequest(460)		; Terminate Nvram
%WsAbortRequest(305Fh)		; FilterProcessTermination
%WsAbortRequest(3060h)		; Video Client Termination
%WsAbortRequest(-7)			; Request code for BMPurge
EVEN

;  The list of request codes which a Multi-Partitioned CTOS
;  issues on behalf of a system service to notify other system
;  services its user number is changing. These requests are
;  issued when the system service does a ConvertToSys request.
;  The system service's new user number is contained in a word
;  at offset 4 in the request block. The system service's
;  previous user number is contained in a word at offset 12 in
;  the request block.
;  CTOS II does not require ChangeUserNum requests. They are defined
;  here for mixed cluster compatibilty (e.g. CTOS II master/CTOS I cluster).
;

%ChgUserNumRequest(218)		; ChangeUserNumQmg
%ChgUserNumRequest(219)		; ChangeUserNumFs
%ChgUserNumRequest(259)		; ChangeUserNumMail
%ChgUserNumRequest(1000h)	; ChangeUserNumISAM
%ChgUserNumRequest(100Ah)	; ChangeUserNumComm
%ChgUserNumRequest(-8)		; ChangeUserNumBMulti
;
; The list of request codes which the CTOS termination process
; issues to quiet the process activities before subsystem
; swap-out (invoked with "SuspendContext").  The requests
; are generated with one argument 'ercSwapping' and with request
; numbers as given to the macro.
; List the requests that cure the most common outstanding requests
; first. Swapping algorithm stops early when there are no more
; outstanding requests, avoiding lengthy requests like
; 'QuietISAMUser' as ISAM is rarely in use.
;

%SwappingRequest(265)		; QuietKbdForSwap
%SwappingRequest(274)		;* Quiet Filter Process
%SwappingRequest(260)		; QuietMailUser
%SwappingRequest(1001h)		; QuietISAMUser
%SwappingRequest(1003h)		; QuietQMGR
%SwappingRequest(1004h)		; QuietSplr
%SwappingRequest(1017h)		; QuietFileSys
%SwappingRequest(305Fh)		; FilterProcessTermination
%SwappingRequest(3060h)		; Video Client Termination
%SwappingRequest(20)		; QuietMassIo
%SwappingRequest(371)		; QuietScsi
%SwappingRequest(385)		; QuietRemoteCache
%SwappingRequest(-9)		; QuietBMulti

%Final

END
