$title(ScsiUtil_ISK)
$pagewidth(132)
$pagelength(60)
$mod286
;
; Time-Critical code for ISK SCSI Device Driver
;
; (set your editor tab length to 8 when in here)
;
%set(debug, 0)
%set(lta, 0)
%set(sgen, 0)

%if (%lta) then(
%*define (Trigger(b)) (%'
		mov	al, %b			; LTA trigger
%if (%sgen) then(%'
		out	98h, al			; LTA trigger
)else(%'
		mov	dx, 8404h		; LTA trigger
		out	dx, al			; LTA trigger
)fi%'
)%'
)else(
%*define(Trigger(b))()%'
)fi

ScsiUtil_ISK	segment	public 'Code'

		public	MyTss
		public	SelectIskTarget

%if (%debug) then(%'
		public	Arbitrating
		public	BusBusy
		public	Collision
		public	StartSelection
		public	TestBusFree
		public	WaitSelection
		public	WonArbitration
)fi%'

ScsiUtil_ISK	ends

DGroup		group	Data
Data		segment	public 'Data'

%if (%debug) then(%'
		public	cIskCollision
		public	minArbLoops
		public	minCollisionLoops

cIskCollision	dw	0
minArbLoops	dw	0FFFFh
minCollisionLoops dw	0FFFFh
)fi%'

Data		ends

ScsiUtil_ISK	segment
		assume	cs: ScsiUtil_ISK
		assume	ds: DGroup
$eject
MyTss		proc far

		str	ax
		ret	0

MyTss		endp
$eject
;
; SelectIskTarget: PROCEDURE(dataReg, initiatorIdReg, processorCtrlReg, 
;                            interruptReg, commenceArbitrationReg, 
;                            initiatorId, selectionIDs) WORD
;
; Time-critical part of the SCSI target selection process for the ISK.
; Procedure returns (in AX):
;
;	0:	Selected (bus may or may not be in MESSAGE OUT phase yet)
;	1:	Bus is busy, try again later
;	2:	Reselect collision (like case 1, but BSY asserted at ISK)
;	3:	Protocol error detected (unexpected bus state)
;	4:	No selection yet (set PIT for 250ms and wait)
;

dataReg			equ	word ptr 18 [bp]
initiatorIdReg		equ	word ptr 16 [bp]
statusReg		equ	initiatorIdReg
processorCtrlReg	equ	word ptr 14 [bp]
interruptReg		equ	word ptr 12 [bp]
commenceArbitrationReg	equ	word ptr 10 [bp]
initiatorId		equ	byte ptr  8 [bp]
selectionIDs		equ	byte ptr  6 [bp]
sArgs			equ	14

SelectIskTarget	proc far

		push	bp
		mov	bp, sp

		mov	ah, selectionIDs	; Our own and target ID bits
		mov	al, initiatorId
		mov	dx, initiatorIdReg	; Program our own ID bit
		out	dx, al

		mov	si, interruptReg	; To avoid stack fetch later
		mov	di, processorCtrlReg	; Ditto
		mov	dx, statusReg		; Referenced in bus free loop
		mov	cx, dataReg		; For quick use after bus free

		pushf				; Save processor state
		cli				; DISABLE

TestBusFree:	in	al, dx
		and	al, 30h			; mBSY OR mSEL
		mov	bl, al
		in	al, dx
		and	al, 30h
		cmp	al, bl
		 jne	TestBusFree		; Signals unstable--retest
		or	al, al
		 jnz	BusBusy

%Trigger(80h)

StartSelection:	mov	dx, cx			; Data register
		mov	al, ah			; Our own and target ID bits
		out	dx, al

		mov	dx, commenceArbitrationReg
		mov	al, 1
		out	dx, al			; Start ISK arbitrator

		mov	dx, si			; InterruptReg
		mov	cx, 1000			; Overly generous.....

Arbitrating:	in	al, dx
		test	al, 10h			; mReselectINT
		 jnz	Collision

		test	al, 02h			; mArbINT
		 jnz	WonArbitration

		loop	Arbitrating

		mov	ax, 3			; This is a protocol error
		jmp	short ExitEnable

BusBusy:	mov	ax, 1
		jmp	short ExitEnable

Collision:	mov	dx, di
		mov	ax, 88h			; mEnableISK OR mAssertBSY
		out	dx, ax			; Stop ISK arbitrator

%Trigger(10h)

%if (%debug) then(%'
		inc	cIskCollision
		cmp	cx, minCollisionLoops
		 jae	.+6
		mov	minCollisionLoops, cx
)fi%'
		mov	ax, 2

ExitEnable:	popf
		pop	bp
		ret	sArgs

WonArbitration:	popf				; End of critical section

%if (%debug) then(%'
		cmp	cx, minArbLoops
		 jae	.+6
		mov	minArbLoops, cx
)fi%'

		mov	cx, 1000			; Loop control for selection

WaitSelection:	in	al, dx
		test	al, 1			; mSelectINT
		 jnz	SelectionDone
		test	al, 8			; mMsgPhaseInt
		 jnz	SelectionDone

		loop	WaitSelection

		mov	ax, 4			; Selection still in progress
		jmp	short WeBeDone

%Trigger(40h)

SelectionDone:	xor	ax, ax			; Oh, sweet mystery of life...

WeBeDone:	pop	bp
		ret	sArgs

SelectIskTarget	endp

ScsiUtil_ISK	ends

end

;
; Log
;
; 01/08/91 MTR	Created
; 06/16/92 PGJ	Loop waiting for selection done, not MESSAGE IN phase (SCSI
;		places no maximum time limits on the first REQ after selection)
; 07/08/92 PGJ	More code optimizations so that the write to ISK data register 
;		(for selection ID's) is guaranteed to occur BEFORE a target 
;		reselection can complete.  This is necessary to avoid 
;		reselection collision problems where the reference to the ISK 
;		data register arms the ISK's SCSI REQ/ACK logic and permits 
;		the reconnecting target to progress from the IDENTIFY message 
;		to some other information transfer phase without the ISK 
;		driver reading the IDENTIFY message from the bus.  The symptom 
;		of this occurrence is 'ercScsiProtocolError' when the SCSI bus 
;		is found to be in some phase other than MESSAGE IN after a 
;		reselection.  If this problem ever surfaces again, the 
;		recommended work-around is to modify the SCSI driver to act 
;		"as if" an IDENTIFY message for LUN 0 has in fact been 
;		received; the drawback of this approach is that the ISK driver 
;		will not be qualified to work with SCSI LUN's other than zero.
; 10/10/92 LFL	MsgPhaseINT processing added for selection in addition
;		to increasing the loop count to 600 to allow operation with dds
;		tape on B38-EXP's.
; 11/11/92 LFL	Loop count 1000 for proper reselection on downrev.
;		machines with Japanese VAM/Keyboards.
; 01/26/93 MTR	Add MyTss (used by debugging code)
;
