;
;	FsSegmentOrder_All.Asm
;
; This module is linked first in a File System link list.
; It controls segment ordering in the link.
;
; Note: the class name 'LowMem' must not be changed as it is referred to by
; other modules in the OS.
;

SegMartSeg	SEGMENT	PUBLIC 'Coed'
SegMartSeg	ENDS

SegMartGroup GROUP SegMartSeg

%IF(%CtosP) THEN (

Const	SEGMENT PUBLIC 'Const'
Const	ENDS

Stack	SEGMENT	PUBLIC 'Stack'
Stack	ENDS

Data	SEGMENT	PUBLIC 'Data'
Data	ENDS

OsTable	SEGMENT PUBLIC 'Data'
OsTable	ENDS

Memory	SEGMENT	PUBLIC 'Memory'
Memory	ENDS

) ELSE (%' Real mode 186 MF

OsTable	SEGMENT PUBLIC 'Data'
OsTable	ENDS

Data	SEGMENT	PUBLIC 'Data'
Data	ENDS

Stack	SEGMENT	PUBLIC 'Stack'
Stack	ENDS

Const	SEGMENT PUBLIC 'Const'
Const	ENDS

Memory	SEGMENT	PUBLIC 'Memory'
Memory	ENDS

) FI
; UfbSeg	SEGMENT	PUBLIC 'FSData'
; UfbSeg	ENDS
; Not usually used, last anyway, don't mention so no nil segment created
;  which would mess up debugger symbols.

DGroup	GROUP	Const, Stack, Data, OsTable, Memory

END

;LOG
; 8/24/86 by JA		Created
;11/21/86 by JA 	OsTable last, stack before data.
; 2/16/88 by JA		Make _FP real mode version.
;10/06/88 by PGJ	Merge Real and Protected mode manuscripts,
;			conditional assembly from FsSegmentOrder_R.Asm
;			and FsSegmentOrder_P.Asm
; 9/27/89 by JA		Add FSData for Fab,Ufb segments.
;05/23/90 by MTR	Add SegMartGroup