/* sync.c -- JCL synchronizer */

#include "sync.h"

char ProcName[4];
struct syncrq *rq, rqblk = {2, 0, 0, 1, 0, 0, 0, 0, 0xFF, ProcName, 4};

int RqNum;

main()
{
	int erc;
	char myslot, mytype, mynumber, namelen;

	RqNum = getrqnumber();

	/* build request block and request it */
	checkerc(getusernumber(&rqblk.userNum));
	checkerc(allocexch(&rqblk.exchResp));
	/* don't check getprocinfo erc as it may run on workstation */
	getprocinfo(&myslot, &mytype, &mynumber, ProcName, 4, &namelen);
	erc = request(&rqblk);
	if(erc != 0 && erc != 33)
		errorexit(erc);

	/* if erc 33 serve request, else get response and exit */
	if(erc == 33)
		server();
	else
		checkerc(wait(rqblk.exchResp, &rq));
	exit();
}

server()
/* respond to all requests for this rqnumber -- exit if fDeinstall set */
{
	int erc, fDeinstall;

	fDeinstall = 0;
	checkerc(serverq(RqNum, rqblk.exchResp));

	/* serve requests, checking for deinstall flag */
	while(!fDeinstall) {
		if(erc = wait(rqblk.exchResp, &rq))
			crash(erc);
		rq->ercRet = 0;
		strncpy(rq->pbProc, ProcName, 4);
		fDeinstall = rq->fDeinstall;
		if(erc = respond(rq))
			crash(erc);
	}

	/* deinstall and exit */
	if(erc = serverq(RqNum, 0))
		crash(erc);
	do {
		erc = check(rqblk.exchResp, &rq);
		if(erc != ERCOK && erc != NOMSGERC)
			crash(erc);
	} while (erc != NOMSGERC);
	exit();
}

getrqnumber()
/* returns the request number parameter -- side effect of filling in the 
 * request block's request number field.
 */
{
	char param[40];
	int erc, i, Number;

	/* get param and convert to sync request number */
	if(!CSubParams(1))
		rqblk.rqCode = Number = RQBASE;
	else {
		getparam(1, 0, param);
		Number = hextoi(param);
		if(!Number || (Number > SYNCRQS && Number < USERRQBASE))
			errorexit(BADRQERC);
		if(Number <= SYNCRQS)
			rqblk.rqCode = Number = RQBASE + Number - 1;
		else
			rqblk.rqCode = Number;
	}
	if(erc = queryrequestinfo(Number, (char *)0, 0))
		errorexit(erc);
	return(Number);
}

hextoi(s)
char s[];
{
	int i, n;

	for(n = i = 0; toupper(s[i]); i++) 
		if(s[i] >= '0' && s[i] <= '9')
			n = n * 16 + s[i] - '0';
		else 
			if(s[i] >= 'A' && s[i] <= 'F')
				n = n * 16 + s[i] - 'A' + 10;
			else
				break;
	return(n);
}
